/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.observers;

import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.util.BlockingHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import java.util.concurrent.CountDownLatch;

public abstract class BlockingBaseObserver<T>
extends CountDownLatch
implements Observer<T>,
Disposable {
    T value;
    Throwable error;
    Disposable upstream;
    volatile boolean cancelled;

    public BlockingBaseObserver() {
        super(1);
    }

    @Override
    public final void onSubscribe(Disposable d15) {
        this.upstream = d15;
        if (this.cancelled) {
            d15.dispose();
        }
    }

    @Override
    public final void onComplete() {
        this.countDown();
    }

    @Override
    public final void dispose() {
        this.cancelled = true;
        Disposable d15 = this.upstream;
        if (d15 != null) {
            d15.dispose();
        }
    }

    @Override
    public final boolean isDisposed() {
        return this.cancelled;
    }

    public final T blockingGet() {
        Throwable e15;
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex4) {
                this.dispose();
                throw ExceptionHelper.wrapOrThrow(ex4);
            }
        }
        if ((e15 = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow(e15);
        }
        return this.value;
    }
}

