/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.flowables.ConnectableFlowable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.fuseable.HasUpstreamPublisher;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.QueueSubscription;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowablePublish<T>
extends ConnectableFlowable<T>
implements HasUpstreamPublisher<T> {
    final Publisher<T> source;
    final int bufferSize;
    final AtomicReference<PublishConnection<T>> current;

    public FlowablePublish(Publisher<T> source, int bufferSize) {
        this.source = source;
        this.bufferSize = bufferSize;
        this.current = new AtomicReference();
    }

    @Override
    public Publisher<T> source() {
        return this.source;
    }

    @Override
    public void connect(Consumer<? super Disposable> connection) {
        PublishConnection<T> conn;
        boolean doConnect = false;
        while ((conn = this.current.get()) == null || conn.isDisposed()) {
            PublishConnection<T> fresh = new PublishConnection<T>(this.current, this.bufferSize);
            if (!this.current.compareAndSet(conn, fresh)) continue;
            conn = fresh;
            break;
        }
        doConnect = !conn.connect.get() && conn.connect.compareAndSet(false, true);
        try {
            connection.accept(conn);
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            throw ExceptionHelper.wrapOrThrow(ex4);
        }
        if (doConnect) {
            this.source.subscribe(conn);
        }
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        PublishConnection<Object> conn;
        while ((conn = this.current.get()) == null) {
            PublishConnection<T> fresh = new PublishConnection<T>(this.current, this.bufferSize);
            if (!this.current.compareAndSet(conn, fresh)) continue;
            conn = fresh;
            break;
        }
        InnerSubscription<T> inner = new InnerSubscription<T>(s15, conn);
        s15.onSubscribe(inner);
        if (conn.add(inner)) {
            if (inner.isCancelled()) {
                conn.remove(inner);
            } else {
                conn.drain();
            }
            return;
        }
        Throwable ex4 = conn.error;
        if (ex4 != null) {
            inner.downstream.onError(ex4);
        } else {
            inner.downstream.onComplete();
        }
    }

    @Override
    public void reset() {
        PublishConnection<T> conn = this.current.get();
        if (conn != null && conn.isDisposed()) {
            this.current.compareAndSet(conn, null);
        }
    }

    static final class InnerSubscription<T>
    extends AtomicLong
    implements Subscription {
        private static final long serialVersionUID = 2845000326761540265L;
        final Subscriber<? super T> downstream;
        final PublishConnection<T> parent;
        long emitted;

        InnerSubscription(Subscriber<? super T> downstream, PublishConnection<T> parent) {
            this.downstream = downstream;
            this.parent = parent;
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.addCancel(this, n15);
                this.parent.drain();
            }
        }

        @Override
        public void cancel() {
            if (this.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                this.parent.remove(this);
                this.parent.drain();
            }
        }

        public boolean isCancelled() {
            return this.get() == Long.MIN_VALUE;
        }
    }

    static final class PublishConnection<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Disposable {
        private static final long serialVersionUID = -1672047311619175801L;
        final AtomicReference<PublishConnection<T>> current;
        final AtomicReference<Subscription> upstream;
        final AtomicBoolean connect;
        final AtomicReference<InnerSubscription<T>[]> subscribers;
        final int bufferSize;
        volatile SimpleQueue<T> queue;
        int sourceMode;
        volatile boolean done;
        Throwable error;
        int consumed;
        static final InnerSubscription[] EMPTY = new InnerSubscription[0];
        static final InnerSubscription[] TERMINATED = new InnerSubscription[0];

        PublishConnection(AtomicReference<PublishConnection<T>> current, int bufferSize) {
            this.current = current;
            this.upstream = new AtomicReference();
            this.connect = new AtomicBoolean();
            this.bufferSize = bufferSize;
            this.subscribers = new AtomicReference<InnerSubscription[]>(EMPTY);
        }

        @Override
        public void dispose() {
            this.subscribers.getAndSet(TERMINATED);
            this.current.compareAndSet(this, null);
            SubscriptionHelper.cancel(this.upstream);
        }

        @Override
        public boolean isDisposed() {
            return this.subscribers.get() == TERMINATED;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.setOnce(this.upstream, s15)) {
                if (s15 instanceof QueueSubscription) {
                    QueueSubscription qs4 = (QueueSubscription)s15;
                    int m15 = qs4.requestFusion(7);
                    if (m15 == 1) {
                        this.sourceMode = m15;
                        this.queue = qs4;
                        this.done = true;
                        this.drain();
                        return;
                    }
                    if (m15 == 2) {
                        this.sourceMode = m15;
                        this.queue = qs4;
                        s15.request(this.bufferSize);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.bufferSize);
                s15.request(this.bufferSize);
            }
        }

        @Override
        public void onNext(T t15) {
            if (this.sourceMode == 0 && !this.queue.offer(t15)) {
                this.onError(new QueueOverflowException());
                return;
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
            } else {
                this.error = t15;
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        void drain() {
            boolean async;
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            SimpleQueue<T> queue = this.queue;
            int consumed = this.consumed;
            int limit = this.bufferSize - (this.bufferSize >> 2);
            boolean bl4 = async = this.sourceMode != 1;
            block2: while (true) {
                if (queue != null) {
                    InnerSubscription<T>[] consumers;
                    long minDemand = Long.MAX_VALUE;
                    boolean hasDemand = false;
                    for (InnerSubscription<T> inner : consumers = this.subscribers.get()) {
                        long request = inner.get();
                        if (request == Long.MIN_VALUE) continue;
                        hasDemand = true;
                        minDemand = Math.min(request - inner.emitted, minDemand);
                    }
                    if (!hasDemand) {
                        minDemand = 0L;
                    }
                    while (minDemand != 0L) {
                        boolean empty;
                        T v15;
                        boolean d15 = this.done;
                        try {
                            v15 = queue.poll();
                        }
                        catch (Throwable ex4) {
                            Exceptions.throwIfFatal(ex4);
                            this.upstream.get().cancel();
                            queue.clear();
                            this.done = true;
                            this.signalError(ex4);
                            return;
                        }
                        boolean bl5 = empty = v15 == null;
                        if (this.checkTerminated(d15, empty)) {
                            return;
                        }
                        if (empty) break;
                        for (InnerSubscription<T> inner : consumers) {
                            if (inner.isCancelled()) continue;
                            inner.downstream.onNext(v15);
                            ++inner.emitted;
                        }
                        if (async && ++consumed == limit) {
                            consumed = 0;
                            this.upstream.get().request(limit);
                        }
                        --minDemand;
                        if (consumers == this.subscribers.get()) continue;
                        continue block2;
                    }
                    if (this.checkTerminated(this.done, queue.isEmpty())) {
                        return;
                    }
                }
                this.consumed = consumed;
                if ((missed = this.addAndGet(-missed)) == 0) break;
                if (queue != null) continue;
                queue = this.queue;
            }
        }

        boolean checkTerminated(boolean isDone, boolean isEmpty) {
            if (isDone && isEmpty) {
                Throwable ex4 = this.error;
                if (ex4 != null) {
                    this.signalError(ex4);
                } else {
                    for (InnerSubscription inner : this.subscribers.getAndSet(TERMINATED)) {
                        if (inner.isCancelled()) continue;
                        inner.downstream.onComplete();
                    }
                }
                return true;
            }
            return false;
        }

        void signalError(Throwable ex4) {
            for (InnerSubscription inner : this.subscribers.getAndSet(TERMINATED)) {
                if (inner.isCancelled()) continue;
                inner.downstream.onError(ex4);
            }
        }

        boolean add(InnerSubscription<T> inner) {
            InnerSubscription[] u15;
            InnerSubscription<T>[] c15;
            do {
                if ((c15 = this.subscribers.get()) == TERMINATED) {
                    return false;
                }
                int len = c15.length;
                u15 = new InnerSubscription[len + 1];
                System.arraycopy(c15, 0, u15, 0, len);
                u15[len] = inner;
            } while (!this.subscribers.compareAndSet(c15, u15));
            return true;
        }

        void remove(InnerSubscription<T> inner) {
            InnerSubscription<T>[] c15;
            int len;
            while ((len = (c15 = this.subscribers.get()).length) != 0) {
                InnerSubscription[] u15;
                int j15 = -1;
                for (int i15 = 0; i15 < len; ++i15) {
                    if (c15[i15] != inner) continue;
                    j15 = i15;
                    break;
                }
                if (j15 < 0) {
                    return;
                }
                if (len == 1) {
                    u15 = EMPTY;
                } else {
                    u15 = new InnerSubscription[len - 1];
                    System.arraycopy(c15, 0, u15, 0, j15);
                    System.arraycopy(c15, j15 + 1, u15, j15, len - j15 - 1);
                }
                if (!this.subscribers.compareAndSet(c15, u15)) continue;
                break;
            }
        }
    }
}

