/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.mixed;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.mixed.ScalarXMapZHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableSwitchMapCompletable<T>
extends Completable {
    final Observable<T> source;
    final Function<? super T, ? extends CompletableSource> mapper;
    final boolean delayErrors;

    public ObservableSwitchMapCompletable(Observable<T> source, Function<? super T, ? extends CompletableSource> mapper, boolean delayErrors) {
        this.source = source;
        this.mapper = mapper;
        this.delayErrors = delayErrors;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        if (!ScalarXMapZHelper.tryAsCompletable(this.source, this.mapper, observer)) {
            this.source.subscribe(new SwitchMapCompletableObserver<T>(observer, this.mapper, this.delayErrors));
        }
    }

    static final class SwitchMapCompletableObserver<T>
    implements Observer<T>,
    Disposable {
        final CompletableObserver downstream;
        final Function<? super T, ? extends CompletableSource> mapper;
        final boolean delayErrors;
        final AtomicThrowable errors;
        final AtomicReference<SwitchMapInnerObserver> inner;
        static final SwitchMapInnerObserver INNER_DISPOSED = new SwitchMapInnerObserver(null);
        volatile boolean done;
        Disposable upstream;

        SwitchMapCompletableObserver(CompletableObserver downstream, Function<? super T, ? extends CompletableSource> mapper, boolean delayErrors) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.errors = new AtomicThrowable();
            this.inner = new AtomicReference();
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            SwitchMapInnerObserver current;
            CompletableSource c15;
            try {
                c15 = Objects.requireNonNull(this.mapper.apply(t15), "The mapper returned a null CompletableSource");
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.upstream.dispose();
                this.onError(ex4);
                return;
            }
            SwitchMapInnerObserver o15 = new SwitchMapInnerObserver(this);
            while ((current = this.inner.get()) != INNER_DISPOSED) {
                if (!this.inner.compareAndSet(current, o15)) continue;
                if (current != null) {
                    current.dispose();
                }
                c15.subscribe(o15);
                break;
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (this.errors.tryAddThrowableOrReport(t15)) {
                if (this.delayErrors) {
                    this.onComplete();
                } else {
                    this.disposeInner();
                    this.errors.tryTerminateConsumer(this.downstream);
                }
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            if (this.inner.get() == null) {
                this.errors.tryTerminateConsumer(this.downstream);
            }
        }

        void disposeInner() {
            SwitchMapInnerObserver o15 = this.inner.getAndSet(INNER_DISPOSED);
            if (o15 != null && o15 != INNER_DISPOSED) {
                o15.dispose();
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
            this.disposeInner();
            this.errors.tryTerminateAndReport();
        }

        @Override
        public boolean isDisposed() {
            return this.inner.get() == INNER_DISPOSED;
        }

        void innerError(SwitchMapInnerObserver sender, Throwable error) {
            if (this.inner.compareAndSet(sender, null)) {
                if (this.errors.tryAddThrowableOrReport(error)) {
                    if (this.delayErrors) {
                        if (this.done) {
                            this.errors.tryTerminateConsumer(this.downstream);
                        }
                    } else {
                        this.upstream.dispose();
                        this.disposeInner();
                        this.errors.tryTerminateConsumer(this.downstream);
                    }
                }
            } else {
                RxJavaPlugins.onError(error);
            }
        }

        void innerComplete(SwitchMapInnerObserver sender) {
            if (this.inner.compareAndSet(sender, null) && this.done) {
                this.errors.tryTerminateConsumer(this.downstream);
            }
        }

        static final class SwitchMapInnerObserver
        extends AtomicReference<Disposable>
        implements CompletableObserver {
            private static final long serialVersionUID = -8003404460084760287L;
            final SwitchMapCompletableObserver<?> parent;

            SwitchMapInnerObserver(SwitchMapCompletableObserver<?> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d15) {
                DisposableHelper.setOnce(this, d15);
            }

            @Override
            public void onError(Throwable e15) {
                this.parent.innerError(this, e15);
            }

            @Override
            public void onComplete() {
                this.parent.innerComplete(this);
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

