/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;

public final class ObservableScanSeed<T, R>
extends AbstractObservableWithUpstream<T, R> {
    final BiFunction<R, ? super T, R> accumulator;
    final Supplier<R> seedSupplier;

    public ObservableScanSeed(ObservableSource<T> source, Supplier<R> seedSupplier, BiFunction<R, ? super T, R> accumulator) {
        super(source);
        this.accumulator = accumulator;
        this.seedSupplier = seedSupplier;
    }

    @Override
    public void subscribeActual(Observer<? super R> t15) {
        R r15;
        try {
            r15 = Objects.requireNonNull(this.seedSupplier.get(), "The seed supplied is null");
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            EmptyDisposable.error(e15, t15);
            return;
        }
        this.source.subscribe(new ScanSeedObserver<T, R>(t15, this.accumulator, r15));
    }

    static final class ScanSeedObserver<T, R>
    implements Observer<T>,
    Disposable {
        final Observer<? super R> downstream;
        final BiFunction<R, ? super T, R> accumulator;
        R value;
        Disposable upstream;
        boolean done;

        ScanSeedObserver(Observer<? super R> actual, BiFunction<R, ? super T, R> accumulator, R value) {
            this.downstream = actual;
            this.accumulator = accumulator;
            this.value = value;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
                this.downstream.onNext(this.value);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t15) {
            R u15;
            if (this.done) {
                return;
            }
            R v15 = this.value;
            try {
                u15 = Objects.requireNonNull(this.accumulator.apply(v15, t15), "The accumulator returned a null value");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.upstream.dispose();
                this.onError(e15);
                return;
            }
            this.value = u15;
            this.downstream.onNext(u15);
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onComplete();
        }
    }
}

