/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.parallel;

import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.internal.schedulers.SchedulerMultiWorkerSupport;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelRunOn<T>
extends ParallelFlowable<T> {
    final ParallelFlowable<? extends T> source;
    final Scheduler scheduler;
    final int prefetch;

    public ParallelRunOn(ParallelFlowable<? extends T> parent, Scheduler scheduler, int prefetch) {
        this.source = parent;
        this.scheduler = scheduler;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers = RxJavaPlugins.onSubscribe(this, subscribers))) {
            return;
        }
        int n15 = subscribers.length;
        Subscriber[] parents = new Subscriber[n15];
        if (this.scheduler instanceof SchedulerMultiWorkerSupport) {
            SchedulerMultiWorkerSupport multiworker = (SchedulerMultiWorkerSupport)((Object)this.scheduler);
            multiworker.createWorkers(n15, new MultiWorkerCallback(subscribers, parents));
        } else {
            for (int i15 = 0; i15 < n15; ++i15) {
                this.createSubscriber(i15, subscribers, parents, this.scheduler.createWorker());
            }
        }
        this.source.subscribe(parents);
    }

    void createSubscriber(int i15, Subscriber<? super T>[] subscribers, Subscriber<T>[] parents, Scheduler.Worker worker) {
        Subscriber<? super T> a15 = subscribers[i15];
        SpscArrayQueue q15 = new SpscArrayQueue(this.prefetch);
        parents[i15] = a15 instanceof ConditionalSubscriber ? new RunOnConditionalSubscriber((ConditionalSubscriber)a15, this.prefetch, q15, worker) : new RunOnSubscriber<T>(a15, this.prefetch, q15, worker);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class RunOnConditionalSubscriber<T>
    extends BaseRunOnSubscriber<T> {
        private static final long serialVersionUID = 1075119423897941642L;
        final ConditionalSubscriber<? super T> downstream;

        RunOnConditionalSubscriber(ConditionalSubscriber<? super T> actual, int prefetch, SpscArrayQueue<T> queue, Scheduler.Worker worker) {
            super(prefetch, queue, worker);
            this.downstream = actual;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
                s15.request(this.prefetch);
            }
        }

        @Override
        public void run() {
            int missed = 1;
            int c15 = this.consumed;
            SpscArrayQueue q15 = this.queue;
            ConditionalSubscriber a15 = this.downstream;
            int lim = this.limit;
            do {
                long r15 = this.requested.get();
                long e15 = 0L;
                while (e15 != r15) {
                    int p15;
                    boolean empty;
                    Throwable ex4;
                    if (this.cancelled) {
                        q15.clear();
                        return;
                    }
                    boolean d15 = this.done;
                    if (d15 && (ex4 = this.error) != null) {
                        q15.clear();
                        a15.onError(ex4);
                        this.worker.dispose();
                        return;
                    }
                    Object v15 = q15.poll();
                    boolean bl4 = empty = v15 == null;
                    if (d15 && empty) {
                        a15.onComplete();
                        this.worker.dispose();
                        return;
                    }
                    if (empty) break;
                    if (a15.tryOnNext(v15)) {
                        ++e15;
                    }
                    if ((p15 = ++c15) != lim) continue;
                    c15 = 0;
                    this.upstream.request(p15);
                }
                if (e15 == r15) {
                    if (this.cancelled) {
                        q15.clear();
                        return;
                    }
                    if (this.done) {
                        Throwable ex5 = this.error;
                        if (ex5 != null) {
                            q15.clear();
                            a15.onError(ex5);
                            this.worker.dispose();
                            return;
                        }
                        if (q15.isEmpty()) {
                            a15.onComplete();
                            this.worker.dispose();
                            return;
                        }
                    }
                }
                if (e15 != 0L) {
                    BackpressureHelper.produced(this.requested, e15);
                }
                this.consumed = c15;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }

    static final class RunOnSubscriber<T>
    extends BaseRunOnSubscriber<T> {
        private static final long serialVersionUID = 1075119423897941642L;
        final Subscriber<? super T> downstream;

        RunOnSubscriber(Subscriber<? super T> actual, int prefetch, SpscArrayQueue<T> queue, Scheduler.Worker worker) {
            super(prefetch, queue, worker);
            this.downstream = actual;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
                s15.request(this.prefetch);
            }
        }

        @Override
        public void run() {
            int missed = 1;
            int c15 = this.consumed;
            SpscArrayQueue q15 = this.queue;
            Subscriber a15 = this.downstream;
            int lim = this.limit;
            while (true) {
                int w15;
                long e15;
                long r15 = this.requested.get();
                for (e15 = 0L; e15 != r15; ++e15) {
                    int p15;
                    boolean empty;
                    Throwable ex4;
                    if (this.cancelled) {
                        q15.clear();
                        return;
                    }
                    boolean d15 = this.done;
                    if (d15 && (ex4 = this.error) != null) {
                        q15.clear();
                        a15.onError(ex4);
                        this.worker.dispose();
                        return;
                    }
                    Object v15 = q15.poll();
                    boolean bl4 = empty = v15 == null;
                    if (d15 && empty) {
                        a15.onComplete();
                        this.worker.dispose();
                        return;
                    }
                    if (empty) break;
                    a15.onNext(v15);
                    if ((p15 = ++c15) != lim) continue;
                    c15 = 0;
                    this.upstream.request(p15);
                }
                if (e15 == r15) {
                    if (this.cancelled) {
                        q15.clear();
                        return;
                    }
                    if (this.done) {
                        Throwable ex5 = this.error;
                        if (ex5 != null) {
                            q15.clear();
                            a15.onError(ex5);
                            this.worker.dispose();
                            return;
                        }
                        if (q15.isEmpty()) {
                            a15.onComplete();
                            this.worker.dispose();
                            return;
                        }
                    }
                }
                if (e15 != 0L && r15 != Long.MAX_VALUE) {
                    this.requested.addAndGet(-e15);
                }
                if ((w15 = this.get()) == missed) {
                    this.consumed = c15;
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w15;
            }
        }
    }

    static abstract class BaseRunOnSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = 9222303586456402150L;
        final int prefetch;
        final int limit;
        final SpscArrayQueue<T> queue;
        final Scheduler.Worker worker;
        Subscription upstream;
        volatile boolean done;
        Throwable error;
        final AtomicLong requested = new AtomicLong();
        volatile boolean cancelled;
        int consumed;

        BaseRunOnSubscriber(int prefetch, SpscArrayQueue<T> queue, Scheduler.Worker worker) {
            this.prefetch = prefetch;
            this.queue = queue;
            this.limit = prefetch - (prefetch >> 2);
            this.worker = worker;
        }

        @Override
        public final void onNext(T t15) {
            if (this.done) {
                return;
            }
            if (!this.queue.offer(t15)) {
                this.upstream.cancel();
                this.onError(new QueueOverflowException());
                return;
            }
            this.schedule();
        }

        @Override
        public final void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.error = t15;
            this.done = true;
            this.schedule();
        }

        @Override
        public final void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.schedule();
        }

        @Override
        public final void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
                this.schedule();
            }
        }

        @Override
        public final void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.cancel();
                this.worker.dispose();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        final void schedule() {
            if (this.getAndIncrement() == 0) {
                this.worker.schedule(this);
            }
        }
    }

    final class MultiWorkerCallback
    implements SchedulerMultiWorkerSupport.WorkerCallback {
        final Subscriber<? super T>[] subscribers;
        final Subscriber<T>[] parents;

        MultiWorkerCallback(Subscriber<? super T>[] subscribers, Subscriber<T>[] parents) {
            this.subscribers = subscribers;
            this.parents = parents;
        }

        @Override
        public void onWorker(int i15, Scheduler.Worker w15) {
            ParallelRunOn.this.createSubscriber(i15, this.subscribers, this.parents, w15);
        }
    }
}

