/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.subscribers;

import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.subscribers.QueueDrainSubscriberPad4;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.QueueDrain;
import io.reactivex.rxjava3.internal.util.QueueDrainHelper;
import io.reactivex.rxjava3.operators.SimplePlainQueue;
import org.reactivestreams.Subscriber;

public abstract class QueueDrainSubscriber<T, U, V>
extends QueueDrainSubscriberPad4
implements FlowableSubscriber<T>,
QueueDrain<U, V> {
    protected final Subscriber<? super V> downstream;
    protected final SimplePlainQueue<U> queue;
    protected volatile boolean cancelled;
    protected volatile boolean done;
    protected Throwable error;

    public QueueDrainSubscriber(Subscriber<? super V> actual, SimplePlainQueue<U> queue) {
        this.downstream = actual;
        this.queue = queue;
    }

    @Override
    public final boolean cancelled() {
        return this.cancelled;
    }

    @Override
    public final boolean done() {
        return this.done;
    }

    @Override
    public final boolean enter() {
        return this.wip.getAndIncrement() == 0;
    }

    public final boolean fastEnter() {
        return this.wip.get() == 0 && this.wip.compareAndSet(0, 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void fastPathEmitMax(U value, boolean delayError, Disposable dispose) {
        Subscriber<V> s15 = this.downstream;
        SimplePlainQueue<U> q15 = this.queue;
        if (this.fastEnter()) {
            long r15 = this.requested.get();
            if (r15 == 0L) {
                dispose.dispose();
                s15.onError(MissingBackpressureException.createDefault());
                return;
            }
            if (this.accept((Subscriber<? super V>)s15, value) && r15 != Long.MAX_VALUE) {
                this.produced(1L);
            }
            if (this.leave(-1) == 0) {
                return;
            }
        } else {
            q15.offer(value);
            if (!this.enter()) {
                return;
            }
        }
        QueueDrainHelper.drainMaxLoop(q15, s15, delayError, dispose, this);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void fastPathOrderedEmitMax(U value, boolean delayError, Disposable dispose) {
        Subscriber<V> s15 = this.downstream;
        SimplePlainQueue<U> q15 = this.queue;
        if (this.fastEnter()) {
            long r15 = this.requested.get();
            if (r15 == 0L) {
                this.cancelled = true;
                dispose.dispose();
                s15.onError(MissingBackpressureException.createDefault());
                return;
            }
            if (q15.isEmpty()) {
                if (this.accept((Subscriber<? super V>)s15, value) && r15 != Long.MAX_VALUE) {
                    this.produced(1L);
                }
                if (this.leave(-1) == 0) {
                    return;
                }
            } else {
                q15.offer(value);
            }
        } else {
            q15.offer(value);
            if (!this.enter()) {
                return;
            }
        }
        QueueDrainHelper.drainMaxLoop(q15, s15, delayError, dispose, this);
    }

    @Override
    public boolean accept(Subscriber<? super V> a15, U v15) {
        return false;
    }

    @Override
    public final Throwable error() {
        return this.error;
    }

    @Override
    public final int leave(int m15) {
        return this.wip.addAndGet(m15);
    }

    @Override
    public final long requested() {
        return this.requested.get();
    }

    @Override
    public final long produced(long n15) {
        return this.requested.addAndGet(-n15);
    }

    public final void requested(long n15) {
        if (SubscriptionHelper.validate(n15)) {
            BackpressureHelper.add(this.requested, n15);
        }
    }
}

