/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.subjects;

import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.util.AppendOnlyLinkedArrayList;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.subjects.Subject;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class BehaviorSubject<T>
extends Subject<T> {
    final AtomicReference<Object> value;
    final AtomicReference<BehaviorDisposable<T>[]> observers;
    static final BehaviorDisposable[] EMPTY = new BehaviorDisposable[0];
    static final BehaviorDisposable[] TERMINATED = new BehaviorDisposable[0];
    final ReadWriteLock lock = new ReentrantReadWriteLock();
    final Lock readLock = this.lock.readLock();
    final Lock writeLock = this.lock.writeLock();
    final AtomicReference<Throwable> terminalEvent;
    long index;

    @CheckReturnValue
    @NonNull
    public static <T> BehaviorSubject<T> create() {
        return new BehaviorSubject<Object>(null);
    }

    @CheckReturnValue
    @NonNull
    public static <T> BehaviorSubject<T> createDefault(T defaultValue) {
        Objects.requireNonNull(defaultValue, "defaultValue is null");
        return new BehaviorSubject<T>(defaultValue);
    }

    BehaviorSubject(T defaultValue) {
        this.observers = new AtomicReference<BehaviorDisposable[]>(EMPTY);
        this.value = new AtomicReference<T>(defaultValue);
        this.terminalEvent = new AtomicReference();
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        BehaviorDisposable<T> bs4 = new BehaviorDisposable<T>(observer, this);
        observer.onSubscribe(bs4);
        if (this.add(bs4)) {
            if (bs4.cancelled) {
                this.remove(bs4);
            } else {
                bs4.emitFirst();
            }
        } else {
            Throwable ex4 = this.terminalEvent.get();
            if (ex4 == ExceptionHelper.TERMINATED) {
                observer.onComplete();
            } else {
                observer.onError(ex4);
            }
        }
    }

    @Override
    public void onSubscribe(Disposable d15) {
        if (this.terminalEvent.get() != null) {
            d15.dispose();
        }
    }

    @Override
    public void onNext(T t15) {
        ExceptionHelper.nullCheck(t15, "onNext called with a null value.");
        if (this.terminalEvent.get() != null) {
            return;
        }
        Object o15 = NotificationLite.next(t15);
        this.setCurrent(o15);
        for (BehaviorDisposable<T> bs4 : this.observers.get()) {
            bs4.emitNext(o15, this.index);
        }
    }

    @Override
    public void onError(Throwable t15) {
        ExceptionHelper.nullCheck(t15, "onError called with a null Throwable.");
        if (!this.terminalEvent.compareAndSet(null, t15)) {
            RxJavaPlugins.onError(t15);
            return;
        }
        Object o15 = NotificationLite.error(t15);
        for (BehaviorDisposable<T> bs4 : this.terminate(o15)) {
            bs4.emitNext(o15, this.index);
        }
    }

    @Override
    public void onComplete() {
        if (!this.terminalEvent.compareAndSet(null, ExceptionHelper.TERMINATED)) {
            return;
        }
        Object o15 = NotificationLite.complete();
        for (BehaviorDisposable<T> bs4 : this.terminate(o15)) {
            bs4.emitNext(o15, this.index);
        }
    }

    @Override
    @CheckReturnValue
    public boolean hasObservers() {
        return this.observers.get().length != 0;
    }

    @CheckReturnValue
    int subscriberCount() {
        return this.observers.get().length;
    }

    @Override
    @CheckReturnValue
    @Nullable
    public Throwable getThrowable() {
        Object o15 = this.value.get();
        if (NotificationLite.isError(o15)) {
            return NotificationLite.getError(o15);
        }
        return null;
    }

    @CheckReturnValue
    @Nullable
    public T getValue() {
        Object o15 = this.value.get();
        if (NotificationLite.isComplete(o15) || NotificationLite.isError(o15)) {
            return null;
        }
        return NotificationLite.getValue(o15);
    }

    @Override
    @CheckReturnValue
    public boolean hasComplete() {
        Object o15 = this.value.get();
        return NotificationLite.isComplete(o15);
    }

    @Override
    @CheckReturnValue
    public boolean hasThrowable() {
        Object o15 = this.value.get();
        return NotificationLite.isError(o15);
    }

    @CheckReturnValue
    public boolean hasValue() {
        Object o15 = this.value.get();
        return o15 != null && !NotificationLite.isComplete(o15) && !NotificationLite.isError(o15);
    }

    boolean add(BehaviorDisposable<T> rs4) {
        BehaviorDisposable[] b15;
        BehaviorDisposable<T>[] a15;
        do {
            if ((a15 = this.observers.get()) == TERMINATED) {
                return false;
            }
            int len = a15.length;
            b15 = new BehaviorDisposable[len + 1];
            System.arraycopy(a15, 0, b15, 0, len);
            b15[len] = rs4;
        } while (!this.observers.compareAndSet(a15, b15));
        return true;
    }

    void remove(BehaviorDisposable<T> rs4) {
        BehaviorDisposable[] b15;
        BehaviorDisposable<T>[] a15;
        do {
            int len;
            if ((len = (a15 = this.observers.get()).length) == 0) {
                return;
            }
            int j15 = -1;
            for (int i15 = 0; i15 < len; ++i15) {
                if (a15[i15] != rs4) continue;
                j15 = i15;
                break;
            }
            if (j15 < 0) {
                return;
            }
            if (len == 1) {
                b15 = EMPTY;
                continue;
            }
            b15 = new BehaviorDisposable[len - 1];
            System.arraycopy(a15, 0, b15, 0, j15);
            System.arraycopy(a15, j15 + 1, b15, j15, len - j15 - 1);
        } while (!this.observers.compareAndSet(a15, b15));
    }

    BehaviorDisposable<T>[] terminate(Object terminalValue) {
        this.setCurrent(terminalValue);
        return this.observers.getAndSet(TERMINATED);
    }

    void setCurrent(Object o15) {
        this.writeLock.lock();
        ++this.index;
        this.value.lazySet(o15);
        this.writeLock.unlock();
    }

    static final class BehaviorDisposable<T>
    implements Disposable,
    AppendOnlyLinkedArrayList.NonThrowingPredicate<Object> {
        final Observer<? super T> downstream;
        final BehaviorSubject<T> state;
        boolean next;
        boolean emitting;
        AppendOnlyLinkedArrayList<Object> queue;
        boolean fastPath;
        volatile boolean cancelled;
        long index;

        BehaviorDisposable(Observer<? super T> actual, BehaviorSubject<T> state) {
            this.downstream = actual;
            this.state = state;
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.state.remove(this);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitFirst() {
            Object o15;
            if (this.cancelled) {
                return;
            }
            BehaviorDisposable behaviorDisposable = this;
            synchronized (behaviorDisposable) {
                if (this.cancelled) {
                    return;
                }
                if (this.next) {
                    return;
                }
                BehaviorSubject<T> s15 = this.state;
                Lock lock = s15.readLock;
                lock.lock();
                this.index = s15.index;
                o15 = s15.value.get();
                lock.unlock();
                this.emitting = o15 != null;
                this.next = true;
            }
            if (o15 != null) {
                if (this.test(o15)) {
                    return;
                }
                this.emitLoop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitNext(Object value, long stateIndex) {
            if (this.cancelled) {
                return;
            }
            if (!this.fastPath) {
                BehaviorDisposable behaviorDisposable = this;
                synchronized (behaviorDisposable) {
                    if (this.cancelled) {
                        return;
                    }
                    if (this.index == stateIndex) {
                        return;
                    }
                    if (this.emitting) {
                        AppendOnlyLinkedArrayList<Object> q15 = this.queue;
                        if (q15 == null) {
                            this.queue = q15 = new AppendOnlyLinkedArrayList(4);
                        }
                        q15.add(value);
                        return;
                    }
                    this.next = true;
                }
                this.fastPath = true;
            }
            this.test(value);
        }

        @Override
        public boolean test(Object o15) {
            return this.cancelled || NotificationLite.accept(o15, this.downstream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitLoop() {
            while (!this.cancelled) {
                AppendOnlyLinkedArrayList<Object> q15;
                BehaviorDisposable behaviorDisposable = this;
                synchronized (behaviorDisposable) {
                    q15 = this.queue;
                    if (q15 == null) {
                        this.emitting = false;
                        return;
                    }
                    this.queue = null;
                }
                q15.forEachWhile(this);
            }
            return;
        }
    }
}

