/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.JavaClass;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.ICodeNodeRef;
import jadx.api.metadata.annotations.VarNode;
import jadx.api.metadata.annotations.VarRef;
import jadx.core.dex.instructions.args.ArgType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class JavaVariable
implements JavaNode {
    private final JavaMethod mth;
    private final VarNode varNode;

    public JavaVariable(JavaMethod mth, VarNode varNode) {
        this.mth = mth;
        this.varNode = varNode;
    }

    public JavaMethod getMth() {
        return this.mth;
    }

    public int getReg() {
        return this.varNode.getReg();
    }

    public int getSsa() {
        return this.varNode.getSsa();
    }

    @Override
    @Nullable
    public String getName() {
        return this.varNode.getName();
    }

    @Override
    public ICodeNodeRef getCodeNodeRef() {
        return this.varNode;
    }

    @ApiStatus.Internal
    public VarNode getVarNode() {
        return this.varNode;
    }

    @Override
    public String getFullName() {
        return String.valueOf(this.varNode.getType()) + " " + this.varNode.getName() + " (r" + this.varNode.getReg() + "v" + this.varNode.getSsa() + ")";
    }

    public ArgType getType() {
        return ArgType.tryToResolveClassAlias(this.mth.getMethodNode().root(), this.varNode.getType());
    }

    @Override
    public JavaClass getDeclaringClass() {
        return this.mth.getDeclaringClass();
    }

    @Override
    public JavaClass getTopParentClass() {
        return this.mth.getTopParentClass();
    }

    @Override
    public int getDefPos() {
        return this.varNode.getDefPosition();
    }

    @Override
    public List<JavaNode> getUseIn() {
        return Collections.singletonList(this.mth);
    }

    @Override
    public void removeAlias() {
        this.varNode.setName(null);
    }

    @Override
    public boolean isOwnCodeAnnotation(ICodeAnnotation ann) {
        if (ann.getAnnType() == ICodeAnnotation.AnnType.VAR_REF) {
            VarRef varRef = (VarRef)ann;
            return varRef.getRefPos() == this.getDefPos();
        }
        return false;
    }

    public int hashCode() {
        return this.varNode.hashCode();
    }

    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        if (!(o15 instanceof JavaVariable)) {
            return false;
        }
        return this.varNode.equals(((JavaVariable)o15).varNode);
    }
}

