/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.data.impl;

import jadx.api.JavaVariable;
import jadx.api.data.CodeRefType;
import jadx.api.data.IJavaCodeRef;
import jadx.api.metadata.annotations.VarNode;

public class JadxCodeRef
implements IJavaCodeRef {
    private CodeRefType attachType;
    private int index;

    public static JadxCodeRef forInsn(int offset) {
        return new JadxCodeRef(CodeRefType.INSN, offset);
    }

    public static JadxCodeRef forMthArg(int argIndex) {
        return new JadxCodeRef(CodeRefType.MTH_ARG, argIndex);
    }

    public static JadxCodeRef forVar(int regNum, int ssaVersion) {
        return new JadxCodeRef(CodeRefType.VAR, regNum << 16 | ssaVersion);
    }

    public static JadxCodeRef forVar(JavaVariable javaVariable) {
        return JadxCodeRef.forVar(javaVariable.getReg(), javaVariable.getSsa());
    }

    public static JadxCodeRef forVar(VarNode varNode) {
        return JadxCodeRef.forVar(varNode.getReg(), varNode.getSsa());
    }

    public static JadxCodeRef forCatch(int handlerOffset) {
        return new JadxCodeRef(CodeRefType.CATCH, handlerOffset);
    }

    public JadxCodeRef(CodeRefType attachType, int index) {
        this.attachType = attachType;
        this.index = index;
    }

    public JadxCodeRef() {
    }

    @Override
    public CodeRefType getAttachType() {
        return this.attachType;
    }

    public void setAttachType(CodeRefType attachType) {
        this.attachType = attachType;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        if (!(o15 instanceof JadxCodeRef)) {
            return false;
        }
        JadxCodeRef other = (JadxCodeRef)o15;
        return this.getIndex() == other.getIndex() && this.getAttachType() == other.getAttachType();
    }

    public int hashCode() {
        return 31 * this.getAttachType().hashCode() + this.getIndex();
    }

    public String toString() {
        return "JadxCodeRef{attachType=" + String.valueOf((Object)this.attachType) + ", index=" + this.index + "}";
    }
}

