/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.codegen;

import jadx.api.ICodeWriter;
import jadx.core.codegen.InsnGen;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.ArithNode;
import jadx.core.dex.instructions.IfOp;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.regions.conditions.Compare;
import jadx.core.dex.regions.conditions.IfCondition;
import jadx.core.utils.exceptions.CodegenException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;

public class ConditionGen
extends InsnGen {
    public ConditionGen(InsnGen insnGen) {
        super(insnGen.mgen, insnGen.fallback);
    }

    public void add(ICodeWriter code, IfCondition condition2) throws CodegenException {
        this.add(code, new CondStack(), condition2);
    }

    void wrap(ICodeWriter code, IfCondition condition2) throws CodegenException {
        this.wrap(code, new CondStack(), condition2);
    }

    private void add(ICodeWriter code, CondStack stack, IfCondition condition2) throws CodegenException {
        stack.push(condition2);
        switch (condition2.getMode()) {
            case COMPARE: {
                this.addCompare(code, stack, condition2.getCompare());
                break;
            }
            case TERNARY: {
                this.addTernary(code, stack, condition2);
                break;
            }
            case NOT: {
                this.addNot(code, stack, condition2);
                break;
            }
            case AND: 
            case OR: {
                this.addAndOr(code, stack, condition2);
                break;
            }
            default: {
                throw new JadxRuntimeException("Unknown condition mode: " + String.valueOf((Object)condition2.getMode()));
            }
        }
        stack.pop();
    }

    private void wrap(ICodeWriter code, CondStack stack, IfCondition cond) throws CodegenException {
        boolean wrap = this.isWrapNeeded(cond);
        if (wrap) {
            code.add('(');
        }
        this.add(code, stack, cond);
        if (wrap) {
            code.add(')');
        }
    }

    private void wrap(ICodeWriter code, InsnArg firstArg) throws CodegenException {
        boolean wrap = ConditionGen.isArgWrapNeeded(firstArg);
        if (wrap) {
            code.add('(');
        }
        this.addArg(code, firstArg, false);
        if (wrap) {
            code.add(')');
        }
    }

    private void addCompare(ICodeWriter code, CondStack stack, Compare compare) throws CodegenException {
        IfOp op4 = compare.getOp();
        InsnArg firstArg = compare.getA();
        InsnArg secondArg = compare.getB();
        if (firstArg.getType().equals(ArgType.BOOLEAN) && secondArg.isLiteral() && secondArg.getType().equals(ArgType.BOOLEAN)) {
            LiteralArg lit = (LiteralArg)secondArg;
            if (lit.getLiteral() == 0L) {
                op4 = op4.invert();
            }
            if (op4 == IfOp.EQ) {
                if (stack.getStack().size() == 1) {
                    this.addArg(code, firstArg, false);
                } else {
                    this.wrap(code, firstArg);
                }
                return;
            }
            if (op4 == IfOp.NE) {
                code.add('!');
                this.wrap(code, firstArg);
                return;
            }
            this.mth.addWarn("Unsupported boolean condition " + op4.getSymbol());
        }
        this.addArg(code, firstArg, ConditionGen.isArgWrapNeeded(firstArg));
        code.add(' ').add(op4.getSymbol()).add(' ');
        this.addArg(code, secondArg, ConditionGen.isArgWrapNeeded(secondArg));
    }

    private void addTernary(ICodeWriter code, CondStack stack, IfCondition condition2) throws CodegenException {
        this.add(code, stack, condition2.first());
        code.add(" ? ");
        this.add(code, stack, condition2.second());
        code.add(" : ");
        this.add(code, stack, condition2.third());
    }

    private void addNot(ICodeWriter code, CondStack stack, IfCondition condition2) throws CodegenException {
        code.add('!');
        this.wrap(code, stack, condition2.getArgs().get(0));
    }

    private void addAndOr(ICodeWriter code, CondStack stack, IfCondition condition2) throws CodegenException {
        String mode = condition2.getMode() == IfCondition.Mode.AND ? " && " : " || ";
        Iterator<IfCondition> it = condition2.getArgs().iterator();
        while (it.hasNext()) {
            this.wrap(code, stack, it.next());
            if (!it.hasNext()) continue;
            code.add(mode);
        }
    }

    private boolean isWrapNeeded(IfCondition condition2) {
        if (condition2.isCompare() || condition2.contains(AFlag.DONT_WRAP)) {
            return false;
        }
        return condition2.getMode() != IfCondition.Mode.NOT;
    }

    private static boolean isArgWrapNeeded(InsnArg arg) {
        if (!arg.isInsnWrap()) {
            return false;
        }
        InsnNode insn = ((InsnWrapArg)arg).getWrapInsn();
        InsnType insnType = insn.getType();
        if (insnType == InsnType.ARITH) {
            switch (((ArithNode)insn).getOp()) {
                case ADD: 
                case SUB: 
                case MUL: 
                case DIV: 
                case REM: {
                    return false;
                }
            }
            return true;
        }
        switch (insnType) {
            case INVOKE: 
            case SGET: 
            case IGET: 
            case AGET: 
            case CONST: 
            case ARRAY_LENGTH: {
                return false;
            }
        }
        return true;
    }

    private static class CondStack {
        private final Queue<IfCondition> stack = new ArrayDeque<IfCondition>();

        private CondStack() {
        }

        public Queue<IfCondition> getStack() {
            return this.stack;
        }

        public void push(IfCondition cond) {
            this.stack.add(cond);
        }

        public IfCondition pop() {
            return this.stack.poll();
        }
    }
}

