/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.deobf;

import jadx.api.JadxArgs;
import jadx.api.args.GeneratedRenamesMappingFileMode;
import jadx.api.deobf.IAliasProvider;
import jadx.api.deobf.impl.AlwaysRename;
import jadx.core.deobf.DeobfuscatorVisitor;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.PackageNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.files.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeobfPresets {
    private static final Logger LOG = LoggerFactory.getLogger(DeobfPresets.class);
    private static final Charset MAP_FILE_CHARSET = StandardCharsets.UTF_8;
    private final Path deobfMapFile;
    private final Map<String, String> pkgPresetMap = new HashMap<String, String>();
    private final Map<String, String> clsPresetMap = new HashMap<String, String>();
    private final Map<String, String> fldPresetMap = new HashMap<String, String>();
    private final Map<String, String> mthPresetMap = new HashMap<String, String>();

    public static DeobfPresets build(RootNode root) {
        Path deobfMapPath = DeobfPresets.getPathDeobfMapPath(root);
        if (root.getArgs().getGeneratedRenamesMappingFileMode() != GeneratedRenamesMappingFileMode.IGNORE) {
            LOG.debug("Deobfuscation map file set to: {}", (Object)deobfMapPath);
        }
        return new DeobfPresets(deobfMapPath);
    }

    private static Path getPathDeobfMapPath(RootNode root) {
        JadxArgs jadxArgs = root.getArgs();
        File deobfMapFile = jadxArgs.getGeneratedRenamesMappingFile();
        if (deobfMapFile != null) {
            return deobfMapFile.toPath();
        }
        Path inputFilePath = jadxArgs.getInputFiles().get(0).toPath().toAbsolutePath();
        String baseName = FileUtils.getPathBaseName(inputFilePath);
        return inputFilePath.getParent().resolve(baseName + ".jobf");
    }

    private DeobfPresets(Path deobfMapFile) {
        this.deobfMapFile = deobfMapFile;
    }

    public boolean load() {
        if (!Files.exists(this.deobfMapFile, new LinkOption[0])) {
            return false;
        }
        LOG.info("Loading obfuscation map from: {}", (Object)this.deobfMapFile.toAbsolutePath());
        try {
            List<String> lines = Files.readAllLines(this.deobfMapFile, MAP_FILE_CHARSET);
            for (String l15 : lines) {
                String[] va5;
                if ((l15 = l15.trim()).isEmpty() || l15.startsWith("#") || (va5 = DeobfPresets.splitAndTrim(l15)).length != 2) continue;
                String origName = va5[0];
                String alias = va5[1];
                switch (l15.charAt(0)) {
                    case 'p': {
                        this.pkgPresetMap.put(origName, alias);
                        break;
                    }
                    case 'c': {
                        this.clsPresetMap.put(origName, alias);
                        break;
                    }
                    case 'f': {
                        this.fldPresetMap.put(origName, alias);
                        break;
                    }
                    case 'm': {
                        this.mthPresetMap.put(origName, alias);
                        break;
                    }
                }
            }
            return true;
        }
        catch (Exception e15) {
            LOG.error("Failed to load deobfuscation map file '{}'", (Object)this.deobfMapFile.toAbsolutePath(), (Object)e15);
            return false;
        }
    }

    private static String[] splitAndTrim(String str) {
        String[] v15 = str.substring(2).split("=");
        for (int i15 = 0; i15 < v15.length; ++i15) {
            v15[i15] = v15[i15].trim();
        }
        return v15;
    }

    public void save() throws IOException {
        ArrayList<String> list2 = new ArrayList<String>();
        for (Map.Entry<String, String> pkgEntry : this.pkgPresetMap.entrySet()) {
            list2.add(String.format("p %s = %s", pkgEntry.getKey(), pkgEntry.getValue()));
        }
        for (Map.Entry<String, String> clsEntry : this.clsPresetMap.entrySet()) {
            list2.add(String.format("c %s = %s", clsEntry.getKey(), clsEntry.getValue()));
        }
        for (Map.Entry<String, String> fldEntry : this.fldPresetMap.entrySet()) {
            list2.add(String.format("f %s = %s", fldEntry.getKey(), fldEntry.getValue()));
        }
        for (Map.Entry<String, String> mthEntry : this.mthPresetMap.entrySet()) {
            list2.add(String.format("m %s = %s", mthEntry.getKey(), mthEntry.getValue()));
        }
        Collections.sort(list2);
        if (list2.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deobfuscation map is empty, not saving it");
            }
            return;
        }
        Files.write(this.deobfMapFile, list2, MAP_FILE_CHARSET, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        LOG.info("Deobfuscation map file saved as: {}", (Object)this.deobfMapFile);
    }

    public void fill(RootNode root) {
        for (PackageNode pkg : root.getPackages()) {
            if (!pkg.isLeaf()) continue;
            if (pkg.hasParentAlias()) {
                this.pkgPresetMap.put(pkg.getPkgInfo().getFullName(), pkg.getAliasPkgInfo().getFullName());
                continue;
            }
            if (!pkg.hasAlias()) continue;
            this.pkgPresetMap.put(pkg.getPkgInfo().getFullName(), pkg.getAliasPkgInfo().getName());
        }
        for (ClassNode cls : root.getClasses()) {
            ClassInfo classInfo = cls.getClassInfo();
            if (classInfo.hasAlias()) {
                this.clsPresetMap.put(classInfo.makeRawFullName(), classInfo.getAliasShortName());
            }
            for (FieldNode fld : cls.getFields()) {
                FieldInfo fieldInfo = fld.getFieldInfo();
                if (!fieldInfo.hasAlias()) continue;
                this.fldPresetMap.put(fieldInfo.getRawFullId(), fld.getAlias());
            }
            for (MethodNode mth : cls.getMethods()) {
                MethodInfo methodInfo = mth.getMethodInfo();
                if (!methodInfo.hasAlias()) continue;
                this.mthPresetMap.put(methodInfo.getRawFullId(), methodInfo.getAlias());
            }
        }
    }

    public void apply(RootNode root) {
        DeobfuscatorVisitor.process(root, AlwaysRename.INSTANCE, new IAliasProvider(){

            @Override
            public String forPackage(PackageNode pkg) {
                return DeobfPresets.this.pkgPresetMap.get(pkg.getPkgInfo().getFullName());
            }

            @Override
            public String forClass(ClassNode cls) {
                return DeobfPresets.this.getForCls(cls.getClassInfo());
            }

            @Override
            public String forField(FieldNode fld) {
                return DeobfPresets.this.getForFld(fld.getFieldInfo());
            }

            @Override
            public String forMethod(MethodNode mth) {
                return DeobfPresets.this.getForMth(mth.getMethodInfo());
            }
        });
    }

    public void initIndexes(IAliasProvider aliasProvider) {
        aliasProvider.initIndexes(this.pkgPresetMap.size(), this.clsPresetMap.size(), this.fldPresetMap.size(), this.mthPresetMap.size());
    }

    public String getForCls(ClassInfo cls) {
        if (this.clsPresetMap.isEmpty()) {
            return null;
        }
        return this.clsPresetMap.get(cls.makeRawFullName());
    }

    public String getForFld(FieldInfo fld) {
        if (this.fldPresetMap.isEmpty()) {
            return null;
        }
        return this.fldPresetMap.get(fld.getRawFullId());
    }

    public String getForMth(MethodInfo mth) {
        if (this.mthPresetMap.isEmpty()) {
            return null;
        }
        return this.mthPresetMap.get(mth.getRawFullId());
    }

    public void clear() {
        this.pkgPresetMap.clear();
        this.clsPresetMap.clear();
        this.fldPresetMap.clear();
        this.mthPresetMap.clear();
    }

    public Path getDeobfMapFile() {
        return this.deobfMapFile;
    }

    public Map<String, String> getPkgPresetMap() {
        return this.pkgPresetMap;
    }

    public Map<String, String> getClsPresetMap() {
        return this.clsPresetMap;
    }

    public Map<String, String> getFldPresetMap() {
        return this.fldPresetMap;
    }

    public Map<String, String> getMthPresetMap() {
        return this.mthPresetMap;
    }
}

