/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.info;

import jadx.api.JadxArgs;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.IFieldInfoRef;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.prepare.CollectConstValues;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class ConstStorage {
    private final boolean replaceEnabled;
    private final ValueStorage globalValues = new ValueStorage();
    private final Map<ClassNode, ValueStorage> classes = new HashMap<ClassNode, ValueStorage>();
    private Map<Integer, String> resourcesNames = new HashMap<Integer, String>();

    public ConstStorage(JadxArgs args) {
        this.replaceEnabled = args.isReplaceConsts();
    }

    public void addConstField(FieldNode fld, Object value, boolean isPublic) {
        if (isPublic) {
            this.addGlobalConstField(fld, value);
        } else {
            this.getClsValues(fld.getParentClass()).put(value, fld);
        }
    }

    public void addGlobalConstField(IFieldInfoRef fld, Object value) {
        this.globalValues.put(value, fld);
    }

    @Deprecated
    @Nullable
    public static Object getFieldConstValue(FieldNode fld) {
        return CollectConstValues.getFieldConstValue(fld);
    }

    public void removeForClass(ClassNode cls) {
        this.classes.remove(cls);
        this.globalValues.removeForCls(cls);
    }

    private ValueStorage getClsValues(ClassNode cls) {
        return this.classes.computeIfAbsent(cls, c15 -> new ValueStorage());
    }

    @Nullable
    public IFieldInfoRef getConstField(ClassNode cls, Object value, boolean searchGlobal) {
        FieldNode rField;
        if (!this.replaceEnabled) {
            return null;
        }
        RootNode root = cls.root();
        if (value instanceof Integer && (rField = this.getResourceField((Integer)value, root)) != null) {
            return rField;
        }
        boolean foundInGlobal = this.globalValues.contains(value);
        if (foundInGlobal && !searchGlobal) {
            return null;
        }
        ClassNode current = cls;
        while (current != null) {
            IFieldInfoRef field;
            ValueStorage classValues = this.classes.get(current);
            if (classValues != null && (field = classValues.get(value)) != null) {
                if (foundInGlobal) {
                    return null;
                }
                return field;
            }
            ClassInfo parentClass = current.getClassInfo().getParentClass();
            if (parentClass == null) break;
            current = root.resolveClass(parentClass);
        }
        if (searchGlobal) {
            return this.globalValues.get(value);
        }
        return null;
    }

    @Nullable
    private FieldNode getResourceField(Integer value, RootNode root) {
        String str = this.resourcesNames.get(value);
        if (str == null) {
            return null;
        }
        ClassNode appResClass = root.getAppResClass();
        if (appResClass == null) {
            return null;
        }
        String[] parts = str.split("/", 2);
        if (parts.length != 2) {
            return null;
        }
        String typeName = parts[0];
        String fieldName = parts[1];
        for (ClassNode innerClass : appResClass.getInnerClasses()) {
            if (!innerClass.getClassInfo().getShortName().equals(typeName)) continue;
            return innerClass.searchFieldByName(fieldName);
        }
        appResClass.addWarn("Not found resource field with id: " + value + ", name: " + str.replace('/', '.'));
        return null;
    }

    @Nullable
    public IFieldInfoRef getConstFieldByLiteralArg(ClassNode cls, LiteralArg arg) {
        if (!this.replaceEnabled) {
            return null;
        }
        PrimitiveType type = arg.getType().getPrimitiveType();
        if (type == null) {
            return null;
        }
        long literal = arg.getLiteral();
        switch (type) {
            case BOOLEAN: {
                return this.getConstField(cls, literal == 1L, false);
            }
            case CHAR: {
                return this.getConstField(cls, Character.valueOf((char)literal), Math.abs(literal) > 10L);
            }
            case BYTE: {
                return this.getConstField(cls, (byte)literal, Math.abs(literal) > 10L);
            }
            case SHORT: {
                return this.getConstField(cls, (short)literal, Math.abs(literal) > 100L);
            }
            case INT: {
                return this.getConstField(cls, (int)literal, Math.abs(literal) > 100L);
            }
            case LONG: {
                return this.getConstField(cls, literal, Math.abs(literal) > 1000L);
            }
            case FLOAT: {
                float f15 = Float.intBitsToFloat((int)literal);
                return this.getConstField(cls, Float.valueOf(f15), Float.compare(f15, 0.0f) == 0);
            }
            case DOUBLE: {
                double d15 = Double.longBitsToDouble(literal);
                return this.getConstField(cls, d15, Double.compare(d15, 0.0) == 0);
            }
        }
        return null;
    }

    public void setResourcesNames(Map<Integer, String> resourcesNames) {
        this.resourcesNames = resourcesNames;
    }

    public Map<Integer, String> getResourcesNames() {
        return this.resourcesNames;
    }

    public Map<Object, IFieldInfoRef> getGlobalConstFields() {
        return this.globalValues.getValues();
    }

    public boolean isReplaceEnabled() {
        return this.replaceEnabled;
    }

    private static final class ValueStorage {
        private final Map<Object, IFieldInfoRef> values = new ConcurrentHashMap<Object, IFieldInfoRef>();
        private final Set<Object> duplicates = new HashSet<Object>();

        private ValueStorage() {
        }

        public Map<Object, IFieldInfoRef> getValues() {
            return this.values;
        }

        public IFieldInfoRef get(Object key) {
            return this.values.get(key);
        }

        public boolean put(Object value, IFieldInfoRef fld) {
            if (this.duplicates.contains(value)) {
                this.values.remove(value);
                return true;
            }
            IFieldInfoRef prev = this.values.put(value, fld);
            if (prev != null) {
                this.values.remove(value);
                this.duplicates.add(value);
                return true;
            }
            return false;
        }

        public boolean contains(Object value) {
            return this.duplicates.contains(value) || this.values.containsKey(value);
        }

        void removeForCls(ClassNode cls) {
            this.values.entrySet().removeIf(entry -> {
                IFieldInfoRef field = (IFieldInfoRef)entry.getValue();
                if (field instanceof FieldNode) {
                    return ((FieldNode)field).getParentClass().equals(cls);
                }
                return false;
            });
        }
    }
}

