/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.logs;

import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.logs.ILogListener;
import jadx.gui.logs.LogEvent;
import jadx.gui.logs.LogOptions;
import jadx.gui.utils.UiUtils;
import org.apache.commons.lang3.StringUtils;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

class LogAppender
implements ILogListener {
    private final LogOptions options;
    private final RSyntaxTextArea textArea;

    public LogAppender(LogOptions options, RSyntaxTextArea textArea) {
        this.options = options;
        this.textArea = textArea;
    }

    @Override
    public void onAppend(LogEvent logEvent) {
        if (this.accept(logEvent)) {
            UiUtils.uiRun(() -> this.textArea.append(logEvent.getMsg()));
        }
    }

    @Override
    public void onReload() {
        UiUtils.uiRunAndWait(() -> this.textArea.append(StringUtils.repeat('=', 100) + "\n"));
    }

    private boolean accept(LogEvent logEvent) {
        boolean byLevel = logEvent.getLevel().isGreaterOrEqual(this.options.getLogLevel());
        if (!byLevel) {
            return false;
        }
        switch (this.options.getMode()) {
            case ALL: {
                return true;
            }
            case ALL_SCRIPTS: {
                return logEvent.getLoggerName().startsWith("JadxScript:");
            }
            case CURRENT_SCRIPT: {
                return logEvent.getLoggerName().equals(this.options.getFilter());
            }
        }
        throw new JadxRuntimeException("Unexpected log mode: " + String.valueOf((Object)this.options.getMode()));
    }
}

