/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.tools;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncNLSLines {
    private static final Logger LOG = LoggerFactory.getLogger(SyncNLSLines.class);
    private static final Path I18N_PATH = Paths.get("src/main/resources/i18n/", new String[0]);
    private static final String REFERENCE_FILE_NAME = "Messages_en_US.properties";
    private static final String GUI_MODULE_DIR_NAME = "jadx-gui";
    private static final Path GUI_MODULE_PREFIX_PATH = Paths.get("jadx-gui", new String[0]);

    public static void main(String[] args) {
        try {
            SyncNLSLines.process();
        }
        catch (Exception e15) {
            LOG.error("Failed to process i18n files", e15);
        }
    }

    private static void process() throws Exception {
        Path refPath = SyncNLSLines.getRefPath(REFERENCE_FILE_NAME);
        if (!Files.exists(refPath, new LinkOption[0])) {
            LOG.error("Reference i18n file not found: {}", (Object)REFERENCE_FILE_NAME);
            return;
        }
        LOG.info("Using reference file: {}", (Object)refPath.toAbsolutePath());
        Path i18nDir = refPath.toAbsolutePath().getParent();
        if (i18nDir == null) {
            LOG.error("Could not determine i18n directory from reference path: {}", (Object)refPath);
            return;
        }
        List<String> refFileLines = Files.readAllLines(refPath, StandardCharsets.UTF_8);
        try (Stream<Path> pathStream = Files.list(i18nDir);){
            pathStream.filter(path -> {
                String fileName = path.getFileName().toString();
                return !fileName.equals(REFERENCE_FILE_NAME) && fileName.startsWith("Messages_") && fileName.endsWith(".properties");
            }).forEach(targetPath -> {
                try {
                    LOG.info("Processing target file: {}", (Object)targetPath.toAbsolutePath());
                    SyncNLSLines.applySync(refFileLines, targetPath);
                }
                catch (Exception e15) {
                    LOG.error("Failed to sync file: {}", targetPath, (Object)e15);
                }
            });
        }
        LOG.info("I18N synchronization process finished.");
    }

    private static Map<String, String> parseProperties(List<String> lines) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (String line : lines) {
            String key = SyncNLSLines.extractKey(line);
            if (key == null) continue;
            properties.put(key, line);
        }
        return properties;
    }

    private static String extractKey(String line) {
        String trimmedLine = line.trim();
        if (trimmedLine.isEmpty() || trimmedLine.startsWith("#")) {
            return null;
        }
        int separatorIndex = trimmedLine.indexOf(61);
        if (separatorIndex == -1) {
            return trimmedLine;
        }
        return trimmedLine.substring(0, separatorIndex).trim();
    }

    private static void applySync(List<String> refFileLines, Path targetPath) throws IOException {
        List<String> originalTargetLines = Files.readAllLines(targetPath, StandardCharsets.UTF_8);
        Map<String, String> targetProperties = SyncNLSLines.parseProperties(originalTargetLines);
        ArrayList<Object> newTargetLines = new ArrayList<Object>(refFileLines.size());
        boolean updated = false;
        for (String refLine : refFileLines) {
            String refKey = SyncNLSLines.extractKey(refLine);
            if (refKey == null) {
                newTargetLines.add(refLine);
                continue;
            }
            if (targetProperties.containsKey(refKey)) {
                String targetLine = targetProperties.get(refKey);
                String trimmed = targetLine.trim();
                if (trimmed.startsWith("#") && trimmed.substring(1).trim().startsWith(refKey) && trimmed.endsWith("=")) {
                    newTargetLines.add("#" + refLine.trim());
                    continue;
                }
                newTargetLines.add(targetLine);
                continue;
            }
            newTargetLines.add("#" + refLine.trim());
        }
        if (originalTargetLines.size() != newTargetLines.size()) {
            updated = true;
        } else {
            for (int i15 = 0; i15 < originalTargetLines.size(); ++i15) {
                if (originalTargetLines.get(i15).equals(newTargetLines.get(i15))) continue;
                updated = true;
                break;
            }
        }
        if (updated) {
            LOG.info("Updating {} ({} lines -> {} lines)", targetPath.getFileName(), originalTargetLines.size(), newTargetLines.size());
            Files.write(targetPath, newTargetLines, StandardCharsets.UTF_8, new OpenOption[0]);
        } else {
            LOG.info("No changes needed for {}", (Object)targetPath.getFileName());
        }
    }

    private static Path getRefPath(String referenceFileName) {
        Path projectRootRelative = I18N_PATH.resolve(referenceFileName);
        if (Files.exists(projectRootRelative, new LinkOption[0])) {
            return projectRootRelative.toAbsolutePath();
        }
        Path moduleRelative = GUI_MODULE_PREFIX_PATH.resolve(I18N_PATH).resolve(referenceFileName);
        if (Files.exists(moduleRelative, new LinkOption[0])) {
            return moduleRelative.toAbsolutePath();
        }
        Path currentDirRelative = Paths.get(".", new String[0]).resolve(I18N_PATH).resolve(referenceFileName);
        if (Files.exists(currentDirRelative, new LinkOption[0])) {
            return currentDirRelative.toAbsolutePath();
        }
        throw new RuntimeException("Can't find reference I18N: " + referenceFileName);
    }
}

