/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.sections.annotations;

import jadx.api.plugins.input.data.annotations.EncodedType;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.plugins.input.dex.DexException;
import jadx.plugins.input.dex.sections.SectionReader;
import jadx.plugins.input.dex.sections.annotations.AnnotationsParser;
import java.util.ArrayList;
import java.util.List;

public class EncodedValueParser {
    private static final int ENCODED_BYTE = 0;
    private static final int ENCODED_SHORT = 2;
    private static final int ENCODED_CHAR = 3;
    private static final int ENCODED_INT = 4;
    private static final int ENCODED_LONG = 6;
    private static final int ENCODED_FLOAT = 16;
    private static final int ENCODED_DOUBLE = 17;
    private static final int ENCODED_METHOD_TYPE = 21;
    private static final int ENCODED_METHOD_HANDLE = 22;
    private static final int ENCODED_STRING = 23;
    private static final int ENCODED_TYPE = 24;
    private static final int ENCODED_FIELD = 25;
    private static final int ENCODED_ENUM = 27;
    private static final int ENCODED_METHOD = 26;
    private static final int ENCODED_ARRAY = 28;
    private static final int ENCODED_ANNOTATION = 29;
    private static final int ENCODED_NULL = 30;
    private static final int ENCODED_BOOLEAN = 31;

    static EncodedValue parseValue(SectionReader in4, SectionReader ext) {
        int argAndType = in4.readUByte();
        int type = argAndType & 0x1F;
        int arg = (argAndType & 0xE0) >> 5;
        int size = arg + 1;
        switch (type) {
            case 30: {
                return EncodedValue.NULL;
            }
            case 31: {
                return new EncodedValue(EncodedType.ENCODED_BOOLEAN, arg == 1);
            }
            case 0: {
                return new EncodedValue(EncodedType.ENCODED_BYTE, in4.readByte());
            }
            case 2: {
                return new EncodedValue(EncodedType.ENCODED_SHORT, (short)EncodedValueParser.parseNumber(in4, size, true));
            }
            case 3: {
                return new EncodedValue(EncodedType.ENCODED_CHAR, Character.valueOf((char)EncodedValueParser.parseUnsignedInt(in4, size)));
            }
            case 4: {
                return new EncodedValue(EncodedType.ENCODED_INT, (int)EncodedValueParser.parseNumber(in4, size, true));
            }
            case 6: {
                return new EncodedValue(EncodedType.ENCODED_LONG, EncodedValueParser.parseNumber(in4, size, true));
            }
            case 16: {
                return new EncodedValue(EncodedType.ENCODED_FLOAT, Float.valueOf(Float.intBitsToFloat((int)EncodedValueParser.parseNumber(in4, size, false, 4))));
            }
            case 17: {
                return new EncodedValue(EncodedType.ENCODED_DOUBLE, Double.longBitsToDouble(EncodedValueParser.parseNumber(in4, size, false, 8)));
            }
            case 23: {
                return new EncodedValue(EncodedType.ENCODED_STRING, ext.getString(EncodedValueParser.parseUnsignedInt(in4, size)));
            }
            case 24: {
                return new EncodedValue(EncodedType.ENCODED_TYPE, ext.getType(EncodedValueParser.parseUnsignedInt(in4, size)));
            }
            case 25: 
            case 27: {
                return new EncodedValue(EncodedType.ENCODED_FIELD, ext.getFieldRef(EncodedValueParser.parseUnsignedInt(in4, size)));
            }
            case 28: {
                return new EncodedValue(EncodedType.ENCODED_ARRAY, EncodedValueParser.parseEncodedArray(in4, ext));
            }
            case 29: {
                return new EncodedValue(EncodedType.ENCODED_ANNOTATION, AnnotationsParser.readAnnotation(in4, ext, false));
            }
            case 26: {
                return new EncodedValue(EncodedType.ENCODED_METHOD, ext.getMethodRef(EncodedValueParser.parseUnsignedInt(in4, size)));
            }
            case 21: {
                return new EncodedValue(EncodedType.ENCODED_METHOD_TYPE, ext.getMethodProto(EncodedValueParser.parseUnsignedInt(in4, size)));
            }
            case 22: {
                return new EncodedValue(EncodedType.ENCODED_METHOD_HANDLE, ext.getMethodHandle(EncodedValueParser.parseUnsignedInt(in4, size)));
            }
        }
        throw new DexException("Unknown encoded value type: 0x" + Integer.toHexString(type));
    }

    public static List<EncodedValue> parseEncodedArray(SectionReader in4, SectionReader ext) {
        int count = in4.readUleb128();
        ArrayList<EncodedValue> values2 = new ArrayList<EncodedValue>(count);
        for (int i15 = 0; i15 < count; ++i15) {
            values2.add(EncodedValueParser.parseValue(in4, ext));
        }
        return values2;
    }

    private static int parseUnsignedInt(SectionReader in4, int byteCount) {
        return (int)EncodedValueParser.parseNumber(in4, byteCount, false, 0);
    }

    private static long parseNumber(SectionReader in4, int byteCount, boolean isSignExtended) {
        return EncodedValueParser.parseNumber(in4, byteCount, isSignExtended, 0);
    }

    private static long parseNumber(SectionReader in4, int byteCount, boolean isSignExtended, int fillOnRight) {
        long result;
        block4: {
            int i15;
            long last;
            block3: {
                result = 0L;
                last = 0L;
                for (i15 = 0; i15 < byteCount; ++i15) {
                    last = in4.readUByte();
                    result |= last << i15 * 8;
                }
                if (fillOnRight == 0) break block3;
                for (i15 = byteCount; i15 < fillOnRight; ++i15) {
                    result <<= 8;
                }
                break block4;
            }
            if (!isSignExtended || (last & 0x80L) == 0L) break block4;
            for (i15 = byteCount; i15 < 8; ++i15) {
                result |= 255L << i15 * 8;
            }
        }
        return result;
    }
}

