/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializedGrammar {
    public static final String COOKIE = "$ANTLR";
    public static final int FORMAT_VERSION = 1;
    public String name;
    public char type;
    public List<? extends Rule> rules;

    public SerializedGrammar(String filename) throws IOException {
        System.out.println("loading " + filename);
        FileInputStream fis = new FileInputStream(filename);
        BufferedInputStream bos = new BufferedInputStream(fis);
        DataInputStream in4 = new DataInputStream(bos);
        this.readFile(in4);
        in4.close();
    }

    protected void readFile(DataInputStream in4) throws IOException {
        String grammarName;
        char grammarType;
        String cookie = this.readString(in4);
        if (!cookie.equals(COOKIE)) {
            throw new IOException("not a serialized grammar file");
        }
        byte version = in4.readByte();
        this.type = grammarType = (char)in4.readByte();
        this.name = grammarName = this.readString(in4);
        System.out.println(grammarType + " grammar " + grammarName);
        short numRules = in4.readShort();
        System.out.println("num rules = " + numRules);
        this.rules = this.readRules(in4, numRules);
    }

    protected List<? extends Rule> readRules(DataInputStream in4, int numRules) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (int i15 = 0; i15 < numRules; ++i15) {
            Rule r15 = this.readRule(in4);
            rules.add(r15);
        }
        return rules;
    }

    protected Rule readRule(DataInputStream in4) throws IOException {
        byte R = in4.readByte();
        if (R != 82) {
            throw new IOException("missing R on start of rule");
        }
        String name = this.readString(in4);
        System.out.println("rule: " + name);
        byte B11 = in4.readByte();
        Block b15 = this.readBlock(in4);
        byte period = in4.readByte();
        if (period != 46) {
            throw new IOException("missing . on end of rule");
        }
        return new Rule(name, b15);
    }

    protected Block readBlock(DataInputStream in4) throws IOException {
        int nalts = in4.readShort();
        List[] alts = new List[nalts];
        for (int i15 = 0; i15 < nalts; ++i15) {
            List<Node> alt;
            alts[i15] = alt = this.readAlt(in4);
        }
        return new Block(alts);
    }

    protected List<Node> readAlt(DataInputStream in4) throws IOException {
        ArrayList<Node> alt = new ArrayList<Node>();
        byte A11 = in4.readByte();
        if (A11 != 65) {
            throw new IOException("missing A on start of alt");
        }
        byte cmd = in4.readByte();
        while (cmd != 59) {
            switch (cmd) {
                case 116: {
                    short ttype = in4.readShort();
                    alt.add(new TokenRef(ttype));
                    break;
                }
                case 114: {
                    short ruleIndex = in4.readShort();
                    alt.add(new RuleRef(ruleIndex));
                    break;
                }
                case 46: {
                    break;
                }
                case 45: {
                    char from = in4.readChar();
                    char to4 = in4.readChar();
                    break;
                }
                case 126: {
                    short notThisTokenType = in4.readShort();
                    break;
                }
                case 66: {
                    Block b15 = this.readBlock(in4);
                    alt.add(b15);
                }
            }
            cmd = in4.readByte();
        }
        return alt;
    }

    protected String readString(DataInputStream in4) throws IOException {
        byte c15 = in4.readByte();
        StringBuilder buf = new StringBuilder();
        while (c15 != 59) {
            buf.append((char)c15);
            c15 = in4.readByte();
        }
        return buf.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.type).append(" grammar ").append(this.name);
        buf.append(this.rules);
        return buf.toString();
    }

    protected class RuleRef
    extends Node {
        int ruleIndex;

        public RuleRef(int ruleIndex) {
            this.ruleIndex = ruleIndex;
        }

        public String toString() {
            return String.valueOf(this.ruleIndex);
        }
    }

    protected class TokenRef
    extends Node {
        int ttype;

        public TokenRef(int ttype) {
            this.ttype = ttype;
        }

        public String toString() {
            return String.valueOf(this.ttype);
        }
    }

    protected class Block
    extends Node {
        List[] alts;

        public Block(List[] alts) {
            this.alts = alts;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("(");
            for (int i15 = 0; i15 < this.alts.length; ++i15) {
                List alt = this.alts[i15];
                if (i15 > 0) {
                    buf.append("|");
                }
                buf.append(alt.toString());
            }
            buf.append(")");
            return buf.toString();
        }
    }

    protected abstract class Node {
        protected Node() {
        }

        public abstract String toString();
    }

    protected class Rule {
        String name;
        Block block;

        public Rule(String name, Block block) {
            this.name = name;
            this.block = block;
        }

        public String toString() {
            return this.name + ":" + this.block;
        }
    }
}

