/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.AutoCompletionStyleContext;
import org.fife.ui.autocomplete.OutlineHighlightPainter;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletionChoicesWindow;
import org.fife.ui.autocomplete.ParameterizedCompletionDescriptionToolTip;
import org.fife.ui.autocomplete.ParameterizedCompletionInsertionInfo;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.ChangeableHighlightPainter;

class ParameterizedCompletionContext {
    private Window parentWindow;
    private AutoCompletion ac;
    private ParameterizedCompletion pc;
    private boolean active;
    private ParameterizedCompletionDescriptionToolTip tip;
    private Highlighter.HighlightPainter p;
    private Highlighter.HighlightPainter endingP;
    private Highlighter.HighlightPainter paramCopyP;
    private List<Object> tags;
    private List<ParamCopyInfo> paramCopyInfos;
    private transient boolean ignoringDocumentEvents;
    private Listener listener;
    private int minPos;
    private Position maxPos;
    private Position defaultEndOffs;
    private int lastSelectedParam;
    private ParameterizedCompletionChoicesWindow paramChoicesWindow;
    private String paramPrefix;
    private Object oldTabKey;
    private Action oldTabAction;
    private Object oldShiftTabKey;
    private Action oldShiftTabAction;
    private Object oldUpKey;
    private Action oldUpAction;
    private Object oldDownKey;
    private Action oldDownAction;
    private Object oldEnterKey;
    private Action oldEnterAction;
    private Object oldEscapeKey;
    private Action oldEscapeAction;
    private Object oldClosingKey;
    private Action oldClosingAction;
    private static final String IM_KEY_TAB = "ParamCompKey.Tab";
    private static final String IM_KEY_SHIFT_TAB = "ParamCompKey.ShiftTab";
    private static final String IM_KEY_UP = "ParamCompKey.Up";
    private static final String IM_KEY_DOWN = "ParamCompKey.Down";
    private static final String IM_KEY_ESCAPE = "ParamCompKey.Escape";
    private static final String IM_KEY_ENTER = "ParamCompKey.Enter";
    private static final String IM_KEY_CLOSING = "ParamCompKey.Closing";

    ParameterizedCompletionContext(Window owner, AutoCompletion ac5, ParameterizedCompletion pc5) {
        this.parentWindow = owner;
        this.ac = ac5;
        this.pc = pc5;
        this.listener = new Listener();
        AutoCompletionStyleContext sc5 = AutoCompletion.getStyleContext();
        this.p = new OutlineHighlightPainter(sc5.getParameterOutlineColor());
        this.endingP = new OutlineHighlightPainter(sc5.getParameterizedCompletionCursorPositionColor());
        this.paramCopyP = new ChangeableHighlightPainter(sc5.getParameterCopyColor());
        this.tags = new ArrayList<Object>(1);
        this.paramCopyInfos = new ArrayList<ParamCopyInfo>(1);
    }

    public void activate() {
        if (this.active) {
            return;
        }
        this.active = true;
        JTextComponent tc5 = this.ac.getTextComponent();
        this.lastSelectedParam = -1;
        if (this.pc.getShowParameterToolTip()) {
            this.tip = new ParameterizedCompletionDescriptionToolTip(this.parentWindow, this, this.ac, this.pc);
            try {
                int dot = tc5.getCaretPosition();
                Rectangle r15 = tc5.modelToView(dot);
                Point p15 = new Point(r15.x, r15.y);
                SwingUtilities.convertPointToScreen(p15, tc5);
                r15.x = p15.x;
                r15.y = p15.y;
                this.tip.setLocationRelativeTo(r15);
                this.tip.setVisible(true);
            }
            catch (BadLocationException ble) {
                UIManager.getLookAndFeel().provideErrorFeedback(tc5);
                ble.printStackTrace();
                this.tip = null;
            }
        }
        this.listener.install(tc5);
        if (this.paramChoicesWindow == null) {
            this.paramChoicesWindow = this.createParamChoicesWindow();
        }
        this.lastSelectedParam = this.getCurrentParameterIndex();
        this.prepareParamChoicesWindow();
        this.paramChoicesWindow.setVisible(true);
    }

    private ParameterizedCompletionChoicesWindow createParamChoicesWindow() {
        ParameterizedCompletionChoicesWindow pcw = new ParameterizedCompletionChoicesWindow(this.parentWindow, this.ac, this);
        pcw.initialize(this.pc);
        return pcw;
    }

    public void deactivate() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.listener.uninstall();
        if (this.tip != null) {
            this.tip.setVisible(false);
        }
        if (this.paramChoicesWindow != null) {
            this.paramChoicesWindow.setVisible(false);
        }
    }

    public String getArgumentText(int offs) {
        List<Highlighter.Highlight> paramHighlights = this.getParameterHighlights();
        if (paramHighlights == null || paramHighlights.isEmpty()) {
            return null;
        }
        for (Highlighter.Highlight h15 : paramHighlights) {
            if (offs < h15.getStartOffset() || offs > h15.getEndOffset()) continue;
            int start = h15.getStartOffset() + 1;
            int len = h15.getEndOffset() - start;
            JTextComponent tc5 = this.ac.getTextComponent();
            Document doc = tc5.getDocument();
            try {
                return doc.getText(start, len);
            }
            catch (BadLocationException ble) {
                UIManager.getLookAndFeel().provideErrorFeedback(tc5);
                ble.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private Highlighter.Highlight getCurrentParameterHighlight() {
        JTextComponent tc5 = this.ac.getTextComponent();
        int dot = tc5.getCaretPosition();
        if (dot > 0) {
            --dot;
        }
        List<Highlighter.Highlight> paramHighlights = this.getParameterHighlights();
        for (Highlighter.Highlight h15 : paramHighlights) {
            if (dot < h15.getStartOffset() || dot >= h15.getEndOffset()) continue;
            return h15;
        }
        return null;
    }

    private int getCurrentParameterIndex() {
        JTextComponent tc5 = this.ac.getTextComponent();
        int dot = tc5.getCaretPosition();
        if (dot > 0) {
            --dot;
        }
        List<Highlighter.Highlight> paramHighlights = this.getParameterHighlights();
        for (int i15 = 0; i15 < paramHighlights.size(); ++i15) {
            Highlighter.Highlight h15 = paramHighlights.get(i15);
            if (dot < h15.getStartOffset() || dot >= h15.getEndOffset()) continue;
            return i15;
        }
        return -1;
    }

    private int getCurrentParameterStartOffset() {
        Highlighter.Highlight h15 = this.getCurrentParameterHighlight();
        return h15 != null ? h15.getStartOffset() + 1 : -1;
    }

    private static int getFirstHighlight(List<Highlighter.Highlight> highlights) {
        int first = -1;
        Highlighter.Highlight firstH = null;
        for (int i15 = 0; i15 < highlights.size(); ++i15) {
            Highlighter.Highlight h15 = highlights.get(i15);
            if (firstH != null && h15.getStartOffset() >= firstH.getStartOffset()) continue;
            firstH = h15;
            first = i15;
        }
        return first;
    }

    private static int getLastHighlight(List<Highlighter.Highlight> highlights) {
        int last = -1;
        Highlighter.Highlight lastH = null;
        for (int i15 = highlights.size() - 1; i15 >= 0; --i15) {
            Highlighter.Highlight h15 = highlights.get(i15);
            if (lastH != null && h15.getStartOffset() <= lastH.getStartOffset()) continue;
            lastH = h15;
            last = i15;
        }
        return last;
    }

    public List<Highlighter.Highlight> getParameterHighlights() {
        Highlighter.Highlight[] highlights;
        ArrayList<Highlighter.Highlight> paramHighlights = new ArrayList<Highlighter.Highlight>(2);
        JTextComponent tc5 = this.ac.getTextComponent();
        for (Highlighter.Highlight highlight : highlights = tc5.getHighlighter().getHighlights()) {
            Highlighter.HighlightPainter painter = highlight.getPainter();
            if (painter != this.p && painter != this.endingP) continue;
            paramHighlights.add(highlight);
        }
        return paramHighlights;
    }

    boolean insertSelectedChoice() {
        String choice;
        if (this.paramChoicesWindow != null && this.paramChoicesWindow.isVisible() && (choice = this.paramChoicesWindow.getSelectedChoice()) != null) {
            JTextComponent tc5 = this.ac.getTextComponent();
            Highlighter.Highlight h15 = this.getCurrentParameterHighlight();
            if (h15 != null) {
                tc5.setSelectionStart(h15.getStartOffset() + 1);
                tc5.setSelectionEnd(h15.getEndOffset());
                tc5.replaceSelection(choice);
                this.moveToNextParam();
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(tc5);
            }
            return true;
        }
        return false;
    }

    private void installKeyBindings() {
        if (AutoCompletion.getDebug()) {
            System.out.println("CompletionContext: Installing keybindings");
        }
        JTextComponent tc5 = this.ac.getTextComponent();
        InputMap im4 = tc5.getInputMap();
        ActionMap am4 = tc5.getActionMap();
        KeyStroke ks4 = KeyStroke.getKeyStroke(9, 0);
        this.oldTabKey = im4.get(ks4);
        im4.put(ks4, IM_KEY_TAB);
        this.oldTabAction = am4.get(IM_KEY_TAB);
        am4.put(IM_KEY_TAB, new NextParamAction());
        ks4 = KeyStroke.getKeyStroke(9, 1);
        this.oldShiftTabKey = im4.get(ks4);
        im4.put(ks4, IM_KEY_SHIFT_TAB);
        this.oldShiftTabAction = am4.get(IM_KEY_SHIFT_TAB);
        am4.put(IM_KEY_SHIFT_TAB, new PrevParamAction());
        ks4 = KeyStroke.getKeyStroke(38, 0);
        this.oldUpKey = im4.get(ks4);
        im4.put(ks4, IM_KEY_UP);
        this.oldUpAction = am4.get(IM_KEY_UP);
        am4.put(IM_KEY_UP, new NextChoiceAction(-1, this.oldUpAction));
        ks4 = KeyStroke.getKeyStroke(40, 0);
        this.oldDownKey = im4.get(ks4);
        im4.put(ks4, IM_KEY_DOWN);
        this.oldDownAction = am4.get(IM_KEY_DOWN);
        am4.put(IM_KEY_DOWN, new NextChoiceAction(1, this.oldDownAction));
        ks4 = KeyStroke.getKeyStroke(10, 0);
        this.oldEnterKey = im4.get(ks4);
        im4.put(ks4, IM_KEY_ENTER);
        this.oldEnterAction = am4.get(IM_KEY_ENTER);
        am4.put(IM_KEY_ENTER, new GotoEndAction());
        ks4 = KeyStroke.getKeyStroke(27, 0);
        this.oldEscapeKey = im4.get(ks4);
        im4.put(ks4, IM_KEY_ESCAPE);
        this.oldEscapeAction = am4.get(IM_KEY_ESCAPE);
        am4.put(IM_KEY_ESCAPE, new HideAction());
        char end = this.pc.getProvider().getParameterListEnd();
        if (end > '\u0000') {
            ks4 = KeyStroke.getKeyStroke(end);
            this.oldClosingKey = im4.get(ks4);
            im4.put(ks4, IM_KEY_CLOSING);
            this.oldClosingAction = am4.get(IM_KEY_CLOSING);
            am4.put(IM_KEY_CLOSING, new ClosingAction());
        }
    }

    private void moveToNextParam() {
        JTextComponent tc5 = this.ac.getTextComponent();
        int dot = tc5.getCaretPosition();
        int tagCount = this.tags.size();
        if (tagCount == 0) {
            tc5.setCaretPosition(this.maxPos.getOffset());
            this.deactivate();
        }
        Highlighter.Highlight currentNext = null;
        int pos = -1;
        List<Highlighter.Highlight> highlights = this.getParameterHighlights();
        for (int i15 = 0; i15 < highlights.size(); ++i15) {
            Highlighter.Highlight hl4 = highlights.get(i15);
            if (currentNext != null && currentNext.getStartOffset() >= dot && (hl4.getStartOffset() <= dot || hl4.getStartOffset() > currentNext.getStartOffset())) continue;
            currentNext = hl4;
            pos = i15;
        }
        if (currentNext.getStartOffset() + 1 <= dot) {
            int nextIndex = ParameterizedCompletionContext.getFirstHighlight(highlights);
            currentNext = highlights.get(nextIndex);
            pos = 0;
        }
        tc5.setSelectionStart(currentNext.getStartOffset() + 1);
        tc5.setSelectionEnd(currentNext.getEndOffset());
        this.updateToolTipText(pos);
    }

    private void moveToPreviousParam() {
        JTextComponent tc5 = this.ac.getTextComponent();
        int tagCount = this.tags.size();
        if (tagCount == 0) {
            tc5.setCaretPosition(this.maxPos.getOffset());
            this.deactivate();
        }
        int dot = tc5.getCaretPosition();
        int selStart = tc5.getSelectionStart() - 1;
        Highlighter.Highlight currentPrev = null;
        int pos = 0;
        List<Highlighter.Highlight> highlights = this.getParameterHighlights();
        for (int i15 = 0; i15 < highlights.size(); ++i15) {
            Highlighter.Highlight h15 = highlights.get(i15);
            if (currentPrev != null && currentPrev.getStartOffset() < dot && (h15.getStartOffset() >= selStart || h15.getStartOffset() <= currentPrev.getStartOffset() && pos != this.lastSelectedParam)) continue;
            currentPrev = h15;
            pos = i15;
        }
        int firstIndex = ParameterizedCompletionContext.getFirstHighlight(highlights);
        if (pos == firstIndex && this.lastSelectedParam == firstIndex && highlights.size() > 1) {
            pos = ParameterizedCompletionContext.getLastHighlight(highlights);
            currentPrev = highlights.get(pos);
            tc5.setSelectionStart(currentPrev.getStartOffset() + 1);
            tc5.setSelectionEnd(currentPrev.getEndOffset());
            this.updateToolTipText(pos);
        } else if (currentPrev != null && dot > currentPrev.getStartOffset()) {
            tc5.setSelectionStart(currentPrev.getStartOffset() + 1);
            tc5.setSelectionEnd(currentPrev.getEndOffset());
            this.updateToolTipText(pos);
        } else {
            tc5.setCaretPosition(this.maxPos.getOffset());
            this.deactivate();
        }
    }

    private void possiblyUpdateParamCopies(Document doc) {
        int index = this.getCurrentParameterIndex();
        if (index > -1 && index < this.pc.getParamCount()) {
            ParameterizedCompletion.Parameter param = this.pc.getParam(index);
            if (param.isEndParam()) {
                this.deactivate();
                return;
            }
            List<Highlighter.Highlight> paramHighlights = this.getParameterHighlights();
            Highlighter.Highlight h15 = paramHighlights.get(index);
            int start = h15.getStartOffset() + 1;
            int len = h15.getEndOffset() - start;
            String replacement = null;
            try {
                replacement = doc.getText(start, len);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            for (ParamCopyInfo pci : this.paramCopyInfos) {
                if (!pci.paramName.equals(param.getName())) continue;
                pci.h = this.replaceHighlightedText(doc, pci.h, replacement);
            }
        } else {
            this.deactivate();
        }
    }

    private void prepareParamChoicesWindow() {
        if (this.paramChoicesWindow != null) {
            int offs = this.getCurrentParameterStartOffset();
            if (offs == -1) {
                this.paramChoicesWindow.setVisible(false);
                return;
            }
            JTextComponent tc5 = this.ac.getTextComponent();
            try {
                Rectangle r15 = tc5.modelToView(offs);
                Point p15 = new Point(r15.x, r15.y);
                SwingUtilities.convertPointToScreen(p15, tc5);
                r15.x = p15.x;
                r15.y = p15.y;
                this.paramChoicesWindow.setLocationRelativeTo(r15);
            }
            catch (BadLocationException ble) {
                UIManager.getLookAndFeel().provideErrorFeedback(tc5);
                ble.printStackTrace();
            }
            this.paramChoicesWindow.setParameter(this.lastSelectedParam, this.paramPrefix);
        }
    }

    private void removeParameterHighlights() {
        JTextComponent tc5 = this.ac.getTextComponent();
        Highlighter h15 = tc5.getHighlighter();
        for (Object tag : this.tags) {
            h15.removeHighlight(tag);
        }
        this.tags.clear();
        for (ParamCopyInfo pci : this.paramCopyInfos) {
            h15.removeHighlight(pci.h);
        }
        this.paramCopyInfos.clear();
    }

    private Highlighter.Highlight replaceHighlightedText(Document doc, Highlighter.Highlight h15, String replacement) {
        try {
            int start = h15.getStartOffset();
            int len = h15.getEndOffset() - start;
            Highlighter highlighter = this.ac.getTextComponent().getHighlighter();
            highlighter.removeHighlight(h15);
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).replace(start, len, replacement, null);
            } else {
                doc.remove(start, len);
                doc.insertString(start, replacement, null);
            }
            int newEnd = start + replacement.length();
            h15 = (Highlighter.Highlight)highlighter.addHighlight(start, newEnd, this.paramCopyP);
            return h15;
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return null;
        }
    }

    private void uninstallKeyBindings() {
        if (AutoCompletion.getDebug()) {
            System.out.println("CompletionContext Uninstalling keybindings");
        }
        JTextComponent tc5 = this.ac.getTextComponent();
        InputMap im4 = tc5.getInputMap();
        ActionMap am4 = tc5.getActionMap();
        KeyStroke ks4 = KeyStroke.getKeyStroke(9, 0);
        im4.put(ks4, this.oldTabKey);
        am4.put(IM_KEY_TAB, this.oldTabAction);
        ks4 = KeyStroke.getKeyStroke(9, 1);
        im4.put(ks4, this.oldShiftTabKey);
        am4.put(IM_KEY_SHIFT_TAB, this.oldShiftTabAction);
        ks4 = KeyStroke.getKeyStroke(38, 0);
        im4.put(ks4, this.oldUpKey);
        am4.put(IM_KEY_UP, this.oldUpAction);
        ks4 = KeyStroke.getKeyStroke(40, 0);
        im4.put(ks4, this.oldDownKey);
        am4.put(IM_KEY_DOWN, this.oldDownAction);
        ks4 = KeyStroke.getKeyStroke(10, 0);
        im4.put(ks4, this.oldEnterKey);
        am4.put(IM_KEY_ENTER, this.oldEnterAction);
        ks4 = KeyStroke.getKeyStroke(27, 0);
        im4.put(ks4, this.oldEscapeKey);
        am4.put(IM_KEY_ESCAPE, this.oldEscapeAction);
        char end = this.pc.getProvider().getParameterListEnd();
        if (end > '\u0000') {
            ks4 = KeyStroke.getKeyStroke(end);
            im4.put(ks4, this.oldClosingKey);
            am4.put(IM_KEY_CLOSING, this.oldClosingAction);
        }
    }

    private String updateToolTipText() {
        JTextComponent tc5 = this.ac.getTextComponent();
        int dot = tc5.getSelectionStart();
        int mark = tc5.getSelectionEnd();
        int index = -1;
        String paramPrefix = null;
        List<Highlighter.Highlight> paramHighlights = this.getParameterHighlights();
        for (int i15 = 0; i15 < paramHighlights.size(); ++i15) {
            Highlighter.Highlight h15 = paramHighlights.get(i15);
            int start = h15.getStartOffset() + 1;
            if (dot < start || dot > h15.getEndOffset()) continue;
            try {
                if (dot != start || mark != h15.getEndOffset()) {
                    paramPrefix = tc5.getText(start, dot - start);
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            index = i15;
            break;
        }
        this.updateToolTipText(index);
        return paramPrefix;
    }

    private void updateToolTipText(int selectedParam) {
        if (selectedParam != this.lastSelectedParam) {
            if (this.tip != null) {
                this.tip.updateText(selectedParam);
            }
            this.lastSelectedParam = selectedParam;
        }
    }

    public void updateUI() {
        if (this.tip != null) {
            this.tip.updateUI();
        }
        if (this.paramChoicesWindow != null) {
            this.paramChoicesWindow.updateUI();
        }
    }

    private final class Listener
    implements FocusListener,
    CaretListener,
    DocumentListener {
        private boolean markOccurrencesEnabled;

        private Listener() {
        }

        @Override
        public void caretUpdate(CaretEvent e15) {
            if (ParameterizedCompletionContext.this.maxPos == null) {
                ParameterizedCompletionContext.this.deactivate();
                return;
            }
            int dot = e15.getDot();
            if (dot < ParameterizedCompletionContext.this.minPos || dot > ParameterizedCompletionContext.this.maxPos.getOffset()) {
                ParameterizedCompletionContext.this.deactivate();
                return;
            }
            ParameterizedCompletionContext.this.paramPrefix = ParameterizedCompletionContext.this.updateToolTipText();
            if (ParameterizedCompletionContext.this.active) {
                ParameterizedCompletionContext.this.prepareParamChoicesWindow();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e15) {
        }

        @Override
        public void focusGained(FocusEvent e15) {
        }

        @Override
        public void focusLost(FocusEvent e15) {
            ParameterizedCompletionContext.this.deactivate();
        }

        private void handleDocumentEvent(DocumentEvent e15) {
            if (!ParameterizedCompletionContext.this.ignoringDocumentEvents) {
                ParameterizedCompletionContext.this.ignoringDocumentEvents = true;
                SwingUtilities.invokeLater(() -> {
                    ParameterizedCompletionContext.this.possiblyUpdateParamCopies(e15.getDocument());
                    ParameterizedCompletionContext.this.ignoringDocumentEvents = false;
                });
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e15) {
            this.handleDocumentEvent(e15);
        }

        public void install(JTextComponent tc5) {
            boolean replaceTabs = false;
            if (tc5 instanceof RSyntaxTextArea) {
                RSyntaxTextArea textArea = (RSyntaxTextArea)tc5;
                this.markOccurrencesEnabled = textArea.getMarkOccurrences();
                textArea.setMarkOccurrences(false);
                replaceTabs = textArea.getTabsEmulated();
            }
            Highlighter h15 = tc5.getHighlighter();
            try {
                int i15;
                ParameterizedCompletionInsertionInfo info = ParameterizedCompletionContext.this.pc.getInsertionInfo(tc5, replaceTabs);
                tc5.replaceSelection(info.getTextToInsert());
                int replacementCount = info.getReplacementCount();
                for (i15 = 0; i15 < replacementCount; ++i15) {
                    DocumentRange dr4 = info.getReplacementLocation(i15);
                    Highlighter.HighlightPainter painter = i15 < replacementCount - 1 ? ParameterizedCompletionContext.this.p : ParameterizedCompletionContext.this.endingP;
                    ParameterizedCompletionContext.this.tags.add(h15.addHighlight(dr4.getStartOffset() - 1, dr4.getEndOffset(), painter));
                }
                for (i15 = 0; i15 < info.getReplacementCopyCount(); ++i15) {
                    ParameterizedCompletionInsertionInfo.ReplacementCopy rc5 = info.getReplacementCopy(i15);
                    ParameterizedCompletionContext.this.paramCopyInfos.add(new ParamCopyInfo(rc5.getId(), (Highlighter.Highlight)h15.addHighlight(rc5.getStart(), rc5.getEnd(), ParameterizedCompletionContext.this.paramCopyP)));
                }
                tc5.setCaretPosition(info.getSelectionStart());
                if (info.hasSelection()) {
                    tc5.moveCaretPosition(info.getSelectionEnd());
                }
                ParameterizedCompletionContext.this.minPos = info.getMinOffset();
                ParameterizedCompletionContext.this.maxPos = info.getMaxOffset();
                try {
                    Document doc = tc5.getDocument();
                    if (ParameterizedCompletionContext.this.maxPos.getOffset() == 0) {
                        ParameterizedCompletionContext.this.maxPos = doc.createPosition(info.getTextToInsert().length());
                    }
                    ParameterizedCompletionContext.this.defaultEndOffs = doc.createPosition(info.getDefaultEndOffs());
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
                tc5.getDocument().addDocumentListener(this);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            tc5.addCaretListener(this);
            tc5.addFocusListener(this);
            ParameterizedCompletionContext.this.installKeyBindings();
        }

        @Override
        public void removeUpdate(DocumentEvent e15) {
            this.handleDocumentEvent(e15);
        }

        public void uninstall() {
            JTextComponent tc5 = ParameterizedCompletionContext.this.ac.getTextComponent();
            tc5.removeCaretListener(this);
            tc5.removeFocusListener(this);
            tc5.getDocument().removeDocumentListener(this);
            ParameterizedCompletionContext.this.uninstallKeyBindings();
            if (this.markOccurrencesEnabled) {
                ((RSyntaxTextArea)tc5).setMarkOccurrences(this.markOccurrencesEnabled);
            }
            ParameterizedCompletionContext.this.maxPos = null;
            ParameterizedCompletionContext.this.minPos = -1;
            ParameterizedCompletionContext.this.removeParameterHighlights();
        }
    }

    private final class NextParamAction
    extends AbstractAction {
        private NextParamAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e15) {
            ParameterizedCompletionContext.this.moveToNextParam();
        }
    }

    private final class PrevParamAction
    extends AbstractAction {
        private PrevParamAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e15) {
            ParameterizedCompletionContext.this.moveToPreviousParam();
        }
    }

    private class NextChoiceAction
    extends AbstractAction {
        private Action oldAction;
        private int amount;

        NextChoiceAction(int amount, Action oldAction) {
            this.amount = amount;
            this.oldAction = oldAction;
        }

        @Override
        public void actionPerformed(ActionEvent e15) {
            if (ParameterizedCompletionContext.this.paramChoicesWindow != null && ParameterizedCompletionContext.this.paramChoicesWindow.isVisible()) {
                ParameterizedCompletionContext.this.paramChoicesWindow.incSelection(this.amount);
            } else if (this.oldAction != null) {
                this.oldAction.actionPerformed(e15);
            } else {
                ParameterizedCompletionContext.this.deactivate();
            }
        }
    }

    private final class GotoEndAction
    extends AbstractAction {
        private GotoEndAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e15) {
            if (ParameterizedCompletionContext.this.paramChoicesWindow != null && ParameterizedCompletionContext.this.paramChoicesWindow.isVisible() && ParameterizedCompletionContext.this.insertSelectedChoice()) {
                return;
            }
            ParameterizedCompletionContext.this.deactivate();
            JTextComponent tc5 = ParameterizedCompletionContext.this.ac.getTextComponent();
            int dot = tc5.getCaretPosition();
            if (dot != ParameterizedCompletionContext.this.defaultEndOffs.getOffset()) {
                tc5.setCaretPosition(ParameterizedCompletionContext.this.defaultEndOffs.getOffset());
            } else {
                Action a15 = this.getDefaultEnterAction(tc5);
                if (a15 != null) {
                    a15.actionPerformed(e15);
                } else {
                    tc5.replaceSelection("\n");
                }
            }
        }

        private Action getDefaultEnterAction(JTextComponent tc5) {
            ActionMap am4 = tc5.getActionMap();
            return am4.get("insert-break");
        }
    }

    private final class HideAction
    extends AbstractAction {
        private HideAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e15) {
            if (ParameterizedCompletionContext.this.paramChoicesWindow != null && ParameterizedCompletionContext.this.paramChoicesWindow.isVisible()) {
                ParameterizedCompletionContext.this.paramChoicesWindow.setVisible(false);
                ParameterizedCompletionContext.this.paramChoicesWindow = null;
            } else {
                ParameterizedCompletionContext.this.deactivate();
            }
        }
    }

    private final class ClosingAction
    extends AbstractAction {
        private ClosingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e15) {
            JTextComponent tc5 = ParameterizedCompletionContext.this.ac.getTextComponent();
            int dot = tc5.getCaretPosition();
            char end = ParameterizedCompletionContext.this.pc.getProvider().getParameterListEnd();
            if (dot >= ParameterizedCompletionContext.this.maxPos.getOffset() - 2) {
                int endCount;
                char start;
                int startCount;
                String text = ParameterizedCompletionContext.this.getArgumentText(dot);
                if (text != null && (startCount = this.getCount(text, start = ParameterizedCompletionContext.this.pc.getProvider().getParameterListStart())) > (endCount = this.getCount(text, end))) {
                    tc5.replaceSelection(Character.toString(end));
                    return;
                }
                tc5.setCaretPosition(Math.min(tc5.getCaretPosition() + 1, tc5.getDocument().getLength()));
                ParameterizedCompletionContext.this.deactivate();
            } else {
                tc5.replaceSelection(Character.toString(end));
            }
        }

        public int getCount(String text, char ch4) {
            int pos;
            int count = 0;
            int old = 0;
            while ((pos = text.indexOf(ch4, old)) > -1) {
                ++count;
                old = pos + 1;
            }
            return count;
        }
    }

    private static class ParamCopyInfo {
        private String paramName;
        private Highlighter.Highlight h;

        ParamCopyInfo(String paramName, Highlighter.Highlight h15) {
            this.paramName = paramName;
            this.h = h15;
        }
    }
}

