/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyString;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InstanceVariables;
import org.jruby.runtime.builtin.InternalVariables;
import org.jruby.runtime.builtin.RubyJavaObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.util.TypeConverter;

public final class BasicObjectStub {
    public static final InternalVariables DUMMY_INTERNAL_VARIABLES = new DummyInternalVariables();

    public static IRubyObject callSuper(IRubyObject self2, ThreadContext context, IRubyObject[] args2, Block block) {
        return Helpers.invokeSuper(context, self2, args2, block);
    }

    public static IRubyObject callMethod(IRubyObject self2, ThreadContext context, String name2) {
        return Helpers.invoke(context, self2, name2);
    }

    public static IRubyObject callMethod(IRubyObject self2, ThreadContext context, String name2, IRubyObject arg2) {
        return Helpers.invoke(context, self2, name2, arg2);
    }

    public static IRubyObject callMethod(IRubyObject self2, ThreadContext context, String name2, IRubyObject[] args2) {
        return Helpers.invoke(context, self2, name2, args2);
    }

    public static IRubyObject callMethod(IRubyObject self2, ThreadContext context, String name2, IRubyObject[] args2, Block block) {
        return Helpers.invoke(context, self2, name2, args2, block);
    }

    public static IRubyObject callMethod(IRubyObject self2, ThreadContext context, int methodIndex, String name2) {
        return Helpers.invoke(context, self2, name2);
    }

    public static IRubyObject callMethod(IRubyObject self2, ThreadContext context, int methodIndex, String name2, IRubyObject arg2) {
        return Helpers.invoke(context, self2, name2, arg2);
    }

    public static boolean isNil(IRubyObject self2) {
        return false;
    }

    public static boolean isTrue(IRubyObject self2) {
        return true;
    }

    public static boolean isTaint(IRubyObject self2) {
        return false;
    }

    public static void setTaint(IRubyObject self2, boolean b2) {
    }

    public static IRubyObject infectBy(IRubyObject self2, IRubyObject obj) {
        return self2;
    }

    public static boolean isFrozen(IRubyObject self2) {
        return false;
    }

    public static void setFrozen(IRubyObject self2, boolean b2) {
    }

    public static boolean isUntrusted(IRubyObject self2) {
        return false;
    }

    public static void setUntrusted(IRubyObject self2, boolean b2) {
    }

    public static boolean isImmediate(IRubyObject self2) {
        return false;
    }

    public static RubyClass getMetaClass(IRubyObject self2) {
        if (self2 instanceof RubyBasicObject) {
            return RubyBasicObject.getMetaClass(self2);
        }
        if (self2 instanceof RubyJavaObject) {
            return ((RubyJavaObject)((Object)self2)).getMetaClass();
        }
        throw new RuntimeException("unknown object type in BasicObjectStuff.getMetaClass: " + String.valueOf(self2.getClass()));
    }

    public static RubyClass getSingletonClass(IRubyObject self2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static RubyClass getType(IRubyObject self2) {
        return BasicObjectStub.getMetaClass(self2).getRealClass();
    }

    public static boolean respondsTo(IRubyObject self2, String name2) {
        RubyClass metaClass = BasicObjectStub.getMetaClass(self2);
        if (metaClass.searchMethod("respond_to?").equals(metaClass.runtime.getRespondToMethod())) {
            return metaClass.isMethodBound(name2, false);
        }
        Ruby runtime2 = metaClass.runtime;
        return BasicObjectStub.callMethod(self2, runtime2.getCurrentContext(), "respond_to?", runtime2.newSymbol(name2)).isTrue();
    }

    public static Ruby getRuntime(IRubyObject self2) {
        return BasicObjectStub.getMetaClass((IRubyObject)self2).runtime;
    }

    public static Class getJavaClass(IRubyObject self2) {
        return self2.getClass();
    }

    public static String asJavaString(IRubyObject self2) {
        IRubyObject asString = BasicObjectStub.checkStringType(self2);
        if (asString.isNil()) {
            throw Error.typeError(BasicObjectStub.getRuntime(self2).getCurrentContext(), "", BasicObjectStub.inspect(self2), " is not a string");
        }
        return asString.asJavaString();
    }

    public static RubyString asString(IRubyObject self2) {
        IRubyObject str = Helpers.invoke(BasicObjectStub.getRuntime(self2).getCurrentContext(), self2, "to_s");
        if (!(str instanceof RubyString)) {
            return (RubyString)BasicObjectStub.anyToString(self2);
        }
        return (RubyString)str;
    }

    public static RubyArray convertToArray(IRubyObject self2) {
        return (RubyArray)TypeConverter.convertToType(self2, BasicObjectStub.getRuntime(self2).getArray(), "to_ary");
    }

    public static RubyHash convertToHash(IRubyObject self2) {
        return (RubyHash)TypeConverter.convertToType(self2, BasicObjectStub.getRuntime(self2).getHash(), "to_hash");
    }

    public static RubyFloat convertToFloat(IRubyObject self2) {
        return (RubyFloat)TypeConverter.convertToType(self2, BasicObjectStub.getRuntime(self2).getFloat(), "to_f");
    }

    public static RubyInteger convertToInteger(IRubyObject self2) {
        return BasicObjectStub.convertToInteger(self2, "to_int");
    }

    public static RubyInteger convertToInteger(IRubyObject self2, int convertMethodIndex, String convertMethod) {
        return BasicObjectStub.convertToInteger(self2, convertMethod);
    }

    public static RubyInteger convertToInteger(IRubyObject self2, String convertMethod) {
        Ruby runtime2 = BasicObjectStub.getRuntime(self2);
        IRubyObject val = TypeConverter.convertToType(self2, runtime2.getInteger(), convertMethod, true);
        if (!(val instanceof RubyInteger)) {
            throw Error.typeError(runtime2.getCurrentContext(), "", self2, "#" + convertMethod + " should return Integer");
        }
        return (RubyInteger)val;
    }

    public static RubyString convertToString(IRubyObject self2) {
        return (RubyString)TypeConverter.convertToType(self2, BasicObjectStub.getRuntime(self2).getString(), "to_str");
    }

    public static IRubyObject anyToString(IRubyObject self2) {
        RubyClass metaClass = BasicObjectStub.getMetaClass(self2);
        String cname = metaClass.getRealClass().getName(metaClass.getRuntime().getCurrentContext());
        return metaClass.runtime.newString("#<" + cname + ":0x" + Integer.toHexString(System.identityHashCode(self2)) + ">");
    }

    public static IRubyObject checkStringType(IRubyObject self2) {
        Ruby runtime2 = BasicObjectStub.getRuntime(self2);
        IRubyObject str = TypeConverter.convertToTypeWithCheck(self2, runtime2.getString(), "to_str");
        if (!str.isNil() && !(str instanceof RubyString)) {
            str = RubyString.newEmptyString(runtime2);
        }
        return str;
    }

    public static IRubyObject checkArrayType(IRubyObject self2) {
        return TypeConverter.convertToTypeWithCheck(self2, BasicObjectStub.getRuntime(self2).getArray(), "to_ary");
    }

    public static Object toJava(IRubyObject self2, Class cls) {
        if (!cls.isAssignableFrom(self2.getClass())) {
            throw Error.typeError(self2.getRuntime().getCurrentContext(), "could not convert ", self2, " to " + String.valueOf(cls));
        }
        return self2;
    }

    public static IRubyObject dup(IRubyObject self2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject inspect(IRubyObject self2) {
        ThreadContext context = BasicObjectStub.getRuntime(self2).getCurrentContext();
        if (BasicObjectStub.hasVariables(self2)) {
            StringBuilder part = new StringBuilder();
            String cname = BasicObjectStub.getMetaClass(self2).getRealClass().getName(context);
            part.append("#<").append(cname).append(":0x");
            part.append(Integer.toHexString(System.identityHashCode(self2)));
            if (context.runtime.isInspecting(self2)) {
                part.append(" ...>");
                return Create.newString(context, part.toString());
            }
            try {
                context.runtime.registerInspecting(self2);
                RubyString rubyString = Create.newString(context, BasicObjectStub.inspectObj(self2, part).toString());
                return rubyString;
            }
            finally {
                context.runtime.unregisterInspecting(self2);
            }
        }
        return Helpers.invoke(context, self2, "to_s");
    }

    private static StringBuilder inspectObj(IRubyObject self2, final StringBuilder part) {
        final ThreadContext context = BasicObjectStub.getRuntime(self2).getCurrentContext();
        BasicObjectStub.getInstanceVariables(self2).forEachInstanceVariable(new BiConsumer<String, IRubyObject>(){
            String sep = "";

            @Override
            public void accept(String name2, IRubyObject value2) {
                part.append(this.sep).append(' ').append(name2).append('=');
                part.append(Helpers.invokedynamic(context, value2, MethodNames.INSPECT));
                this.sep = ",";
            }
        });
        part.append('>');
        return part;
    }

    public static IRubyObject rbClone(IRubyObject self2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static boolean isModule(IRubyObject self2) {
        return false;
    }

    public static boolean isClass(IRubyObject self2) {
        return false;
    }

    public static void dataWrapStruct(IRubyObject self2, Object obj) {
    }

    public static Object dataGetStruct(IRubyObject self2) {
        return null;
    }

    public static Object dataGetStructChecked(IRubyObject self2) {
        return null;
    }

    public static IRubyObject id(IRubyObject self2) {
        return BasicObjectStub.getRuntime(self2).newFixnum(System.identityHashCode(self2));
    }

    public static IRubyObject op_equal(IRubyObject self2, ThreadContext context, IRubyObject other) {
        return Convert.asBoolean(context, self2 == other);
    }

    public static IRubyObject op_eqq(IRubyObject self2, ThreadContext context, IRubyObject other) {
        return Convert.asBoolean(context, self2 == other);
    }

    public static boolean eql(IRubyObject self2, IRubyObject other) {
        return self2 == other;
    }

    public static void addFinalizer(IRubyObject self2, IRubyObject finalizer) {
    }

    public static void removeFinalizers(IRubyObject self2) {
    }

    public static boolean hasVariables(IRubyObject self2) {
        return false;
    }

    public static int getVariableCount(IRubyObject self2) {
        return 0;
    }

    public static void syncVariables(IRubyObject self2, List<Variable<Object>> variables) {
    }

    public static List<Variable<Object>> getVariableList(IRubyObject self2) {
        return Collections.EMPTY_LIST;
    }

    public static InstanceVariables getInstanceVariables(IRubyObject self2) {
        return new DummyInstanceVariables(BasicObjectStub.getRuntime(self2).getNil());
    }

    public static InternalVariables getInternalVariables(IRubyObject self2) {
        return DUMMY_INTERNAL_VARIABLES;
    }

    public static List<String> getVariableNameList(IRubyObject self2) {
        return Collections.EMPTY_LIST;
    }

    public static void copySpecialInstanceVariables(IRubyObject self2, IRubyObject clone2) {
    }

    public static Object getVariable(IRubyObject self2, int index2) {
        return null;
    }

    public static void setVariable(IRubyObject self2, int index2, Object value2) {
    }

    public static class DummyInstanceVariables
    implements InstanceVariables {
        private final IRubyObject nil;

        public DummyInstanceVariables(IRubyObject nil) {
            this.nil = nil;
        }

        @Override
        public boolean hasInstanceVariable(String name2) {
            return false;
        }

        @Override
        public boolean fastHasInstanceVariable(String internedName) {
            return false;
        }

        @Override
        public IRubyObject getInstanceVariable(String name2) {
            return this.nil;
        }

        @Override
        public IRubyObject fastGetInstanceVariable(String internedName) {
            return this.nil;
        }

        @Override
        public IRubyObject setInstanceVariable(String name2, IRubyObject value2) {
            return value2;
        }

        @Override
        public IRubyObject fastSetInstanceVariable(String internedName, IRubyObject value2) {
            return value2;
        }

        @Override
        public IRubyObject removeInstanceVariable(String name2) {
            return this.nil;
        }

        @Override
        public List<Variable<IRubyObject>> getInstanceVariableList() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List<String> getInstanceVariableNameList() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public void copyInstanceVariablesInto(InstanceVariables other) {
        }
    }

    public static class DummyInternalVariables
    implements InternalVariables {
        @Override
        public boolean hasInternalVariable(String name2) {
            return false;
        }

        @Override
        public boolean fastHasInternalVariable(String internedName) {
            return false;
        }

        @Override
        public Object getInternalVariable(String name2) {
            return null;
        }

        @Override
        public Object fastGetInternalVariable(String internedName) {
            return null;
        }

        @Override
        public void setInternalVariable(String name2, Object value2) {
        }

        @Override
        public void fastSetInternalVariable(String internedName, Object value2) {
        }

        @Override
        public Object removeInternalVariable(String name2) {
            return null;
        }
    }
}

