/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juife;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import net.sf.juife.NavigationHistoryModel;

public class DefaultNavigationHistoryModel<P>
implements NavigationHistoryModel<P> {
    private final LinkedList<P> histList = new LinkedList();
    private ListIterator<P> listIt = this.histList.listIterator();
    private final Vector<ActionListener> listeners = new Vector();

    @Override
    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.listeners.remove(l);
    }

    protected void fireActionPerformed() {
        ActionEvent e = new ActionEvent(this, 1001, "");
        for (ActionListener l : this.listeners) {
            if (l == null) continue;
            l.actionPerformed(e);
        }
    }

    @Override
    public void addPage(P page) {
        if (page == null) {
            return;
        }
        if (page.equals(this.getCurrentPage())) {
            return;
        }
        while (this.listIt.hasNext()) {
            this.listIt.next();
            this.listIt.remove();
        }
        this.listIt.add(page);
        this.fireActionPerformed();
    }

    @Override
    public P goBack() {
        if (!this.hasBack()) {
            return null;
        }
        this.listIt.previous();
        this.fireActionPerformed();
        return this.getCurrentPage();
    }

    @Override
    public boolean hasBack() {
        return this.listIt.previousIndex() > 0;
    }

    @Override
    public P goForward() {
        if (!this.listIt.hasNext()) {
            return null;
        }
        this.listIt.next();
        this.fireActionPerformed();
        return this.getCurrentPage();
    }

    @Override
    public boolean hasForward() {
        return this.listIt.hasNext();
    }

    @Override
    public void goFirst() {
        if (this.listIt.previousIndex() < 1) {
            return;
        }
        while (this.listIt.previousIndex() > 0) {
            this.listIt.previous();
        }
        this.fireActionPerformed();
    }

    @Override
    public void goLast() {
        if (!this.listIt.hasNext()) {
            return;
        }
        while (this.listIt.hasNext()) {
            this.listIt.next();
        }
        this.fireActionPerformed();
    }

    @Override
    public P getCurrentPage() {
        int idx = this.listIt.previousIndex();
        return idx == -1 ? null : (P)this.histList.get(idx);
    }

    @Override
    public int getPageCount() {
        return this.histList.size();
    }

    @Override
    public void clearHistory() {
        P p = this.getCurrentPage();
        if (p == null) {
            return;
        }
        this.histList.clear();
        this.listIt = this.histList.listIterator();
        this.listIt.add(p);
        this.fireActionPerformed();
    }

    protected void removePage() {
        this.listIt.remove();
    }
}

