/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration.policy.impl;

import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.clientregistration.ClientRegistrationContext;
import org.keycloak.services.clientregistration.ClientRegistrationProvider;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicyException;
import org.keycloak.services.cors.Cors;

public class RegistrationWebOriginsPolicy
implements ClientRegistrationPolicy {
    private final KeycloakSession session;
    private final List<String> allowedWebOrigins;

    public RegistrationWebOriginsPolicy(KeycloakSession session, ComponentModel model) {
        this.session = session;
        this.allowedWebOrigins = model.getConfig().getList((Object)"web-origins");
    }

    @Override
    public void beforeRegister(ClientRegistrationContext context) throws ClientRegistrationPolicyException {
        this.addOrigins();
    }

    @Override
    public void afterRegister(ClientRegistrationContext context, ClientModel clientModel) {
    }

    @Override
    public void beforeUpdate(ClientRegistrationContext context, ClientModel clientModel) throws ClientRegistrationPolicyException {
        this.addOrigins();
    }

    @Override
    public void afterUpdate(ClientRegistrationContext context, ClientModel clientModel) {
    }

    @Override
    public void beforeView(ClientRegistrationProvider provider, ClientModel clientModel) throws ClientRegistrationPolicyException {
        this.addOrigins();
    }

    @Override
    public void beforeDelete(ClientRegistrationProvider provider, ClientModel clientModel) throws ClientRegistrationPolicyException {
        this.addOrigins();
    }

    private void addOrigins() {
        if (this.allowedWebOrigins != null && !this.allowedWebOrigins.isEmpty()) {
            ((Cors)this.session.getProvider(Cors.class)).addAllowedOrigins(this.allowedWebOrigins);
        }
    }
}

