/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.handlers.CountingOutputStream;
import org.jboss.logmanager.handlers.PeriodicRotatingFileHandler;
import org.jboss.logmanager.handlers.SecurityActions;
import org.jboss.logmanager.handlers.SuffixRotator;

public class PeriodicSizeRotatingFileHandler
extends PeriodicRotatingFileHandler {
    private final AccessControlContext acc = AccessController.getContext();
    private long rotateSize = 0xA00000L;
    private int maxBackupIndex = 1;
    private CountingOutputStream outputStream;
    private boolean rotateOnBoot;

    public PeriodicSizeRotatingFileHandler() {
    }

    public PeriodicSizeRotatingFileHandler(String fileName) throws FileNotFoundException {
        super(fileName);
    }

    public PeriodicSizeRotatingFileHandler(String fileName, boolean append) throws FileNotFoundException {
        super(fileName, append);
    }

    public PeriodicSizeRotatingFileHandler(File file, String suffix) throws FileNotFoundException {
        super(file, suffix);
    }

    public PeriodicSizeRotatingFileHandler(File file, String suffix, boolean append) throws FileNotFoundException {
        super(file, suffix, append);
    }

    public PeriodicSizeRotatingFileHandler(File file, String suffix, long rotateSize, int maxBackupIndex) throws FileNotFoundException {
        super(file, suffix);
        this.rotateSize = rotateSize;
        this.maxBackupIndex = maxBackupIndex;
    }

    public PeriodicSizeRotatingFileHandler(File file, String suffix, long rotateSize, int maxBackupIndex, boolean append) throws FileNotFoundException {
        super(file, suffix, append);
        this.rotateSize = rotateSize;
        this.maxBackupIndex = maxBackupIndex;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.lock.lock();
        try {
            this.outputStream = outputStream == null ? null : new CountingOutputStream(outputStream);
            super.setOutputStream(this.outputStream);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFile(File file) throws FileNotFoundException {
        PeriodicSizeRotatingFileHandler.checkAccess();
        this.lock.lock();
        try {
            if (this.rotateOnBoot && this.maxBackupIndex > 0 && file != null && file.exists() && file.length() > 0L) {
                String suffix = this.getNextSuffix();
                SuffixRotator suffixRotator = this.getSuffixRotator();
                if (suffixRotator != SuffixRotator.EMPTY && suffix != null) {
                    this.setFileInternal(null, false);
                    suffixRotator.rotate(this.getErrorManager(), file.toPath(), suffix, this.maxBackupIndex);
                }
            }
            this.setFileInternal(file, false);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isRotateOnBoot() {
        this.lock.lock();
        try {
            boolean bl = this.rotateOnBoot;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setRotateOnBoot(boolean rotateOnBoot) {
        PeriodicSizeRotatingFileHandler.checkAccess();
        this.lock.lock();
        try {
            this.rotateOnBoot = rotateOnBoot;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setRotateSize(long rotateSize) {
        PeriodicSizeRotatingFileHandler.checkAccess();
        this.lock.lock();
        try {
            this.rotateSize = rotateSize;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setMaxBackupIndex(int maxBackupIndex) {
        PeriodicSizeRotatingFileHandler.checkAccess();
        this.lock.lock();
        try {
            this.maxBackupIndex = maxBackupIndex;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected void preWrite(ExtLogRecord record) {
        long currentSize;
        super.preWrite(record);
        int maxBackupIndex = this.maxBackupIndex;
        long l = currentSize = this.outputStream == null ? Long.MIN_VALUE : this.outputStream.currentSize;
        if (currentSize > this.rotateSize && maxBackupIndex > 0) {
            try {
                File file = this.getFile();
                if (file == null) {
                    return;
                }
                this.setFileInternal(null, true);
                this.getSuffixRotator().rotate(SecurityActions.getErrorManager(this.acc, this), file.toPath(), this.getNextSuffix(), maxBackupIndex);
                this.setFileInternal(file, true);
            }
            catch (IOException e) {
                this.reportError("Unable to rotate log file", e, 4);
            }
        }
    }

    private void setFileInternal(File file, boolean doPrivileged) throws FileNotFoundException {
        if (System.getSecurityManager() == null || !doPrivileged) {
            super.setFile(file);
            if (this.outputStream != null) {
                this.outputStream.currentSize = file == null ? 0L : file.length();
            }
        } else {
            AccessController.doPrivileged(() -> {
                try {
                    super.setFile(file);
                    if (this.outputStream != null) {
                        this.outputStream.currentSize = file == null ? 0L : file.length();
                    }
                }
                catch (FileNotFoundException e) {
                    throw new UncheckedIOException(e);
                }
                return null;
            }, this.acc);
        }
    }
}

