/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.lang;

import com.apicatalog.jsonld.json.JsonProvider;
import com.apicatalog.jsonld.json.JsonUtils;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.Arrays;
import java.util.HashSet;

public final class GraphObject {
    private GraphObject() {
    }

    public static final boolean isGraphObject(JsonValue value) {
        if (!JsonUtils.isObject(value) || !value.asJsonObject().containsKey((Object)"@graph")) {
            return false;
        }
        HashSet<String> allowed = new HashSet<String>(Arrays.asList("@graph", "@id", "@index", "@context"));
        return allowed.containsAll(value.asJsonObject().keySet());
    }

    public static final boolean isSimpleGraphObject(JsonValue value) {
        return GraphObject.isGraphObject(value) && !value.asJsonObject().containsKey((Object)"@id");
    }

    public static final JsonObject toGraphObject(JsonValue value) {
        return JsonProvider.instance().createObjectBuilder().add("@graph", (JsonValue)JsonUtils.toJsonArray(value)).build();
    }
}

