/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.util.Util;
import org.infinispan.util.ExponentialBackOff;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ExponentialBackOffImpl
implements ExponentialBackOff {
    private static final Log log = LogFactory.getLog(ExponentialBackOffImpl.class);
    private static final double MULTIPLIER = 2.0;
    private static final int INITIAL_INTERVAL_MILLIS = 500;
    private static final int MAX_INTERVAL_MILLIS = 300000;
    private static final double RANDOMIZATION_FACTOR = 0.5;
    private int currentIntervalMillis;
    private final ScheduledExecutorService delayer;

    public ExponentialBackOffImpl(ScheduledExecutorService delayer) {
        this.delayer = delayer;
        this.currentIntervalMillis = 500;
    }

    long nextBackOffMillis() {
        if (this.currentIntervalMillis >= 300000) {
            if (log.isTraceEnabled()) {
                log.tracef("Next backoff time %s ms", 300000);
            }
            return 300000L;
        }
        int randomIntervalMillis = this.getRandomValueFromInterval();
        this.incrementCurrentInterval();
        if (log.isTraceEnabled()) {
            log.tracef("Next backoff time %s ms", randomIntervalMillis);
        }
        return Math.min(randomIntervalMillis, 300000);
    }

    @Override
    public void reset() {
        this.currentIntervalMillis = 500;
    }

    @Override
    public CompletionStage<Void> asyncBackOff() {
        CompletableFuture<Void> cf = new CompletableFuture<Void>();
        long sleepTime = this.nextBackOffMillis();
        if (log.isTraceEnabled()) {
            log.tracef("async backing-off for %s.", Util.prettyPrintTime((long)sleepTime));
        }
        this.delayer.schedule(() -> cf.complete(null), sleepTime, TimeUnit.MILLISECONDS);
        return cf;
    }

    private void incrementCurrentInterval() {
        this.currentIntervalMillis = this.currentIntervalMillis >= 300000 ? 300000 : (int)((double)this.currentIntervalMillis * 2.0);
    }

    private int getRandomValueFromInterval() {
        double delta = 0.5 * (double)this.currentIntervalMillis;
        return (int)(delta + ThreadLocalRandom.current().nextDouble() * (double)this.currentIntervalMillis);
    }
}

