/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.api.client;

import jakarta.validation.Valid;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.keycloak.admin.api.client.ClientApi;
import org.keycloak.admin.api.client.ClientsApi;
import org.keycloak.admin.api.client.DefaultClientApi;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.admin.v2.ClientRepresentation;
import org.keycloak.representations.admin.v2.validation.CreateClientDefault;
import org.keycloak.services.ServiceException;
import org.keycloak.services.client.ClientService;
import org.keycloak.services.client.DefaultClientService;
import org.keycloak.services.resources.admin.ClientsResource;
import org.keycloak.services.resources.admin.RealmAdminResource;
import org.keycloak.validation.jakarta.HibernateValidatorProvider;
import org.keycloak.validation.jakarta.JakartaValidatorProvider;

public class DefaultClientsApi
implements ClientsApi {
    private final KeycloakSession session;
    private final RealmModel realm;
    private final ClientService clientService;
    private final JakartaValidatorProvider validator;
    private final RealmAdminResource realmAdminResource;
    private final ClientsResource clientsResource;

    public DefaultClientsApi(KeycloakSession session, RealmAdminResource realmAdminResource) {
        this.session = session;
        this.realmAdminResource = realmAdminResource;
        this.realm = Objects.requireNonNull(session.getContext().getRealm());
        this.clientService = new DefaultClientService(session, realmAdminResource);
        this.validator = new HibernateValidatorProvider();
        this.clientsResource = realmAdminResource.getClients();
    }

    @Override
    public Stream<ClientRepresentation> getClients() {
        return this.clientService.getClients(this.realm, null, null, null);
    }

    @Override
    public Response createClient(@Valid ClientRepresentation client) {
        try {
            DefaultClientApi.validateUnknownFields(client);
            this.validator.validate((Object)client, new Class[]{CreateClientDefault.class});
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)this.clientService.createOrUpdate(this.realm, client, false).representation()).build();
        }
        catch (ServiceException e) {
            throw new WebApplicationException(e.getMessage(), e.getSuggestedResponseStatus().orElse(Response.Status.BAD_REQUEST));
        }
    }

    @Override
    public ClientApi client(@PathParam(value="id") String clientId) {
        Optional<ClientModel> client = Optional.ofNullable(this.session.clients().getClientByClientId(this.realm, clientId));
        return new DefaultClientApi(this.session, this.realmAdminResource, client.map(c -> this.clientsResource.getClient(c.getId())).orElse(null), clientId);
    }
}

