/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

public class SIZE
extends Protocol {
    protected final List<Address> members = new ArrayList<Address>();
    @Property
    protected boolean print_msg = false;
    @Property
    protected boolean raw_buffer = false;
    @Property(type=AttributeType.BYTES)
    protected long min_size;

    @Override
    public Object up(Message msg) {
        if (this.log.isTraceEnabled()) {
            int size;
            int n = size = this.raw_buffer ? msg.getLength() : msg.size();
            if ((long)size >= this.min_size) {
                StringBuilder sb = new StringBuilder(this.local_addr + ".up(): size of message buffer=");
                sb.append(Util.printBytes(size)).append(", " + SIZE.numHeaders(msg) + " headers");
                if (this.print_msg) {
                    sb.append(", headers=" + msg.printHeaders());
                }
                this.log.trace(sb);
            }
        }
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        if (this.log.isTraceEnabled()) {
            long size;
            long l = size = this.raw_buffer ? (long)batch.length() : batch.totalSize();
            if (size >= this.min_size) {
                StringBuilder sb = new StringBuilder(this.local_addr + ".up(): size of message batch=");
                sb.append(Util.printBytes(size)).append(", " + batch.size() + " messages, " + SIZE.numHeaders(batch) + " headers");
                this.log.trace(sb);
            }
        }
        this.up_prot.up(batch);
    }

    @Override
    public Object down(Message msg) {
        if (this.log.isTraceEnabled()) {
            int size;
            int n = size = this.raw_buffer ? msg.getLength() : msg.size();
            if ((long)size >= this.min_size) {
                StringBuilder sb = new StringBuilder(this.local_addr + ".down(): size of message buffer=");
                sb.append(Util.printBytes(size)).append(", " + SIZE.numHeaders(msg) + " headers");
                if (this.print_msg) {
                    sb.append(", headers=" + msg.printHeaders());
                }
                this.log.trace(sb);
            }
        }
        return this.down_prot.down(msg);
    }

    protected static int numHeaders(Message msg) {
        return msg == null ? 0 : msg.getNumHeaders();
    }

    protected static int numHeaders(MessageBatch batch) {
        int retval = 0;
        for (Message msg : batch) {
            retval += SIZE.numHeaders(msg);
        }
        return retval;
    }
}

