/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.common.Profile;
import org.keycloak.config.Option;
import org.keycloak.config.TelemetryOptions;
import org.keycloak.config.TracingOptions;
import org.keycloak.config.WildcardOptionsUtil;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.CachingPropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapperGrouping;
import org.keycloak.quarkus.runtime.configuration.mappers.TelemetryPropertyMappers;
import org.keycloak.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingPropertyMappers
implements PropertyMapperGrouping {
    private static final String OTEL_FEATURE_ENABLED_MSG = "'opentelemetry' feature is enabled";
    private static final String TRACING_ENABLED_MSG = "Tracing is enabled";
    private static final Logger log = LoggerFactory.getLogger(TracingPropertyMappers.class);

    public List<PropertyMapper<?>> getPropertyMappers() {
        return List.of(PropertyMapper.fromOption(TracingOptions.TRACING_ENABLED).isEnabled(TracingPropertyMappers::isFeatureEnabled, OTEL_FEATURE_ENABLED_MSG).to("quarkus.otel.traces.enabled").build(), PropertyMapper.fromOption(TracingOptions.TRACING_ENDPOINT).isEnabled(TracingPropertyMappers::isTracingEnabled, TRACING_ENABLED_MSG).mapFrom(TelemetryOptions.TELEMETRY_ENDPOINT).to("quarkus.otel.exporter.otlp.traces.endpoint").paramLabel("url").validator(TelemetryPropertyMappers::validateEndpoint).build(), PropertyMapper.fromOption(TracingOptions.TRACING_SERVICE_NAME).isEnabled(TracingPropertyMappers::isTracingEnabled, TRACING_ENABLED_MSG).paramLabel("name").build(), PropertyMapper.fromOption(TracingOptions.TRACING_RESOURCE_ATTRIBUTES).isEnabled(TracingPropertyMappers::isTracingEnabled, TRACING_ENABLED_MSG).paramLabel("attributes").build(), PropertyMapper.fromOption(TracingOptions.TRACING_PROTOCOL).isEnabled(TracingPropertyMappers::isTracingEnabled, TRACING_ENABLED_MSG).mapFrom(TelemetryOptions.TELEMETRY_PROTOCOL).to("quarkus.otel.exporter.otlp.traces.protocol").paramLabel("protocol").build(), PropertyMapper.fromOption(TracingOptions.TRACING_SAMPLER_TYPE).isEnabled(TracingPropertyMappers::isTracingEnabled, TRACING_ENABLED_MSG).to("quarkus.otel.traces.sampler").paramLabel("type").build(), PropertyMapper.fromOption(TracingOptions.TRACING_SAMPLER_RATIO).isEnabled(TracingPropertyMappers::isTracingEnabled, TRACING_ENABLED_MSG).to("quarkus.otel.traces.sampler.arg").validator(TracingPropertyMappers::validateRatio).paramLabel("ratio").build(), PropertyMapper.fromOption(TracingOptions.TRACING_COMPRESSION).isEnabled(TracingPropertyMappers::isTracingEnabled, TRACING_ENABLED_MSG).to("quarkus.otel.exporter.otlp.traces.compression").paramLabel("method").build(), PropertyMapper.fromOption(TracingOptions.TRACING_JDBC_ENABLED).mapFrom(TracingOptions.TRACING_ENABLED).isEnabled(TracingPropertyMappers::isTracingEnabled, TRACING_ENABLED_MSG).to("quarkus.datasource.jdbc.telemetry").build(), PropertyMapper.fromOption(TracingOptions.TRACING_INFINISPAN_ENABLED).mapFrom(TracingOptions.TRACING_ENABLED).to("kc.spi-cache-embedded--default--tracing-enabled").isEnabled(TracingPropertyMappers::isTracingAndEmbeddedInfinispanEnabled, "tracing and embedded Infinispan is enabled").build(), PropertyMapper.fromOption(TracingOptions.TRACING_HEADERS).isEnabled(TracingPropertyMappers::isTracingEnabled, TRACING_ENABLED_MSG).to("quarkus.otel.exporter.otlp.traces.headers").transformer(TracingPropertyMappers::transformTracingHeaders).isMasked(true).build(), PropertyMapper.fromOption(TracingOptions.TRACING_HEADER).isEnabled(TracingPropertyMappers::isTracingEnabled, TRACING_ENABLED_MSG).paramLabel("<value>").isMasked(true).build());
    }

    private static void validateRatio(String value) {
        if (StringUtil.isBlank((String)value)) {
            throw new PropertyException("Ratio in 'tracing-sampler-ratio' option must not be empty.");
        }
        try {
            double ratio = Double.parseDouble(value);
            if (ratio < 0.0 || ratio > 1.0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            throw new PropertyException("Ratio in 'tracing-sampler-ratio' option must be a double value in interval [0,1].");
        }
    }

    private static String transformTracingHeaders(String value, ConfigSourceInterceptorContext ctx) {
        if (StringUtil.isNotBlank((String)value)) {
            log.debug("HTTP headers for the tracing exporter are overridden by the '%s' parent property".formatted(TracingOptions.TRACING_HEADERS.getKey()));
            return value;
        }
        HashMap headers = new HashMap();
        String prefix = WildcardOptionsUtil.getWildcardPrefix((String)TracingOptions.TRACING_HEADER.getKey());
        Configuration.getPropertyNames().forEach(key -> {
            if (key.startsWith("kc.") && key.startsWith("kc." + prefix)) {
                String header = WildcardOptionsUtil.getWildcardValue((Option)TracingOptions.TRACING_HEADER, (String)key);
                String headerValue = Configuration.getOptionalValue(key).orElseThrow(() -> new PropertyException("Wrong value for the property '%s'".formatted(key)));
                headers.put(header, headerValue);
            }
        });
        return headers.entrySet().stream().map(header -> (String)header.getKey() + "=" + (String)header.getValue()).collect(Collectors.joining(","));
    }

    private static boolean isFeatureEnabled() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.OPENTELEMETRY);
    }

    public static boolean isTracingEnabled() {
        return Configuration.isTrue((Option<Boolean>)TracingOptions.TRACING_ENABLED);
    }

    public static boolean isTracingAndEmbeddedInfinispanEnabled() {
        return Configuration.isTrue((Option<Boolean>)TracingOptions.TRACING_ENABLED) && CachingPropertyMappers.cacheSetToInfinispan();
    }
}

