/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.idp;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;
import org.keycloak.models.cache.infinispan.entities.InRealm;

public class IdentityProviderListQuery
extends AbstractRevisioned
implements InRealm {
    private final String realmId;
    private final Map<String, Set<String>> searchKeys;

    public IdentityProviderListQuery(Long revision, String id, RealmModel realm, String searchKey, Set<String> result) {
        super(revision, id);
        this.realmId = realm.getId();
        this.searchKeys = new HashMap<String, Set<String>>();
        this.searchKeys.put(searchKey, result);
    }

    public IdentityProviderListQuery(Long revision, String id, RealmModel realm, String searchKey, Set<String> result, IdentityProviderListQuery previous) {
        super(revision, id);
        this.realmId = realm.getId();
        this.searchKeys = new HashMap<String, Set<String>>();
        this.searchKeys.putAll(previous.searchKeys);
        this.searchKeys.put(searchKey, result);
    }

    @Override
    public String getRealm() {
        return this.realmId;
    }

    public Set<String> getIDPs(String searchKey) {
        return this.searchKeys.get(searchKey);
    }
}

