/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.NetworkMetrics;
import java.util.Map;
import java.util.Objects;

public class VertxNetworkMetrics
implements NetworkMetrics<Map<String, Object>> {
    final MeterRegistry registry;
    final DistributionSummary nameBytesRead;
    final DistributionSummary nameBytesWritten;
    final Tags tags;
    private final Meter.MeterProvider<Counter> exceptions;

    VertxNetworkMetrics(MeterRegistry registry, String prefix, Tags tags) {
        this.registry = registry;
        this.tags = tags;
        DistributionSummary.Builder nameBytesReadBuilder = DistributionSummary.builder((String)(prefix + ".bytes.read"));
        DistributionSummary.Builder nameBytesWrittenBuilder = DistributionSummary.builder((String)(prefix + ".bytes.written"));
        if (tags != null) {
            nameBytesReadBuilder.tags((Iterable)this.tags);
            nameBytesWrittenBuilder.tags((Iterable)this.tags);
        }
        this.nameBytesRead = nameBytesReadBuilder.register(registry);
        this.nameBytesWritten = nameBytesWrittenBuilder.register(registry);
        this.exceptions = Counter.builder((String)(prefix + ".errors")).description("Number of exceptions").withRegistry(registry);
    }

    public void bytesRead(Map<String, Object> socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        this.nameBytesRead.record((double)numberOfBytes);
    }

    public void bytesWritten(Map<String, Object> socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        this.nameBytesWritten.record((double)numberOfBytes);
    }

    public void exceptionOccurred(Map<String, Object> socketMetric, SocketAddress remoteAddress, Throwable t) {
        ((Counter)this.exceptions.withTags((Iterable)Objects.requireNonNullElseGet(this.tags, Tags::empty).and(new Tag[]{Tag.of((String)"class", (String)t.getClass().getName())}))).increment();
    }

    public void close() {
        this.nameBytesRead.close();
        this.nameBytesWritten.close();
    }
}

