/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmProtectedInSuperClassCompanionCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;)V", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmProtectedInSuperClassCompanionCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmProtectedInSuperClassCompanionCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmProtectedInSuperClassCompanionCallChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt\n*L\n1#1,91:1\n36#2:92\n22#2:93\n22#2:94\n22#2:95\n69#2:96\n98#3,5:97\n98#3,5:102\n*S KotlinDebug\n*F\n+ 1 FirJvmProtectedInSuperClassCompanionCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmProtectedInSuperClassCompanionCallChecker\n*L\n53#1:92\n61#1:93\n63#1:94\n65#1:95\n69#1:96\n75#1:97,5\n83#1:102,5\n*E\n"})
public final class FirJvmProtectedInSuperClassCompanionCallChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirJvmProtectedInSuperClassCompanionCallChecker INSTANCE = new FirJvmProtectedInSuperClassCompanionCallChecker();

    private FirJvmProtectedInSuperClassCompanionCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirStatement expression2) {
        FirBasedSymbol firBasedSymbol;
        FirReference calleeReference;
        block23: {
            FirClassSymbol it;
            FirBasedSymbol firBasedSymbol2;
            FirBasedSymbol firBasedSymbol3;
            boolean $i$f$findClosest;
            CheckerContext $this$findClosest$iv;
            FirRegularClassSymbol companionContainingClassSymbol;
            FirRegularClassSymbol dispatchClassSymbol;
            block22: {
                Object visibility;
                FirClassLikeSymbol<FirClassLikeDeclaration> $this$visibility$iv;
                Object object;
                Object resolvedSymbol;
                block27: {
                    block24: {
                        boolean $i$f$getVisibility;
                        block28: {
                            block25: {
                                block26: {
                                    Intrinsics.checkNotNullParameter(context2, "context");
                                    Intrinsics.checkNotNullParameter(reporter, "reporter");
                                    Intrinsics.checkNotNullParameter(expression2, "expression");
                                    FirStatement firStatement = expression2;
                                    FirExpression firExpression = firStatement instanceof FirQualifiedAccessExpression ? ((FirQualifiedAccessExpression)expression2).getDispatchReceiver() : (firStatement instanceof FirVariableAssignment ? FirExpressionUtilKt.getDispatchReceiver((FirVariableAssignment)expression2) : null);
                                    if (firExpression == null) {
                                        return;
                                    }
                                    FirExpression dispatchReceiver = firExpression;
                                    FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol((SessionHolder)context2, FirTypeUtilsKt.getResolvedType(dispatchReceiver));
                                    if (firRegularClassSymbol == null) {
                                        return;
                                    }
                                    dispatchClassSymbol = firRegularClassSymbol;
                                    calleeReference = ReferenceUtilsKt.toReference(expression2, context2.getSession());
                                    Object object2 = calleeReference;
                                    if (object2 == null || (object2 = FirReferenceUtilsKt.toResolvedCallableSymbol$default((FirReference)object2, false, 1, null)) == null) {
                                        return;
                                    }
                                    resolvedSymbol = object2;
                                    if (resolvedSymbol instanceof FirPropertySymbol && LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.AllowAccessToProtectedFieldFromSuperCompanion)) {
                                        Object $this$isConst$iv = resolvedSymbol;
                                        boolean $i$f$isConst = false;
                                        if (((FirCallableSymbol)$this$isConst$iv).getRawStatus().isConst()) {
                                            return;
                                        }
                                        FirBackingFieldSymbol backingField = ((FirPropertySymbol)resolvedSymbol).getBackingFieldSymbol();
                                        if (backingField != null && FirAnnotationUtilsKt.hasAnnotation(backingField, JvmAbi.JVM_FIELD_ANNOTATION_CLASS_ID, context2.getSession())) {
                                            return;
                                        }
                                    }
                                    if (!(resolvedSymbol instanceof FirPropertySymbol)) break block24;
                                    if (!(expression2 instanceof FirVariableAssignment)) break block25;
                                    object = ((FirPropertySymbol)resolvedSymbol).getSetterSymbol();
                                    if (object == null) break block26;
                                    $this$visibility$iv = (FirCallableSymbol)object;
                                    $i$f$getVisibility = false;
                                    object = ((FirCallableSymbol)((Object)$this$visibility$iv)).getResolvedStatus().getVisibility();
                                    if (object != null) break block27;
                                }
                                $this$visibility$iv = resolvedSymbol;
                                $i$f$getVisibility = false;
                                object = ((FirCallableSymbol)((Object)$this$visibility$iv)).getResolvedStatus().getVisibility();
                                break block27;
                            }
                            object = ((FirPropertySymbol)resolvedSymbol).getGetterSymbol();
                            if (object == null) break block28;
                            $this$visibility$iv = (FirCallableSymbol)object;
                            $i$f$getVisibility = false;
                            object = ((FirCallableSymbol)((Object)$this$visibility$iv)).getResolvedStatus().getVisibility();
                            if (object != null) break block27;
                        }
                        $this$visibility$iv = resolvedSymbol;
                        $i$f$getVisibility = false;
                        object = ((FirCallableSymbol)((Object)$this$visibility$iv)).getResolvedStatus().getVisibility();
                        break block27;
                    }
                    Object $this$visibility$iv2 = resolvedSymbol;
                    boolean $i$f$getVisibility = false;
                    object = ((FirCallableSymbol)$this$visibility$iv2).getResolvedStatus().getVisibility();
                }
                if (!Intrinsics.areEqual(visibility = object, Visibilities.Protected.INSTANCE)) {
                    return;
                }
                if (FirAnnotationUtilsKt.hasAnnotation((FirBasedSymbol)resolvedSymbol, StandardClassIds.Annotations.INSTANCE.getJvmStatic(), context2.getSession())) {
                    return;
                }
                FirClassLikeSymbol $this$isCompanion$iv = dispatchClassSymbol;
                boolean $i$f$isCompanion = false;
                if (!$this$isCompanion$iv.getRawStatus().isCompanion()) {
                    return;
                }
                $this$visibility$iv = DeclarationUtilsKt.getContainingDeclaration(dispatchClassSymbol, context2.getSession());
                FirRegularClassSymbol firRegularClassSymbol = $this$visibility$iv instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)$this$visibility$iv : null;
                if (firRegularClassSymbol == null) {
                    return;
                }
                companionContainingClassSymbol = firRegularClassSymbol;
                ConeClassLikeType companionContainingType = ScopeUtilsKt.defaultType(companionContainingClassSymbol);
                $this$findClosest$iv = context2;
                $i$f$findClosest = false;
                for (FirBasedSymbol<?> it$iv : CollectionsKt.asReversed($this$findClosest$iv.getContainingDeclarations())) {
                    FirBasedSymbol<?> firBasedSymbol4 = it$iv;
                    if (!(firBasedSymbol4 instanceof FirClassSymbol)) {
                        firBasedSymbol4 = null;
                    }
                    if ((firBasedSymbol3 = (FirBasedSymbol)((FirClassSymbol)firBasedSymbol4)) == null) continue;
                    firBasedSymbol2 = firBasedSymbol3;
                    it = (FirClassSymbol)firBasedSymbol2;
                    boolean bl = false;
                    firBasedSymbol3 = AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, TypeComponentsKt.getTypeContext(context2.getSession()), (KotlinTypeMarker)ScopeUtilsKt.defaultType(it), (KotlinTypeMarker)companionContainingType, false, 8, null) ? firBasedSymbol2 : null;
                    if (firBasedSymbol3 == null) {
                        continue;
                    }
                    break block22;
                }
                firBasedSymbol3 = null;
            }
            if (firBasedSymbol3 == null) {
                return;
            }
            $this$findClosest$iv = context2;
            $i$f$findClosest = false;
            for (FirBasedSymbol<?> it$iv : CollectionsKt.asReversed($this$findClosest$iv.getContainingDeclarations())) {
                FirBasedSymbol<?> firBasedSymbol5 = it$iv;
                if (!(firBasedSymbol5 instanceof FirClassSymbol)) {
                    firBasedSymbol5 = null;
                }
                if ((firBasedSymbol = (FirBasedSymbol)((FirClassSymbol)firBasedSymbol5)) == null) continue;
                firBasedSymbol2 = firBasedSymbol;
                it = (FirClassSymbol)firBasedSymbol2;
                boolean bl = false;
                firBasedSymbol = Intrinsics.areEqual(it, dispatchClassSymbol) || Intrinsics.areEqual(it, companionContainingClassSymbol) ? firBasedSymbol2 : null;
                if (firBasedSymbol == null) {
                    continue;
                }
                break block23;
            }
            firBasedSymbol = null;
        }
        if (firBasedSymbol == null) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)calleeReference.getSource(), FirJvmErrors.INSTANCE.getSUBCLASS_CANT_CALL_COMPANION_PROTECTED_NON_STATIC(), null, 8, null);
        }
    }
}

