/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.models.stream;

import io.lettuce.core.Range;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.models.stream.PendingMessage;
import io.lettuce.core.models.stream.PendingMessages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public class PendingParser {
    private PendingParser() {
    }

    public static List<PendingMessage> parseRange(List<?> xpendingOutput) {
        LettuceAssert.notNull(xpendingOutput, "XPENDING output must not be null");
        ArrayList<PendingMessage> result = new ArrayList<PendingMessage>();
        for (Object element : xpendingOutput) {
            LettuceAssert.isTrue(element instanceof List, "Output elements must be a List");
            List message = (List)element;
            String messageId = (String)message.get(0);
            String consumer = (String)message.get(1);
            Long msSinceLastDelivery = (Long)message.get(2);
            Long deliveryCount = (Long)message.get(3);
            result.add(new PendingMessage(messageId, consumer, msSinceLastDelivery, deliveryCount));
        }
        return result;
    }

    public static PendingMessages parse(List<?> xpendingOutput) {
        LettuceAssert.notNull(xpendingOutput, "XPENDING output must not be null");
        LettuceAssert.isTrue(xpendingOutput.size() == 4, "XPENDING output must have exactly four output elements");
        Long count = (Long)xpendingOutput.get(0);
        String from = (String)xpendingOutput.get(1);
        String to = (String)xpendingOutput.get(2);
        Range<String> messageIdRange = Range.create(from, to);
        Collection consumerMessageCounts = (Collection)xpendingOutput.get(3);
        LinkedHashMap<String, Long> counts = new LinkedHashMap<String, Long>();
        for (Object element : consumerMessageCounts) {
            LettuceAssert.isTrue(element instanceof List, "Consumer message counts must be a List");
            List messageCount = (List)element;
            counts.put((String)messageCount.get(0), (Long)messageCount.get(1));
        }
        return new PendingMessages(count, messageIdRange, Collections.unmodifiableMap(counts));
    }
}

