/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.lang.ref.Cleaner;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class ContentEncryptionParams extends Base {

	public ContentEncryptionParams(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Returns the encryption method to be used in this encryption process
	 *
	 * @return 
	 * @throws Lib3MFException
	 */
	public Lib3MFWrapper.EncryptionAlgorithm getEncryptionAlgorithm() throws Lib3MFException {
		Pointer bufferAlgorithm = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_contentencryptionparams_getencryptionalgorithm.invokeInt(new java.lang.Object[]{mHandle, bufferAlgorithm}));
		return Lib3MFWrapper.EnumConversion.convertConstToEncryptionAlgorithm(bufferAlgorithm.getInt(0));
	}

	/**
	 * Gets the key for the resource associated
	 *
	 * @return Pointer to a buffer where to place the key.
	 * @throws Lib3MFException
	 */
	public byte[] getKey() throws Lib3MFException {
		Pointer countNeededByteData = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_contentencryptionparams_getkey.invokeInt(new java.lang.Object[]{mHandle, 0L, countNeededByteData, Pointer.NULL}));
		long countByteData = countNeededByteData.getLong(0);
		Pointer bufferByteData = new Memory(Math.max(1, 1 * countByteData));
		mWrapper.checkError(this, mWrapper.lib3mf_contentencryptionparams_getkey.invokeInt(new java.lang.Object[]{mHandle, countByteData, countNeededByteData, bufferByteData}));
		return bufferByteData.getByteArray(0, (int)countByteData);
	}

	/**
	 * Gets the IV data
	 *
	 * @return Pointer to a buffer where to place the data.
	 * @throws Lib3MFException
	 */
	public byte[] getInitializationVector() throws Lib3MFException {
		Pointer countNeededByteData = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_contentencryptionparams_getinitializationvector.invokeInt(new java.lang.Object[]{mHandle, 0L, countNeededByteData, Pointer.NULL}));
		long countByteData = countNeededByteData.getLong(0);
		Pointer bufferByteData = new Memory(Math.max(1, 1 * countByteData));
		mWrapper.checkError(this, mWrapper.lib3mf_contentencryptionparams_getinitializationvector.invokeInt(new java.lang.Object[]{mHandle, countByteData, countNeededByteData, bufferByteData}));
		return bufferByteData.getByteArray(0, (int)countByteData);
	}

	/**
	 * A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
	 *
	 * @return Pointer to a buffer where to place the data.
	 * @throws Lib3MFException
	 */
	public byte[] getAuthenticationTag() throws Lib3MFException {
		Pointer countNeededByteData = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_contentencryptionparams_getauthenticationtag.invokeInt(new java.lang.Object[]{mHandle, 0L, countNeededByteData, Pointer.NULL}));
		long countByteData = countNeededByteData.getLong(0);
		Pointer bufferByteData = new Memory(Math.max(1, 1 * countByteData));
		mWrapper.checkError(this, mWrapper.lib3mf_contentencryptionparams_getauthenticationtag.invokeInt(new java.lang.Object[]{mHandle, countByteData, countNeededByteData, bufferByteData}));
		return bufferByteData.getByteArray(0, (int)countByteData);
	}

	/**
	 * Sets the authentication tag
	 *
	 * @param byteData The authentication tag size
	 * @throws Lib3MFException
	 */
	public void setAuthenticationTag(byte[] byteData) throws Lib3MFException {
		Pointer bufferByteData = new Memory(Math.max(1, 1 * byteData.length));
		for (int i = 0; i < byteData.length; i++) {
		  bufferByteData.setByte(1 * i, byteData[i]);
		}
		mWrapper.checkError(this, mWrapper.lib3mf_contentencryptionparams_setauthenticationtag.invokeInt(new java.lang.Object[]{mHandle, (long) byteData.length, bufferByteData}));
	}

	/**
	 * A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
	 *
	 * @return Buffer where the data will be placed
	 * @throws Lib3MFException
	 */
	public byte[] getAdditionalAuthenticationData() throws Lib3MFException {
		Pointer countNeededByteData = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_contentencryptionparams_getadditionalauthenticationdata.invokeInt(new java.lang.Object[]{mHandle, 0L, countNeededByteData, Pointer.NULL}));
		long countByteData = countNeededByteData.getLong(0);
		Pointer bufferByteData = new Memory(Math.max(1, 1 * countByteData));
		mWrapper.checkError(this, mWrapper.lib3mf_contentencryptionparams_getadditionalauthenticationdata.invokeInt(new java.lang.Object[]{mHandle, countByteData, countNeededByteData, bufferByteData}));
		return bufferByteData.getByteArray(0, (int)countByteData);
	}

	/**
	 * A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
	 *
	 * @return 
	 * @throws Lib3MFException
	 */
	public long getDescriptor() throws Lib3MFException {
		Pointer bufferDescriptor = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_contentencryptionparams_getdescriptor.invokeInt(new java.lang.Object[]{mHandle, bufferDescriptor}));
		return bufferDescriptor.getLong(0);
	}

	/**
	 * Gets the resourcedatagroup keyuuid
	 *
	 * @return The resourcedatagroup keyuuid that may be use to reference an external key
	 * @throws Lib3MFException
	 */
	public String getKeyUUID() throws Lib3MFException {
		Pointer bytesNeededUUID = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_contentencryptionparams_getkeyuuid.invokeInt(new java.lang.Object[]{mHandle, 0, bytesNeededUUID, null}));
		int sizeUUID = bytesNeededUUID.getInt(0);
		Pointer bufferUUID = new Memory(sizeUUID);
		mWrapper.checkError(this, mWrapper.lib3mf_contentencryptionparams_getkeyuuid.invokeInt(new java.lang.Object[]{mHandle, sizeUUID, bytesNeededUUID, bufferUUID}));
		return new String(bufferUUID.getByteArray(0, sizeUUID - 1), StandardCharsets.UTF_8);
	}


}

