<?php

namespace OCA\News\Vendor\Http\Discovery\Strategy;

use OCA\News\Vendor\Psr\Http\Message\RequestFactoryInterface;
use OCA\News\Vendor\Psr\Http\Message\ResponseFactoryInterface;
use OCA\News\Vendor\Psr\Http\Message\ServerRequestFactoryInterface;
use OCA\News\Vendor\Psr\Http\Message\StreamFactoryInterface;
use OCA\News\Vendor\Psr\Http\Message\UploadedFileFactoryInterface;
use OCA\News\Vendor\Psr\Http\Message\UriFactoryInterface;
/**
 * @internal
 *
 * @author Tobias Nyholm <tobias.nyholm@gmail.com>
 *
 * Don't miss updating src/Composer/Plugin.php when adding a new supported class.
 */
final class CommonPsr17ClassesStrategy implements DiscoveryStrategy
{
    /**
     * @var array
     */
    private static $classes = [RequestFactoryInterface::class => ['OCA\News\Vendor\Phalcon\Http\Message\RequestFactory', 'OCA\News\Vendor\Nyholm\Psr7\Factory\Psr17Factory', 'OCA\News\Vendor\GuzzleHttp\Psr7\HttpFactory', 'OCA\News\Vendor\Http\Factory\Diactoros\RequestFactory', 'OCA\News\Vendor\Http\Factory\Guzzle\RequestFactory', 'OCA\News\Vendor\Http\Factory\Slim\RequestFactory', 'OCA\News\Vendor\Laminas\Diactoros\RequestFactory', 'OCA\News\Vendor\Slim\Psr7\Factory\RequestFactory', 'OCA\News\Vendor\HttpSoft\Message\RequestFactory'], ResponseFactoryInterface::class => ['OCA\News\Vendor\Phalcon\Http\Message\ResponseFactory', 'OCA\News\Vendor\Nyholm\Psr7\Factory\Psr17Factory', 'OCA\News\Vendor\GuzzleHttp\Psr7\HttpFactory', 'OCA\News\Vendor\Http\Factory\Diactoros\ResponseFactory', 'OCA\News\Vendor\Http\Factory\Guzzle\ResponseFactory', 'OCA\News\Vendor\Http\Factory\Slim\ResponseFactory', 'OCA\News\Vendor\Laminas\Diactoros\ResponseFactory', 'OCA\News\Vendor\Slim\Psr7\Factory\ResponseFactory', 'OCA\News\Vendor\HttpSoft\Message\ResponseFactory'], ServerRequestFactoryInterface::class => ['OCA\News\Vendor\Phalcon\Http\Message\ServerRequestFactory', 'OCA\News\Vendor\Nyholm\Psr7\Factory\Psr17Factory', 'OCA\News\Vendor\GuzzleHttp\Psr7\HttpFactory', 'OCA\News\Vendor\Http\Factory\Diactoros\ServerRequestFactory', 'OCA\News\Vendor\Http\Factory\Guzzle\ServerRequestFactory', 'OCA\News\Vendor\Http\Factory\Slim\ServerRequestFactory', 'OCA\News\Vendor\Laminas\Diactoros\ServerRequestFactory', 'OCA\News\Vendor\Slim\Psr7\Factory\ServerRequestFactory', 'OCA\News\Vendor\HttpSoft\Message\ServerRequestFactory'], StreamFactoryInterface::class => ['OCA\News\Vendor\Phalcon\Http\Message\StreamFactory', 'OCA\News\Vendor\Nyholm\Psr7\Factory\Psr17Factory', 'OCA\News\Vendor\GuzzleHttp\Psr7\HttpFactory', 'OCA\News\Vendor\Http\Factory\Diactoros\StreamFactory', 'OCA\News\Vendor\Http\Factory\Guzzle\StreamFactory', 'OCA\News\Vendor\Http\Factory\Slim\StreamFactory', 'OCA\News\Vendor\Laminas\Diactoros\StreamFactory', 'OCA\News\Vendor\Slim\Psr7\Factory\StreamFactory', 'OCA\News\Vendor\HttpSoft\Message\StreamFactory'], UploadedFileFactoryInterface::class => ['OCA\News\Vendor\Phalcon\Http\Message\UploadedFileFactory', 'OCA\News\Vendor\Nyholm\Psr7\Factory\Psr17Factory', 'OCA\News\Vendor\GuzzleHttp\Psr7\HttpFactory', 'OCA\News\Vendor\Http\Factory\Diactoros\UploadedFileFactory', 'OCA\News\Vendor\Http\Factory\Guzzle\UploadedFileFactory', 'OCA\News\Vendor\Http\Factory\Slim\UploadedFileFactory', 'OCA\News\Vendor\Laminas\Diactoros\UploadedFileFactory', 'OCA\News\Vendor\Slim\Psr7\Factory\UploadedFileFactory', 'OCA\News\Vendor\HttpSoft\Message\UploadedFileFactory'], UriFactoryInterface::class => ['OCA\News\Vendor\Phalcon\Http\Message\UriFactory', 'OCA\News\Vendor\Nyholm\Psr7\Factory\Psr17Factory', 'OCA\News\Vendor\GuzzleHttp\Psr7\HttpFactory', 'OCA\News\Vendor\Http\Factory\Diactoros\UriFactory', 'OCA\News\Vendor\Http\Factory\Guzzle\UriFactory', 'OCA\News\Vendor\Http\Factory\Slim\UriFactory', 'OCA\News\Vendor\Laminas\Diactoros\UriFactory', 'OCA\News\Vendor\Slim\Psr7\Factory\UriFactory', 'OCA\News\Vendor\HttpSoft\Message\UriFactory']];
    public static function getCandidates($type)
    {
        $candidates = [];
        if (isset(self::$classes[$type])) {
            foreach (self::$classes[$type] as $class) {
                $candidates[] = ['class' => $class, 'condition' => [$class]];
            }
        }
        return $candidates;
    }
}
