/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.returntypes;

import com.amazon.randomcutforest.CommonUtils;
import java.util.Arrays;
import java.util.function.Function;

public class DiVector {
    public final double[] high;
    public final double[] low;
    private final int dimensions;

    public DiVector(int dimensions) {
        CommonUtils.checkArgument(dimensions > 0, "dimensions must be greater than 0");
        this.dimensions = dimensions;
        this.high = new double[dimensions];
        this.low = new double[dimensions];
    }

    public DiVector(double[] high, double[] low) {
        CommonUtils.checkArgument(high.length == low.length, "dimensions must be equal");
        this.dimensions = high.length;
        this.high = Arrays.copyOf(high, high.length);
        this.low = Arrays.copyOf(low, low.length);
    }

    public DiVector(DiVector base) {
        this.dimensions = base.dimensions;
        this.high = Arrays.copyOf(base.high, this.dimensions);
        this.low = Arrays.copyOf(base.low, this.dimensions);
    }

    public static DiVector addToLeft(DiVector left, DiVector right) {
        CommonUtils.checkNotNull(left, "left must not be null");
        CommonUtils.checkNotNull(right, "right must not be null");
        CommonUtils.checkArgument(left.dimensions == right.dimensions, "dimensions must be the same");
        for (int i = 0; i < left.dimensions; ++i) {
            int n = i;
            left.high[n] = left.high[n] + right.high[i];
            int n2 = i;
            left.low[n2] = left.low[n2] + right.low[i];
        }
        return left;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public DiVector scale(double z) {
        DiVector result = new DiVector(this.dimensions);
        for (int i = 0; i < this.dimensions; ++i) {
            result.high[i] = this.high[i] * z;
            result.low[i] = this.low[i] * z;
        }
        return result;
    }

    public void renormalize(double targetNorm) {
        double norm = this.getHighLowSum();
        if (norm > 0.0) {
            double scaleFactor = targetNorm / norm;
            for (int i = 0; i < this.dimensions; ++i) {
                this.high[i] = this.high[i] * scaleFactor;
                this.low[i] = this.low[i] * scaleFactor;
            }
        }
    }

    public void componentwiseTransform(Function<Double, Double> function) {
        for (int i = 0; i < this.dimensions; ++i) {
            this.high[i] = function.apply(this.high[i]);
            this.low[i] = function.apply(this.low[i]);
        }
    }

    public double getHighLowSum(int i) {
        return this.high[i] + this.low[i];
    }

    public double getHighLowSum() {
        double score = 0.0;
        for (int i = 0; i < this.dimensions; ++i) {
            score += this.high[i] + this.low[i];
        }
        return score;
    }

    public DiVector lift(Function<double[], double[]> projection) {
        return new DiVector(projection.apply(this.high), projection.apply(this.low));
    }
}

