"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createGeospatialCluster;
var _geospatial_plugin = _interopRequireDefault(require("./geospatial_plugin"));
var _constants = require("../services/utils/constants");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function createGeospatialCluster(core, globalConfig) {
  const {
    customHeaders,
    ...rest
  } = globalConfig.opensearch;
  return core.opensearch.legacy.createClient(_constants.CLUSTER.GEOSPATIAL, {
    plugins: [_geospatial_plugin.default],
    // Currently we are overriding any headers with our own since we explicitly required User-Agent to be OpenSearch Dashboards
    // for integration with our backend plugin.
    customHeaders: {
      ...customHeaders,
      ..._constants.DEFAULT_HEADERS
    },
    ...rest
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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