"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPLDataSource = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class PPLDataSource {
  constructor(pplDataSource, dataType) {
    this.pplDataSource = pplDataSource;
    this.dataType = dataType;
    _defineProperty(this, "addStatsMapping", () => {
      var _visData$metadata;
      const visData = this.pplDataSource;

      /**
       * Add vis mapping for runtime fields
       * json data structure added to response will be
       * [{
       *  agent: "mozilla",
       *  avg(bytes): 5756
       *  ...
       * }, {
       *  agent: "MSIE",
       *  avg(bytes): 5605
       *  ...
       * }, {
       *  agent: "chrome",
       *  avg(bytes): 5648
       *  ...
       * }]
       */
      const res = [];
      if (visData !== null && visData !== void 0 && (_visData$metadata = visData.metadata) !== null && _visData$metadata !== void 0 && _visData$metadata.fields) {
        const queriedFields = visData.metadata.fields;
        for (let i = 0; i < visData.size; i++) {
          const entry = {};
          queriedFields.map(field => {
            const statsDataSet = visData === null || visData === void 0 ? void 0 : visData.data;
            entry[field.name] = statsDataSet[field.name][i];
          });
          res.push(entry);
        }
        visData.jsonData = res;
      }
    });
    /**
     * Add 'schemaName: data' entries for UI rendering
     */
    _defineProperty(this, "addSchemaRowMapping", () => {
      const pplRes = this.pplDataSource;
      const data = [];
      _lodash.default.forEach(pplRes.datarows, row => {
        const record = {};
        for (let i = 0; i < pplRes.schema.length; i++) {
          const cur = pplRes.schema[i];
          if (typeof row[i] === 'object') {
            record[cur.name] = JSON.stringify(row[i]);
          } else if (typeof row[i] === 'boolean') {
            record[cur.name] = row[i].toString();
          } else {
            record[cur.name] = row[i];
          }
        }
        data.push(record);
      });
      pplRes.jsonData = data;
    });
    _defineProperty(this, "getDataSource", () => this.pplDataSource);
    if (this.dataType === 'jdbc') {
      this.addSchemaRowMapping();
    } else if (this.dataType === 'viz') {
      this.addStatsMapping();
    }
  }
}
exports.PPLDataSource = PPLDataSource;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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