/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remote.metadata.client;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import org.opensearch.OpenSearchException;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.common.Nullable;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.remote.metadata.client.DataObjectResponse;
import org.opensearch.remote.metadata.common.SdkClientUtils;

public class PutDataObjectResponse
extends DataObjectResponse {
    private final IndexResponse indexResponse;

    public PutDataObjectResponse(IndexResponse indexResponse) {
        super(indexResponse.getIndex(), indexResponse.getId(), null, false, null, null);
        this.indexResponse = indexResponse;
    }

    public PutDataObjectResponse(BulkItemResponse itemResponse) {
        super(itemResponse.getIndex(), itemResponse.getId(), null, itemResponse.isFailed(), itemResponse.getFailure() != null ? itemResponse.getFailure().getCause() : null, itemResponse.getFailure() != null ? itemResponse.getFailure().getStatus() : null);
        DocWriteResponse response;
        DocWriteResponse docWriteResponse = response = itemResponse.getResponse();
        int n = 0;
        this.indexResponse = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IndexResponse.class}, (Object)docWriteResponse, n)) {
            case -1 -> null;
            case 0 -> {
                IndexResponse ir;
                yield ir = (IndexResponse)docWriteResponse;
            }
            default -> throw new OpenSearchException("Expected IndexResponse but got " + response.getClass().getSimpleName(), new Object[]{RestStatus.INTERNAL_SERVER_ERROR});
        };
    }

    public PutDataObjectResponse(String index, String id, XContentParser parser, boolean failed, Exception cause, RestStatus status) {
        super(index, id, parser, failed, cause, status);
        this.indexResponse = null;
    }

    @Nullable
    public IndexResponse indexResponse() {
        if (this.indexResponse == null) {
            try {
                return IndexResponse.fromXContent((XContentParser)this.parser());
            }
            catch (IOException | NullPointerException e) {
                return null;
            }
        }
        return this.indexResponse;
    }

    @Override
    public XContentParser parser() {
        if (super.parser() == null) {
            try {
                return SdkClientUtils.createParser((ToXContent)this.indexResponse);
            }
            catch (IOException | NullPointerException e) {
                return null;
            }
        }
        return super.parser();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DataObjectResponse.Builder<Builder> {
        public PutDataObjectResponse build() {
            return new PutDataObjectResponse(this.index, this.id, this.parser, this.failed, this.cause, this.status);
        }
    }
}

