/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges.dlsfls;

import java.io.IOException;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.opensearch.OpenSearchException;
import org.opensearch.security.privileges.dlsfls.FieldMasking;
import org.opensearch.security.privileges.dlsfls.FieldPrivileges;
import org.opensearch.security.privileges.dlsfls.FlsDocumentFilter;

public class FlsStoredFieldVisitor
extends StoredFieldVisitor {
    private static final Logger log = LogManager.getLogger(FlsStoredFieldVisitor.class);
    private final StoredFieldVisitor delegate;
    private final FieldPrivileges.FlsRule flsRule;
    private final FieldMasking.FieldMaskingRule fieldMaskingRule;
    private final Set<String> metaFields;

    public FlsStoredFieldVisitor(StoredFieldVisitor delegate, FieldPrivileges.FlsRule flsRule, FieldMasking.FieldMaskingRule fieldMaskingRule, Set<String> metaFields) {
        this.delegate = delegate;
        this.flsRule = flsRule;
        this.fieldMaskingRule = fieldMaskingRule;
        this.metaFields = metaFields;
        if (log.isDebugEnabled()) {
            log.debug("Created FlsStoredFieldVisitor for {}; {}", (Object)flsRule, (Object)fieldMaskingRule);
        }
    }

    public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
        if (fieldInfo.name.equals("_source")) {
            try {
                this.delegate.binaryField(fieldInfo, FlsDocumentFilter.filter(value, this.flsRule, this.fieldMaskingRule, this.metaFields));
            }
            catch (IOException e) {
                throw new OpenSearchException("Cannot filter source of document", (Throwable)e, new Object[0]);
            }
        } else {
            FieldMasking.FieldMaskingRule.Field field = this.fieldMaskingRule.get(fieldInfo.name);
            if (field != null) {
                this.delegate.binaryField(fieldInfo, field.apply(value));
            } else {
                this.delegate.binaryField(fieldInfo, value);
            }
        }
    }

    public void stringField(FieldInfo fieldInfo, String value) throws IOException {
        FieldMasking.FieldMaskingRule.Field field = this.fieldMaskingRule.get(fieldInfo.name);
        if (field != null) {
            this.delegate.stringField(fieldInfo, field.apply(value));
        } else {
            this.delegate.stringField(fieldInfo, value);
        }
    }

    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
        return this.metaFields.contains(fieldInfo.name) || this.flsRule.isAllowedRecursive(fieldInfo.name) ? this.delegate.needsField(fieldInfo) : StoredFieldVisitor.Status.NO;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public void intField(FieldInfo fieldInfo, int value) throws IOException {
        this.delegate.intField(fieldInfo, value);
    }

    public void longField(FieldInfo fieldInfo, long value) throws IOException {
        this.delegate.longField(fieldInfo, value);
    }

    public void floatField(FieldInfo fieldInfo, float value) throws IOException {
        this.delegate.floatField(fieldInfo, value);
    }

    public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
        this.delegate.doubleField(fieldInfo, value);
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public StoredFieldVisitor delegate() {
        return this.delegate;
    }
}

