/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.rules.ImmutableIntersectToExistsRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.immutables.value.Value;

@Value.Enclosing
public class IntersectToExistsRule
extends RelRule<Config>
implements TransformationRule {
    protected IntersectToExistsRule(Config config) {
        super(config);
    }

    @Deprecated
    public IntersectToExistsRule(Class<? extends Intersect> intersectClass, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class).withOperandFor(intersectClass));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Object nextInput;
        Intersect intersect = (Intersect)call.rel(0);
        if (intersect.all) {
            return;
        }
        RelBuilder builder = call.builder();
        RexBuilder rexBuilder = builder.getRexBuilder();
        RelDataType rowType = intersect.getRowType();
        List<RelNode> inputs = intersect.getInputs();
        RelNode current = inputs.get(0);
        ImmutableBitSet fieldIndices = ImmutableBitSet.of(rowType.getFieldList().stream().map(RelDataTypeField::getIndex).collect(Collectors.toList()));
        for (int i = 1; i < inputs.size(); ++i) {
            nextInput = inputs.get(i).stripped();
            CorrelationId correlationId = intersect.getCluster().createCorrel();
            RexNode correl = rexBuilder.makeCorrel(rowType, correlationId);
            ArrayList<RexNode> conditions = new ArrayList<RexNode>();
            for (int fieldIndex : fieldIndices) {
                RexInputRef outerField = rexBuilder.makeInputRef(rowType, fieldIndex);
                RexNode innerField = rexBuilder.makeFieldAccess(correl, fieldIndex);
                conditions.add(builder.isNotDistinctFrom(innerField, outerField));
            }
            RexNode condition = RexUtil.composeConjunction(rexBuilder, conditions);
            RelNode existsSubQuery = builder.push((RelNode)nextInput).filter(condition).project((Iterable<? extends RexNode>)builder.fields(fieldIndices)).build();
            current = builder.push(current).filter((Iterable<CorrelationId>)ImmutableSet.of((Object)correlationId), RexSubQuery.exists(existsSubQuery)).build();
        }
        builder.push(current);
        ArrayList<RexNode> projects = new ArrayList<RexNode>();
        nextInput = fieldIndices.iterator();
        while (nextInput.hasNext()) {
            int fieldIndex = (Integer)nextInput.next();
            RexNode rexNode = (RexNode)builder.fields().get(fieldIndex);
            RelDataType originalType = rowType.getFieldList().get(projects.size()).getType();
            RexNode expr = !originalType.equals(rexNode.getType()) ? rexBuilder.makeCast(originalType, rexNode, true, false) : rexNode;
            projects.add(expr);
        }
        RelNode result = builder.project(projects).distinct().build();
        call.transformTo(result);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableIntersectToExistsRule.Config.of().withOperandFor(LogicalIntersect.class);

        @Override
        default public IntersectToExistsRule toRule() {
            return new IntersectToExistsRule(this);
        }

        default public Config withOperandFor(Class<? extends Intersect> intersectClass) {
            return this.withOperandSupplier(b -> b.operand(intersectClass).anyInputs()).as(Config.class);
        }
    }
}

