/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.zlib;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.modules.zlib.NativeZlibCompObject;
import com.oracle.graal.python.builtins.modules.zlib.ZLibModuleBuiltins;
import com.oracle.graal.python.builtins.modules.zlib.ZlibDecompressorObject;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.NFIZlibSupport;
import com.oracle.graal.python.runtime.NativeLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

public class ZlibNodes {
    public static final int Z_OK = 0;
    public static final int Z_STREAM_END = 1;
    public static final int Z_NEED_DICT = 2;
    public static final int Z_ERRNO = -1;
    public static final int Z_STREAM_ERROR = -2;
    public static final int Z_DATA_ERROR = -3;
    public static final int Z_MEM_ERROR = -4;
    public static final int Z_BUF_ERROR = -5;
    public static final int Z_VERSION_ERROR = -6;

    protected static void deallocateStream(Object zst, NFIZlibSupport zlibSupport, NativeLibrary.InvokeNativeFunction deallocateStream, boolean deallocate) {
        if (deallocate) {
            zlibSupport.deallocateStream(zst, deallocateStream);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetNativeBufferNode
    extends PNodeWithContext {
        public abstract byte[] execute(Node var1, Object var2, int var3, PythonContext var4);

        public byte[] getOutputBuffer(Node inliningTarget, Object zst, PythonContext context) {
            return this.execute(inliningTarget, zst, 0, context);
        }

        public byte[] getUnusedDataBuffer(Node inliningTarget, Object zst, PythonContext context) {
            return this.execute(inliningTarget, zst, 1, context);
        }

        public byte[] getUnconsumedTailBuffer(Node inliningTarget, Object zst, PythonContext context) {
            return this.execute(inliningTarget, zst, 2, context);
        }

        @Specialization
        static byte[] getBuffer(Object zst, int option, PythonContext context, @Cached(inline=false) NativeLibrary.InvokeNativeFunction getBufferSize, @Cached(inline=false) NativeLibrary.InvokeNativeFunction getBuffer) {
            NFIZlibSupport zlibSupport = context.getNFIZlibSupport();
            int size = zlibSupport.getBufferSize(zst, option, getBufferSize);
            if (size == 0) {
                return PythonUtils.EMPTY_BYTE_ARRAY;
            }
            byte[] resultArray = new byte[size];
            zlibSupport.getBuffer(zst, option, resultArray, getBuffer);
            return resultArray;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class NativeDeallocation
    extends PNodeWithContext {
        public abstract void execute(Node var1, NativeZlibCompObject var2, PythonContext var3, boolean var4);

        @Specialization(guards={"isCompressObj"})
        static void doCompressObj(NativeZlibCompObject self, PythonContext context, boolean isCompressObj, @Cached.Shared @Cached(inline=false) NativeLibrary.InvokeNativeFunction deallocateStream) {
            context.getNFIZlibSupport().deallocateStream(self.getZst(), deallocateStream);
            self.setEof(true);
            self.markReleased();
        }

        @Specialization(guards={"!isCompressObj"})
        static void doDecompressObj(Node inliningTarget, NativeZlibCompObject self, PythonContext context, boolean isCompressObj, @Cached GetNativeBufferNode getUnusedDataBuffer, @Cached GetNativeBufferNode getUnconsumedBuffer, @Cached.Shared @Cached(inline=false) NativeLibrary.InvokeNativeFunction deallocateStream) {
            byte[] unusedData = getUnusedDataBuffer.getUnusedDataBuffer(inliningTarget, self.getZst(), context);
            PythonLanguage language = context.getLanguage(inliningTarget);
            self.setUnusedData(PFactory.createBytes(language, unusedData));
            byte[] unconsumed = getUnconsumedBuffer.getUnconsumedTailBuffer(inliningTarget, self.getZst(), context);
            self.setUnconsumedTail(PFactory.createBytes(language, unconsumed));
            context.getNFIZlibSupport().deallocateStream(self.getZst(), deallocateStream);
            self.setEof(true);
            self.markReleased();
        }
    }

    @ImportStatic(value={NFIZlibSupport.class, ZLibModuleBuiltins.class})
    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class ZlibFunctionNativeErrorHandling
    extends Node {
        public abstract void execute(Object var1, int var2, int var3, NFIZlibSupport var4, boolean var5);

        @Specialization(guards={"function == DEFLATE_INIT_ERROR"})
        static void deflateInitError(Object zst, int function, int err, NFIZlibSupport zlibSupport, boolean deallocate, @Bind Node inliningTarget, @Cached.Shared(value="r") @Cached PRaiseNode raise, @Cached.Shared(value="d") @Cached NativeLibrary.InvokeNativeFunction deallocateStream, @Cached.Shared(value="err") @Cached ZlibNativeErrorMsg zlibError, @Cached.Shared(value="format") @Cached StringUtils.SimpleTruffleStringFormatNode formatNode) {
            if (err == -4) {
                ZlibNodes.deallocateStream(zst, zlibSupport, deallocateStream, deallocate);
                throw raise.raise(inliningTarget, PythonErrorType.MemoryError, ErrorMessages.OUT_OF_MEMORY_WHILE_S_DATA, "compressing");
            }
            if (err == -2) {
                ZlibNodes.deallocateStream(zst, zlibSupport, deallocateStream, deallocate);
                throw raise.raise(inliningTarget, PythonErrorType.ZLibError, ErrorMessages.BAD_COMPRESSION_LEVEL);
            }
            zlibError.execute(zst, err, formatNode.format(ErrorMessages.WHILE_S_DATA, "compressing"), zlibSupport, deallocate);
        }

        @Specialization(guards={"function == DEFLATE_OBJ_ERROR"})
        static void deflateObjInitError(Object zst, int function, int err, NFIZlibSupport zlibSupport, boolean deallocate, @Bind Node inliningTarget, @Cached.Shared(value="r") @Cached PRaiseNode raise, @Cached.Shared(value="d") @Cached NativeLibrary.InvokeNativeFunction deallocateStream, @Cached.Shared(value="err") @Cached ZlibNativeErrorMsg zlibError, @Cached.Shared(value="format") @Cached StringUtils.SimpleTruffleStringFormatNode formatNode) {
            if (err == -4) {
                ZlibNodes.deallocateStream(zst, zlibSupport, deallocateStream, deallocate);
                throw raise.raise(inliningTarget, PythonErrorType.MemoryError, ErrorMessages.CANT_ALLOCATE_MEMORY_FOR_S_OBJECT, "compression");
            }
            if (err == -2) {
                ZlibNodes.deallocateStream(zst, zlibSupport, deallocateStream, deallocate);
                throw raise.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.INVALID_INITIALIZATION_OPTION);
            }
            zlibError.execute(zst, err, formatNode.format(ErrorMessages.WHILE_CREATING_S_OBJECT, "compression"), zlibSupport, deallocate);
        }

        @Specialization(guards={"function == DEFLATE_COPY_ERROR"})
        static void deflateCopyError(Object zst, int function, int err, NFIZlibSupport zlibSupport, boolean deallocate, @Bind Node inliningTarget, @Cached.Shared(value="r") @Cached PRaiseNode raise, @Cached.Shared(value="d") @Cached NativeLibrary.InvokeNativeFunction deallocateStream, @Cached.Shared(value="err") @Cached ZlibNativeErrorMsg zlibError, @Cached.Shared(value="format") @Cached StringUtils.SimpleTruffleStringFormatNode formatNode) {
            if (err == -4) {
                ZlibNodes.deallocateStream(zst, zlibSupport, deallocateStream, deallocate);
                throw raise.raise(inliningTarget, PythonErrorType.MemoryError, ErrorMessages.CANT_ALLOCATE_MEMORY_FOR_S_OBJECT, "compression");
            }
            if (err == -2) {
                ZlibNodes.deallocateStream(zst, zlibSupport, deallocateStream, deallocate);
                throw raise.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.INCONSISTENT_STREAM_STATE);
            }
            zlibError.execute(zst, err, formatNode.format(ErrorMessages.WHILE_COPYING_S_OBJECT, "compression"), zlibSupport, deallocate);
        }

        @Specialization(guards={"function == INFLATE_COPY_ERROR"})
        static void inflateCopyError(Object zst, int function, int err, NFIZlibSupport zlibSupport, boolean deallocate, @Bind Node inliningTarget, @Cached.Shared(value="r") @Cached PRaiseNode raise, @Cached.Shared(value="d") @Cached NativeLibrary.InvokeNativeFunction deallocateStream, @Cached.Shared(value="err") @Cached ZlibNativeErrorMsg zlibError, @Cached.Shared(value="format") @Cached StringUtils.SimpleTruffleStringFormatNode formatNode) {
            if (err == -4) {
                ZlibNodes.deallocateStream(zst, zlibSupport, deallocateStream, deallocate);
                throw raise.raise(inliningTarget, PythonErrorType.MemoryError, ErrorMessages.CANT_ALLOCATE_MEMORY_FOR_S_OBJECT, "decompression");
            }
            if (err == -2) {
                ZlibNodes.deallocateStream(zst, zlibSupport, deallocateStream, deallocate);
                throw raise.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.INCONSISTENT_STREAM_STATE);
            }
            zlibError.execute(zst, err, formatNode.format(ErrorMessages.WHILE_COPYING_S_OBJECT, "compression"), zlibSupport, deallocate);
        }

        @Specialization(guards={"function == DEFLATE_DICT_ERROR"})
        static void deflateDictError(Object zst, int function, int err, NFIZlibSupport zlibSupport, boolean deallocate, @Bind Node inliningTarget, @Cached.Shared(value="d") @Cached NativeLibrary.InvokeNativeFunction deallocateStream, @Cached.Shared(value="r") @Cached PRaiseNode raise) {
            if (err == -2) {
                ZlibNodes.deallocateStream(zst, zlibSupport, deallocateStream, deallocate);
                throw raise.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.INVALID_DICTIONARY);
            }
            throw raise.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.DEFLATED_SET_DICT);
        }

        @Specialization(guards={"function == INFLATE_INIT_ERROR"})
        static void inflateInitError(Object zst, int function, int err, NFIZlibSupport zlibSupport, boolean deallocate, @Bind Node inliningTarget, @Cached.Shared(value="r") @Cached PRaiseNode raise, @Cached.Shared(value="d") @Cached NativeLibrary.InvokeNativeFunction deallocateStream, @Cached.Shared(value="err") @Cached ZlibNativeErrorMsg zlibError, @Cached.Shared(value="format") @Cached StringUtils.SimpleTruffleStringFormatNode formatNode) {
            if (err == -4) {
                ZlibNodes.deallocateStream(zst, zlibSupport, deallocateStream, deallocate);
                throw raise.raise(inliningTarget, PythonErrorType.MemoryError, ErrorMessages.OUT_OF_MEMORY_WHILE_S_DATA, "decompressing");
            }
            zlibError.execute(zst, err, formatNode.format(ErrorMessages.WHILE_PREPARING_TO_S_DATA, "decompress"), zlibSupport, deallocate);
        }

        @Specialization(guards={"function == INFLATE_OBJ_ERROR"})
        static void inflateObjInitError(Object zst, int function, int err, NFIZlibSupport zlibSupport, boolean deallocate, @Bind Node inliningTarget, @Cached.Shared(value="r") @Cached PRaiseNode raise, @Cached.Shared(value="d") @Cached NativeLibrary.InvokeNativeFunction deallocateStream, @Cached.Shared(value="err") @Cached ZlibNativeErrorMsg zlibError, @Cached.Shared(value="format") @Cached StringUtils.SimpleTruffleStringFormatNode formatNode) {
            if (err == -4) {
                ZlibNodes.deallocateStream(zst, zlibSupport, deallocateStream, deallocate);
                throw raise.raise(inliningTarget, PythonErrorType.MemoryError, ErrorMessages.CANT_ALLOCATE_MEMORY_FOR_S_OBJECT, "decompression");
            }
            if (err == -2) {
                ZlibNodes.deallocateStream(zst, zlibSupport, deallocateStream, deallocate);
                throw raise.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.INVALID_INITIALIZATION_OPTION);
            }
            zlibError.execute(zst, err, formatNode.format(ErrorMessages.WHILE_CREATING_S_OBJECT, "decompression"), zlibSupport, deallocate);
        }

        @Specialization(guards={"function == INFLATE_DICT_ERROR"})
        static void inflateDictError(Object zst, int function, int err, NFIZlibSupport zlibSupport, boolean deallocate, @Cached.Shared(value="err") @Cached ZlibNativeErrorMsg zlibError) {
            zlibError.execute(zst, err, ErrorMessages.WHILE_SETTING_ZDICT, zlibSupport, deallocate);
        }

        @Specialization(guards={"function == DEFLATE_END_ERROR"})
        static void deflateEndError(Object zst, int function, int err, NFIZlibSupport zlibSupport, boolean deallocate, @Cached.Shared(value="err") @Cached ZlibNativeErrorMsg zlibError, @Cached.Shared(value="format") @Cached StringUtils.SimpleTruffleStringFormatNode formatNode) {
            zlibError.execute(zst, err, formatNode.format(ErrorMessages.WHILE_FINISHING_S, "compression"), zlibSupport, deallocate);
        }

        @Specialization(guards={"function == INFLATE_END_ERROR"})
        static void inflateEndError(Object zst, int function, int err, NFIZlibSupport zlibSupport, boolean deallocate, @Cached.Shared(value="err") @Cached ZlibNativeErrorMsg zlibError, @Cached.Shared(value="format") @Cached StringUtils.SimpleTruffleStringFormatNode formatNode) {
            zlibError.execute(zst, err, formatNode.format(ErrorMessages.WHILE_FINISHING_S, "decompression"), zlibSupport, deallocate);
        }

        @Specialization(guards={"function == DEFLATE_ERROR"})
        static void deflateError(Object zst, int function, int err, NFIZlibSupport zlibSupport, boolean deallocate, @Cached.Shared(value="err") @Cached ZlibNativeErrorMsg zlibError, @Cached.Shared(value="format") @Cached StringUtils.SimpleTruffleStringFormatNode formatNode) {
            zlibError.execute(zst, err, formatNode.format(ErrorMessages.WHILE_S_DATA, "compressing"), zlibSupport, deallocate);
        }

        @Specialization(guards={"function == INFLATE_ERROR"})
        static void inflateError(Object zst, int function, int err, NFIZlibSupport zlibSupport, boolean deallocate, @Cached.Shared(value="err") @Cached ZlibNativeErrorMsg zlibError, @Cached.Shared(value="format") @Cached StringUtils.SimpleTruffleStringFormatNode formatNode) {
            zlibError.execute(zst, err, formatNode.format(ErrorMessages.WHILE_S_DATA, "decompressing"), zlibSupport, deallocate);
        }

        @Specialization(guards={"function == DEFLATE_FLUSH_ERROR"})
        static void deflateFlushError(Object zst, int function, int err, NFIZlibSupport zlibSupport, boolean deallocate, @Cached.Shared(value="err") @Cached ZlibNativeErrorMsg zlibError) {
            zlibError.execute(zst, err, ErrorMessages.WHILE_FLUSHING, zlibSupport, deallocate);
        }

        @Specialization(guards={"function == INFLATE_FLUSH_ERROR"})
        static void inflateFlushError(Object zst, int function, int err, NFIZlibSupport zlibSupport, boolean deallocate, @Cached.Shared(value="err") @Cached ZlibNativeErrorMsg zlibError) {
            zlibError.execute(zst, err, ErrorMessages.WHILE_FLUSHING, zlibSupport, deallocate);
        }

        @Specialization(guards={"function == MEMORY_ERROR"})
        static void memError(Object zst, int function, int err, NFIZlibSupport zlibSupport, boolean deallocate, @Bind Node inliningTarget, @Cached.Shared(value="d") @Cached NativeLibrary.InvokeNativeFunction deallocateStream, @Cached.Shared(value="r") @Cached PRaiseNode raise) {
            ZlibNodes.deallocateStream(zst, zlibSupport, deallocateStream, deallocate);
            throw raise.raise(inliningTarget, PythonErrorType.MemoryError);
        }

        @Fallback
        void fallback(Object zst, int function, int err, NFIZlibSupport zlibSupport, boolean deallocate) {
            throw PRaiseNode.raiseStatic((Node)this, PythonErrorType.SystemError, ErrorMessages.UNHANDLED_ERROR);
        }
    }

    @ImportStatic(value={ZlibNodes.class})
    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class ZlibNativeErrorMsg
    extends Node {
        public abstract void execute(Object var1, int var2, TruffleString var3, NFIZlibSupport var4, boolean var5);

        @Specialization(guards={"err == Z_VERSION_ERROR"})
        static void doVersionError(Object zst, int err, TruffleString msg, NFIZlibSupport zlibSupport, boolean deallocate, @Bind Node inliningTarget, @Cached.Shared(value="d") @Cached NativeLibrary.InvokeNativeFunction deallocateStream, @Cached.Shared(value="r") @Cached PRaiseNode raise) {
            ZlibNodes.deallocateStream(zst, zlibSupport, deallocateStream, deallocate);
            throw raise.raise(inliningTarget, PythonErrorType.ZLibError, ErrorMessages.ERROR_D_S_S, err, msg, ErrorMessages.LIBRARY_VERSION_MISMATCH);
        }

        @Specialization(guards={"err != Z_VERSION_ERROR"})
        static void doError(Object zst, int err, TruffleString msg, NFIZlibSupport zlibSupport, boolean deallocate, @Bind Node inliningTarget, @Cached.Shared(value="r") @Cached PRaiseNode raise, @Cached.Shared(value="d") @Cached NativeLibrary.InvokeNativeFunction deallocateStream, @Cached.Exclusive @Cached NativeLibrary.InvokeNativeFunction hasStreamErrorMsg, @Cached.Exclusive @Cached NativeLibrary.InvokeNativeFunction getStreamErrorMsg) {
            TruffleString zmsg = null;
            if (zlibSupport.hasStreamErrorMsg(zst, hasStreamErrorMsg) == 1) {
                zmsg = zlibSupport.getStreamErrorMsg(zst, getStreamErrorMsg);
            } else {
                switch (err) {
                    case -5: {
                        zmsg = ErrorMessages.INCOMPLETE_OR_TRUNCATED_STREAM;
                        break;
                    }
                    case -2: {
                        zmsg = ErrorMessages.INCONSISTENT_STREAM_STATE;
                        break;
                    }
                    case -3: {
                        zmsg = ErrorMessages.INVALID_INPUT_DATA;
                    }
                }
            }
            ZlibNodes.deallocateStream(zst, zlibSupport, deallocateStream, deallocate);
            if (zmsg == null) {
                throw raise.raise(inliningTarget, PythonErrorType.ZLibError, ErrorMessages.ERROR_D_S, err, msg);
            }
            throw raise.raise(inliningTarget, PythonErrorType.ZLibError, ErrorMessages.ERROR_D_S_S, err, msg, zmsg);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ZlibNativeErrorHandling
    extends Node {
        public abstract void execute(Node var1, Object var2, int var3, NFIZlibSupport var4, boolean var5);

        @Specialization
        static void doError(Object zst, int err, NFIZlibSupport zlibSupport, boolean deallocate, @Cached(inline=false) ZlibFunctionNativeErrorHandling errorHandling, @Cached(inline=false) NativeLibrary.InvokeNativeFunction getErrorFunction) {
            errorHandling.execute(zst, zlibSupport.getErrorFunction(zst, getErrorFunction), err, zlibSupport, deallocate);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ZlibNativeDecompress
    extends PNodeWithContext {
        public abstract byte[] execute(Node var1, byte[] var2, int var3, int var4, int var5, PythonContext var6);

        @Specialization
        static byte[] nativeCompress(Node inliningTarget, byte[] bytes, int len, int wbits, int bufsize, PythonContext context, @Cached(inline=false) NativeLibrary.InvokeNativeFunction createStream, @Cached(inline=false) NativeLibrary.InvokeNativeFunction deallocateStream, @Cached(inline=false) NativeLibrary.InvokeNativeFunction inflateOffHeap, @Cached GetNativeBufferNode getBuffer, @Cached ZlibNativeErrorHandling errorHandling) {
            byte[] in;
            Object zst;
            NFIZlibSupport zlibSupport = context.getNFIZlibSupport();
            int err = zlibSupport.inflateOffHeap(zst = zlibSupport.createStream(createStream), in = bytes, len, bufsize, wbits, inflateOffHeap);
            if (err != 0) {
                errorHandling.execute(inliningTarget, zst, err, zlibSupport, true);
            }
            byte[] resultArray = getBuffer.getOutputBuffer(inliningTarget, zst, context);
            zlibSupport.deallocateStream(zst, deallocateStream);
            return resultArray;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ZlibNativeDecompressor
    extends PNodeWithContext {
        public abstract byte[] execute(Node var1, ZlibDecompressorObject var2, PythonContext var3, byte[] var4, int var5, int var6);

        @Specialization
        static byte[] nativeDecompressBuf(Node inliningTarget, ZlibDecompressorObject self, PythonContext context, byte[] bytes, int len, int maxLength, @Cached(inline=false) NativeLibrary.InvokeNativeFunction decompressor, @Cached GetNativeBufferNode getBuffer, @Cached ZlibNativeErrorHandling errorHandling) {
            NFIZlibSupport zlibSupport = context.getNFIZlibSupport();
            byte[] in = bytes;
            int ret = zlibSupport.decompressor(self.getZst(), in, len, maxLength, decompressor);
            if (ret < 0) {
                errorHandling.execute(inliningTarget, self.getZst(), ret, zlibSupport, false);
            }
            self.setNeedsInput(ret == 1);
            return getBuffer.getOutputBuffer(inliningTarget, self.getZst(), context);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ZlibNativeDecompressObj
    extends PNodeWithContext {
        public abstract byte[] execute(Node var1, NativeZlibCompObject var2, PythonContext var3, byte[] var4, int var5, int var6);

        @Specialization
        static byte[] nativeDecompress(Node inliningTarget, NativeZlibCompObject self, PythonContext context, byte[] bytes, int len, int maxLength, @Cached(inline=false) NativeLibrary.InvokeNativeFunction decompressObj, @Cached GetNativeBufferNode getBuffer, @Cached ZlibNativeErrorHandling errorHandling) {
            NFIZlibSupport zlibSupport = context.getNFIZlibSupport();
            byte[] in = bytes;
            int err = zlibSupport.decompressObj(self.getZst(), in, len, 16384L, maxLength, decompressObj);
            if (err != 0) {
                errorHandling.execute(inliningTarget, self.getZst(), err, zlibSupport, false);
            }
            return getBuffer.getOutputBuffer(inliningTarget, self.getZst(), context);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ZlibNativeCompress
    extends PNodeWithContext {
        public abstract byte[] execute(Node var1, byte[] var2, int var3, int var4, int var5);

        @Specialization
        static byte[] nativeCompress(Node inliningTarget, byte[] bytes, int len, int level, int wbits, @Cached(inline=false) NativeLibrary.InvokeNativeFunction createStream, @Cached(inline=false) NativeLibrary.InvokeNativeFunction deallocateStream, @Cached(inline=false) NativeLibrary.InvokeNativeFunction deflateOffHeap, @Cached GetNativeBufferNode getBuffer, @Cached ZlibNativeErrorHandling errorHandling) {
            PythonContext context = PythonContext.get(inliningTarget);
            NFIZlibSupport zlibSupport = context.getNFIZlibSupport();
            byte[] in = bytes;
            Object zst = zlibSupport.createStream(createStream);
            int err = zlibSupport.deflateOffHeap(zst, in, len, 16384L, level, wbits, deflateOffHeap);
            if (err != 0) {
                errorHandling.execute(inliningTarget, zst, err, zlibSupport, true);
            }
            byte[] resultArray = getBuffer.getOutputBuffer(inliningTarget, zst, context);
            zlibSupport.deallocateStream(zst, deallocateStream);
            return resultArray;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ZlibNativeCompressObj
    extends PNodeWithContext {
        public abstract byte[] execute(Node var1, NativeZlibCompObject var2, PythonContext var3, byte[] var4, int var5);

        @Specialization
        static byte[] nativeCompress(Node inliningTarget, NativeZlibCompObject self, PythonContext context, byte[] bytes, int len, @Cached(inline=false) NativeLibrary.InvokeNativeFunction compressObj, @Cached GetNativeBufferNode getBuffer, @Cached ZlibNativeErrorHandling errorHandling) {
            NFIZlibSupport zlibSupport = context.getNFIZlibSupport();
            self.lastInput = bytes;
            int err = zlibSupport.compressObj(self.getZst(), self.lastInput, len, 16384L, compressObj);
            if (err != 0) {
                errorHandling.execute(inliningTarget, self.getZst(), err, zlibSupport, false);
            }
            return getBuffer.getOutputBuffer(inliningTarget, self.getZst(), context);
        }
    }
}

