/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.xxhash;

import net.jpountz.xxhash.StreamingXXHash64;
import net.jpountz.xxhash.XXHashJNI;

final class StreamingXXHash64JNI
extends StreamingXXHash64 {
    private long state;

    StreamingXXHash64JNI(long l2) {
        super(l2);
        this.state = XXHashJNI.XXH64_init(l2);
    }

    private void checkState() {
        if (this.state == 0L) {
            throw new AssertionError((Object)"Already finalized");
        }
    }

    @Override
    public void reset() {
        this.checkState();
        XXHashJNI.XXH64_free(this.state);
        this.state = XXHashJNI.XXH64_init(this.seed);
    }

    @Override
    public long getValue() {
        this.checkState();
        return XXHashJNI.XXH64_digest(this.state);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        this.checkState();
        XXHashJNI.XXH64_update(this.state, byArray, n2, n3);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        XXHashJNI.XXH64_free(this.state);
        this.state = 0L;
    }

    static class Factory
    implements StreamingXXHash64.Factory {
        public static final StreamingXXHash64.Factory INSTANCE = new Factory();

        Factory() {
        }

        @Override
        public StreamingXXHash64 newStreamingHash(long l2) {
            return new StreamingXXHash64JNI(l2);
        }
    }
}

