/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Collection;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.Version;
import tools.jackson.core.Versioned;
import tools.jackson.core.exc.JacksonIOException;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectWriter;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.cfg.PackageVersion;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.SerializationContextExt;
import tools.jackson.databind.ser.impl.PropertySerializerMap;
import tools.jackson.databind.ser.impl.TypeWrappedSerializer;

public class SequenceWriter
implements Versioned,
Closeable,
Flushable {
    protected final SerializationContextExt _provider;
    protected final SerializationConfig _config;
    protected final JsonGenerator _generator;
    protected final ValueSerializer<Object> _rootSerializer;
    protected final TypeSerializer _typeSerializer;
    protected final boolean _closeGenerator;
    protected final boolean _cfgFlush;
    protected final boolean _cfgCloseCloseable;
    protected PropertySerializerMap _dynamicSerializers;
    protected boolean _openArray;
    protected boolean _closed;

    public SequenceWriter(SerializationContextExt prov, JsonGenerator gen, boolean closeGenerator, ObjectWriter.Prefetch prefetch) {
        this._provider = prov;
        this._generator = gen;
        this._closeGenerator = closeGenerator;
        this._rootSerializer = prefetch.getValueSerializer();
        this._typeSerializer = prefetch.getTypeSerializer();
        this._config = prov.getConfig();
        this._cfgFlush = this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE);
        this._cfgCloseCloseable = this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE);
        this._dynamicSerializers = PropertySerializerMap.emptyForRootValues();
    }

    public SequenceWriter init(boolean wrapInArray) throws JacksonException {
        if (wrapInArray) {
            this._generator.writeStartArray();
            this._openArray = true;
        }
        return this;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public SequenceWriter write(Object value) throws JacksonException {
        Class<?> type;
        if (value == null) {
            this._provider.serializeValue(this._generator, null);
            return this;
        }
        if (this._cfgCloseCloseable && value instanceof Closeable) {
            return this._writeCloseableValue(value);
        }
        ValueSerializer<Object> ser = this._rootSerializer;
        if (ser == null && (ser = this._dynamicSerializers.serializerFor(type = value.getClass())) == null) {
            ser = this._findAndAddDynamic(type);
        }
        this._provider.serializeValue(this._generator, value, null, ser);
        if (this._cfgFlush) {
            this._generator.flush();
        }
        return this;
    }

    public SequenceWriter write(Object value, JavaType type) throws JacksonException {
        if (value == null) {
            this._provider.serializeValue(this._generator, null);
            return this;
        }
        if (this._cfgCloseCloseable && value instanceof Closeable) {
            return this._writeCloseableValue(value, type);
        }
        ValueSerializer<Object> ser = this._dynamicSerializers.serializerFor(type.getRawClass());
        if (ser == null) {
            ser = this._findAndAddDynamic(type);
        }
        this._provider.serializeValue(this._generator, value, type, ser);
        if (this._cfgFlush) {
            this._generator.flush();
        }
        return this;
    }

    public SequenceWriter writeAll(Object[] value) throws JacksonException {
        int len = value.length;
        for (int i = 0; i < len; ++i) {
            this.write(value[i]);
        }
        return this;
    }

    public <C extends Collection<?>> SequenceWriter writeAll(C container) throws JacksonException {
        for (Object value : container) {
            this.write(value);
        }
        return this;
    }

    public SequenceWriter writeAll(Iterable<?> iterable) throws JacksonException {
        for (Object value : iterable) {
            this.write(value);
        }
        return this;
    }

    @Override
    public void flush() {
        if (!this._closed) {
            this._generator.flush();
        }
    }

    @Override
    public void close() {
        if (!this._closed) {
            this._closed = true;
            if (this._openArray) {
                this._openArray = false;
                this._generator.writeEndArray();
            }
            if (this._closeGenerator) {
                this._generator.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SequenceWriter _writeCloseableValue(Object value) throws JacksonException {
        Closeable toClose = (Closeable)value;
        try {
            Class<?> type;
            ValueSerializer<Object> ser = this._rootSerializer;
            if (ser == null && (ser = this._dynamicSerializers.serializerFor(type = value.getClass())) == null) {
                ser = this._findAndAddDynamic(type);
            }
            this._provider.serializeValue(this._generator, value, null, ser);
            if (this._cfgFlush) {
                this._generator.flush();
            }
            Closeable tmpToClose = toClose;
            toClose = null;
            try {
                tmpToClose.close();
            }
            catch (IOException e) {
                throw JacksonIOException.construct((IOException)e, (Closeable)this._generator);
            }
        }
        finally {
            if (toClose != null) {
                try {
                    toClose.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SequenceWriter _writeCloseableValue(Object value, JavaType type) throws JacksonException {
        Closeable toClose = (Closeable)value;
        try {
            ValueSerializer<Object> ser = this._dynamicSerializers.serializerFor(type.getRawClass());
            if (ser == null) {
                ser = this._findAndAddDynamic(type);
            }
            this._provider.serializeValue(this._generator, value, type, ser);
            if (this._cfgFlush) {
                this._generator.flush();
            }
            Closeable tmpToClose = toClose;
            toClose = null;
            try {
                tmpToClose.close();
            }
            catch (IOException e) {
                throw JacksonIOException.construct((IOException)e);
            }
        }
        finally {
            if (toClose != null) {
                try {
                    toClose.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this;
    }

    private final ValueSerializer<Object> _findAndAddDynamic(Class<?> type) {
        PropertySerializerMap.SerializerAndMapResult result = this._typeSerializer == null ? this._dynamicSerializers.findAndAddRootValueSerializer(type, (SerializationContext)this._provider) : this._dynamicSerializers.addSerializer(type, (ValueSerializer<Object>)new TypeWrappedSerializer(this._typeSerializer, this._provider.findRootValueSerializer(type)));
        this._dynamicSerializers = result.map;
        return result.serializer;
    }

    private final ValueSerializer<Object> _findAndAddDynamic(JavaType type) {
        PropertySerializerMap.SerializerAndMapResult result = this._typeSerializer == null ? this._dynamicSerializers.findAndAddRootValueSerializer(type, (SerializationContext)this._provider) : this._dynamicSerializers.addSerializer(type, (ValueSerializer<Object>)new TypeWrappedSerializer(this._typeSerializer, this._provider.findRootValueSerializer(type)));
        this._dynamicSerializers = result.map;
        return result.serializer;
    }
}

