/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.operation.options;

import schemacrawler.schemacrawler.Query;
import schemacrawler.tools.command.text.operation.options.Operation;
import schemacrawler.tools.command.text.operation.options.OperationOptions;
import schemacrawler.tools.command.text.operation.options.OperationType;
import schemacrawler.tools.command.text.operation.options.QueryOperation;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.text.options.BaseTextOptions;
import schemacrawler.tools.text.options.BaseTextOptionsBuilder;

public final class OperationOptionsBuilder
extends BaseTextOptionsBuilder<OperationOptionsBuilder, OperationOptions> {
    private static final String SHOW_LOBS = "schemacrawler.format.data.show_lobs";
    private static final String MAX_ROWS = "schemacrawler.format.data.max_rows";
    private String command;
    protected Operation operation;
    protected boolean isShowLobs;
    protected int maxRows;

    public static OperationOptionsBuilder builder() {
        return new OperationOptionsBuilder();
    }

    private OperationOptionsBuilder() {
    }

    public OperationOptionsBuilder fromConfig(Config config) {
        if (config == null) {
            return this;
        }
        super.fromConfig(config);
        this.isShowLobs = config.getBooleanValue(SHOW_LOBS, false);
        this.maxRows = config.getIntegerValue(MAX_ROWS, -1);
        if (this.maxRows < 0) {
            this.maxRows = Integer.MAX_VALUE;
        }
        this.operation = this.getQueryFromCommand(config);
        return this;
    }

    public OperationOptionsBuilder fromOptions(OperationOptions options) {
        if (options == null) {
            return this;
        }
        super.fromOptions((BaseTextOptions)options);
        this.isShowLobs = options.isShowLobs();
        this.maxRows = options.getMaxRows();
        return this;
    }

    public OperationOptionsBuilder showLobs() {
        return this.showLobs(true);
    }

    public OperationOptionsBuilder showLobs(boolean value) {
        this.isShowLobs = value;
        return this;
    }

    public OperationOptionsBuilder maxRows(int value) {
        this.maxRows = value;
        if (this.maxRows < 0) {
            this.maxRows = Integer.MAX_VALUE;
        }
        return this;
    }

    public Config toConfig() {
        Config config = super.toConfig();
        config.put(SHOW_LOBS, (Object)this.isShowLobs);
        config.put(MAX_ROWS, (Object)this.maxRows);
        return config;
    }

    public OperationOptions toOptions() {
        if (OperationType.tablesample.equals(this.operation)) {
            this.maxRows = 10;
        }
        return new OperationOptions(this);
    }

    public OperationOptionsBuilder withCommand(String command) {
        this.command = command;
        this.operation = this.getOperationFromCommand();
        return this;
    }

    private Operation getOperationFromCommand() {
        Operation operation = null;
        try {
            operation = OperationType.valueOf(this.command);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            operation = this.operation;
        }
        return operation;
    }

    private Operation getQueryFromCommand(Config config) {
        Operation operation;
        if (config.containsKey(this.command)) {
            String queryName = this.command;
            String queryString = config.getStringValue(queryName, null);
            operation = new QueryOperation(new Query(queryName, queryString));
        } else {
            operation = this.operation;
        }
        return operation;
    }
}

