/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.util.CastToJavaLongNode;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class CastUnsignedToJavaLongHashNode
extends CastToJavaLongNode {
    @Specialization(rewriteOn={OverflowException.class}, insertBefore="doNativeObject")
    static long toLongNoOverflow(PInt x) throws OverflowException {
        return x.longValueExact();
    }

    @Specialization(replaces={"toLongNoOverflow"}, insertBefore="doNativeObject")
    static long toLong(PInt x) {
        try {
            return x.longValueExact();
        }
        catch (OverflowException e) {
            if (x.isZeroOrPositive() && x.bitLength() <= 64) {
                return x.longValue();
            }
            return x.hash();
        }
    }
}

