/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Executable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import oracle.jdbc.AccessToken;
import oracle.jdbc.driver.AccessTokenCache;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.driver.OpaqueAccessToken;
import oracle.jdbc.driver.OpaquePrivateKey;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonValue;

public final class JsonWebToken
extends OpaqueAccessToken {
    private static final OracleJsonFactory JSON_FACTORY;
    private static final DateTimeFormatter DATE_FORMATTER;
    private static final int CACHES_SIZE = 128;
    private static final Map<Builder, AccessTokenCache<JsonWebToken>> CACHES;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    private JsonWebToken(@Blind OpaqueString token, OffsetDateTime expiration, @Blind OpaquePrivateKey opaquePrivateKey) {
        super(token, expiration, opaquePrivateKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    static JsonWebToken fromOciFile(Path path) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        char[] tokenChars = JsonWebToken.readTokenFile(path.resolve("token"));
        try {
            OffsetDateTime expiration = JsonWebToken.parseExp(tokenChars);
            JsonWebToken jsonWebToken = new JsonWebToken(OpaqueString.newOpaqueString(tokenChars), expiration, OpaquePrivateKey.fromPemFile(path.resolve("oci_db_key.pem")));
            return jsonWebToken;
        }
        finally {
            Arrays.fill(tokenChars, '\u0000');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    static JsonWebToken fromFile(Path path) throws IOException {
        char[] tokenChars = Files.isDirectory(path, new LinkOption[0]) ? JsonWebToken.readTokenFile(path.resolve("token")) : JsonWebToken.readTokenFile(path);
        try {
            OffsetDateTime expiration = JsonWebToken.parseExp(tokenChars);
            JsonWebToken jsonWebToken = new JsonWebToken(OpaqueString.newOpaqueString(tokenChars), expiration, null);
            return jsonWebToken;
        }
        finally {
            Arrays.fill(tokenChars, '\u0000');
        }
    }

    static Builder requestBuilder() {
        return new Builder();
    }

    @Blind
    public static JsonWebToken createProofOfPossessionToken(@Blind char[] token, @Blind PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return new JsonWebToken(OpaqueString.newOpaqueString((char[])token.clone()), JsonWebToken.parseExp(token), OpaquePrivateKey.fromPrivateKey(privateKey));
    }

    @Blind
    public static JsonWebToken createBearerToken(@Blind char[] token) {
        return new JsonWebToken(OpaqueString.newOpaqueString((char[])token.clone()), JsonWebToken.parseExp(token), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static char[] readTokenFile(Path path) throws IOException {
        byte[] tokenBytes = Files.readAllBytes(path);
        try {
            char[] cArray;
            CharBuffer tokenBuffer = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(tokenBytes));
            try {
                char[] tokenChars = new char[tokenBuffer.remaining()];
                tokenBuffer.get(tokenChars);
                cArray = tokenChars;
                tokenBuffer.clear();
            }
            catch (Throwable throwable) {
                tokenBuffer.clear();
                tokenBuffer.put(new char[tokenBuffer.remaining()]);
                throw throwable;
            }
            tokenBuffer.put(new char[tokenBuffer.remaining()]);
            return cArray;
        }
        finally {
            Arrays.fill(tokenBytes, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OffsetDateTime parseExp(@Blind char[] jwt) {
        OracleJsonValue exp;
        int end;
        int start;
        if (jwt.length > 16000) {
            throw new IllegalArgumentException("JWT of length " + jwt.length + " exceeds the maximum accepted length of 16,000 characters");
        }
        for (start = 0; start < jwt.length && jwt[start] != '.'; ++start) {
        }
        if (++start > jwt.length) {
            throw new IllegalArgumentException("Failed to identify payload of JWT");
        }
        for (end = start; end < jwt.length && jwt[end] != '.'; ++end) {
        }
        if (end == jwt.length) {
            throw new IllegalArgumentException("Failed to identify payload of JWT");
        }
        byte[] base64Payload = new byte[end - start];
        try {
            for (int i2 = 0; i2 < base64Payload.length; ++i2) {
                base64Payload[i2] = (byte)jwt[i2 + start];
            }
            new TraceControllerImpl().suspend();
            try {
                byte[] jsonPayload = Base64.getMimeDecoder().decode(base64Payload);
                try (ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonPayload);){
                    exp = (OracleJsonValue)JSON_FACTORY.createJsonTextValue(inputStream).asJsonObject().get("exp");
                }
                catch (ClassCastException | OracleJsonException exception) {
                    throw new IllegalArgumentException("JWT payload is not JSON", exception);
                }
                catch (IOException ioException) {
                    throw new IllegalArgumentException("Failed to read JWT payload", ioException);
                }
                finally {
                    Arrays.fill(jsonPayload, (byte)0);
                }
            }
            finally {
                new TraceControllerImpl().resume();
            }
        }
        finally {
            Arrays.fill(base64Payload, (byte)0);
        }
        if (exp == null) {
            throw new IllegalArgumentException("JWT is missing an exp claim");
        }
        if (!(exp instanceof OracleJsonNumber)) {
            throw new IllegalArgumentException("JWT has an exp claim with a non-numeric value of type: " + exp.getOracleJsonType());
        }
        return Instant.ofEpochSecond(exp.asJsonNumber().longValue()).atOffset(ZoneOffset.UTC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static JsonWebToken requestBearerToken(Builder builder) throws IOException {
        URL url = new URL(builder.endPoint);
        if (!"https".equalsIgnoreCase(url.getProtocol())) {
            throw new IllegalArgumentException("Protocol of endpoint is not https: " + url.getProtocol());
        }
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept", "application/json");
        connection.setSSLSocketFactory(CustomSSLSocketFactory.getSSLSocketFactory(builder.sqlNetOptions, new DMSFactory().new DMSFactory.DMSNoun()));
        connection.setRequestProperty("Date", ZonedDateTime.now(ZoneId.of("Z")).format(DATE_FORMATTER));
        connection.setRequestProperty("Authorization", JsonWebToken.createAuthorization(builder.user, builder.password));
        connection.setDoOutput(true);
        try (OutputStream request = connection.getOutputStream();){
            request.write(String.format("{\"scope\": \"urn:oracle:db::id::%s\", \"tenantId\": \"%s\"}", builder.compartment == null ? "*" : (builder.database == null ? builder.compartment : builder.compartment + "::" + builder.database), builder.tenancy).getBytes(StandardCharsets.UTF_8));
            request.flush();
        }
        try (InputStream response = connection.getInputStream();){
            JsonWebToken jsonWebToken;
            String token = JSON_FACTORY.createJsonTextValue(response).asJsonObject().getString("token");
            if (token == null) {
                throw new IOException("JSON response does not contain a token");
            }
            char[] tokenChars = token.toCharArray();
            try {
                jsonWebToken = JsonWebToken.createBearerToken(tokenChars);
            }
            catch (Throwable throwable) {
                Arrays.fill(tokenChars, '\u0000');
                throw throwable;
            }
            Arrays.fill(tokenChars, '\u0000');
            return jsonWebToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static String createAuthorization(String user, @Blind OpaqueString password) {
        byte[] userColonBytes = (user + ":").getBytes(StandardCharsets.UTF_8);
        ByteBuffer passwordBuffer = password.map(chars -> StandardCharsets.UTF_8.encode(CharBuffer.wrap(chars)));
        try {
            String string;
            byte[] userColonPassword = new byte[userColonBytes.length + passwordBuffer.remaining()];
            try {
                System.arraycopy(userColonBytes, 0, userColonPassword, 0, userColonBytes.length);
                passwordBuffer.get(userColonPassword, userColonBytes.length, passwordBuffer.remaining());
                string = "Basic " + Base64.getEncoder().encodeToString(userColonPassword);
            }
            catch (Throwable throwable) {
                Arrays.fill(userColonPassword, (byte)0);
                throw throwable;
            }
            Arrays.fill(userColonPassword, (byte)0);
            return string;
        }
        finally {
            passwordBuffer.clear();
            passwordBuffer.put(new byte[passwordBuffer.remaining()]);
        }
    }

    public static AccessTokenCache<JsonWebToken> createCache(Supplier<? extends AccessToken> tokenSupplier) {
        return AccessTokenCache.create(() -> {
            AccessToken accessToken = (AccessToken)tokenSupplier.get();
            if (!(accessToken instanceof JsonWebToken)) {
                throw new IllegalArgumentException("token supplier has output an unrecognized object type: " + accessToken.getClass());
            }
            return (JsonWebToken)accessToken;
        });
    }

    static {
        try {
            $$$methodRef$$$12 = JsonWebToken.class.getDeclaredConstructor(OpaqueString.class, OffsetDateTime.class, OpaquePrivateKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = JsonWebToken.class.getDeclaredMethod("lambda$createAuthorization$0", char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = JsonWebToken.class.getDeclaredMethod("lambda$createCache$1", Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = JsonWebToken.class.getDeclaredMethod("createCache", Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = JsonWebToken.class.getDeclaredMethod("createAuthorization", String.class, OpaqueString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = JsonWebToken.class.getDeclaredMethod("requestBearerToken", Builder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = JsonWebToken.class.getDeclaredMethod("parseExp", char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = JsonWebToken.class.getDeclaredMethod("readTokenFile", Path.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = JsonWebToken.class.getDeclaredMethod("createBearerToken", char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = JsonWebToken.class.getDeclaredMethod("createProofOfPossessionToken", char[].class, PrivateKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = JsonWebToken.class.getDeclaredMethod("requestBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = JsonWebToken.class.getDeclaredMethod("fromFile", Path.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = JsonWebToken.class.getDeclaredMethod("fromOciFile", Path.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        JSON_FACTORY = new OracleJsonFactory();
        DATE_FORMATTER = DateTimeFormatter.ofPattern("E, dd MMM uuuu HH:mm:ss z", Locale.US);
        CACHES = Collections.synchronizedMap(new LinkedHashMap<Builder, AccessTokenCache<JsonWebToken>>(16, 0.75f, true){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            protected boolean removeEldestEntry(Map.Entry<Builder, AccessTokenCache<JsonWebToken>> entry) {
                return this.size() > 128;
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(Integer.TYPE, Float.TYPE, Boolean.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("removeEldestEntry", Map.Entry.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
    }

    static final class Builder {
        private String endPoint;
        private String tenancy;
        private String compartment;
        private String database;
        private String user;
        private OpaqueString password;
        private Properties sqlNetOptions;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;

        private Builder() {
        }

        Builder endPoint(String endPoint) {
            this.endPoint = endPoint;
            return this;
        }

        Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        Builder compartment(String compartment) {
            this.compartment = compartment;
            return this;
        }

        Builder database(String database) {
            this.database = database;
            return this;
        }

        Builder user(String user) {
            this.user = user;
            return this;
        }

        Builder password(@Blind OpaqueString password) {
            this.password = password;
            return this;
        }

        Builder sqlNetOptions(Properties sqlNetOptions) {
            this.sqlNetOptions = (Properties)sqlNetOptions.clone();
            return this;
        }

        @Blind
        JsonWebToken build() throws IOException {
            try {
                return (JsonWebToken)CACHES.computeIfAbsent(this, this0 -> JsonWebToken.createCache(() -> {
                    try {
                        return JsonWebToken.requestBearerToken(this);
                    }
                    catch (IOException ioException) {
                        throw new UncheckedIOException(ioException);
                    }
                })).get();
            }
            catch (UncheckedIOException ioException) {
                throw ioException.getCause();
            }
        }

        public boolean equals(Object object) {
            return this == object || object instanceof Builder && Objects.equals(this.endPoint, ((Builder)object).endPoint) && Objects.equals(this.tenancy, ((Builder)object).tenancy) && Objects.equals(this.compartment, ((Builder)object).compartment) && Objects.equals(this.database, ((Builder)object).database) && Objects.equals(this.user, ((Builder)object).user) && Objects.equals(this.password, ((Builder)object).password) && Objects.equals(this.sqlNetOptions, ((Builder)object).sqlNetOptions);
        }

        public int hashCode() {
            return Objects.hash(this.endPoint, this.tenancy, this.compartment, this.database, this.user, this.password, this.sqlNetOptions);
        }

        static {
            try {
                $$$methodRef$$$12 = Builder.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$11 = Builder.class.getDeclaredMethod("lambda$build$0", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$10 = Builder.class.getDeclaredMethod("lambda$build$1", Builder.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$9 = Builder.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = Builder.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = Builder.class.getDeclaredMethod("build", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = Builder.class.getDeclaredMethod("sqlNetOptions", Properties.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = Builder.class.getDeclaredMethod("password", OpaqueString.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = Builder.class.getDeclaredMethod("user", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = Builder.class.getDeclaredMethod("database", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = Builder.class.getDeclaredMethod("compartment", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = Builder.class.getDeclaredMethod("tenancy", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Builder.class.getDeclaredMethod("endPoint", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

