/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.ResponseUtil;
import org.apache.tomcat.util.http.parser.AcceptEncoding;
import org.apache.tomcat.util.http.parser.TE;
import org.apache.tomcat.util.http.parser.TokenList;
import org.apache.tomcat.util.res.StringManager;

public class CompressionConfig {
    private static final Log log = LogFactory.getLog(CompressionConfig.class);
    private static final StringManager sm = StringManager.getManager(CompressionConfig.class);
    private int compressionLevel = 0;
    private Pattern noCompressionUserAgents = null;
    private String compressibleMimeType = "text/html,text/xml,text/plain,text/css,text/javascript,application/javascript,application/json,application/xml";
    private String[] compressibleMimeTypes = null;
    private int compressionMinSize = 2048;

    public void setCompression(String string) {
        if (string.equals("on")) {
            this.compressionLevel = 1;
        } else if (string.equals("force")) {
            this.compressionLevel = 2;
        } else if (string.equals("off")) {
            this.compressionLevel = 0;
        } else {
            try {
                this.setCompressionMinSize(Integer.parseInt(string));
                this.compressionLevel = 1;
            }
            catch (Exception exception) {
                this.compressionLevel = 0;
            }
        }
    }

    public String getCompression() {
        switch (this.compressionLevel) {
            case 0: {
                return "off";
            }
            case 1: {
                return "on";
            }
            case 2: {
                return "force";
            }
        }
        return "off";
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public String getNoCompressionUserAgents() {
        if (this.noCompressionUserAgents == null) {
            return null;
        }
        return this.noCompressionUserAgents.toString();
    }

    public Pattern getNoCompressionUserAgentsPattern() {
        return this.noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String string) {
        this.noCompressionUserAgents = string == null || string.isEmpty() ? null : Pattern.compile(string);
    }

    public String getCompressibleMimeType() {
        return this.compressibleMimeType;
    }

    public void setCompressibleMimeType(String string) {
        this.compressibleMimeType = string;
        this.compressibleMimeTypes = null;
    }

    public String[] getCompressibleMimeTypes() {
        String[] stringArray = this.compressibleMimeTypes;
        if (stringArray != null) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.compressibleMimeType, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            if (string.isEmpty()) continue;
            arrayList.add(string);
        }
        stringArray = arrayList.toArray(new String[0]);
        this.compressibleMimeTypes = stringArray;
        return stringArray;
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int n) {
        this.compressionMinSize = n;
    }

    public boolean useCompression(Request request, Response response) {
        Object object;
        Object object2;
        List<AcceptEncoding> list;
        Object object3;
        if (this.compressionLevel == 0) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = true;
        MimeHeaders mimeHeaders = response.getMimeHeaders();
        MessageBytes messageBytes = mimeHeaders.getValue("Content-Encoding");
        if (messageBytes != null) {
            HashSet<String> hashSet = new HashSet<String>();
            try {
                TokenList.parseTokenList(mimeHeaders.values("Content-Encoding"), hashSet);
            }
            catch (IOException iOException) {
                log.warn((Object)sm.getString("compressionConfig.ContentEncodingParseFail"), (Throwable)iOException);
                return false;
            }
            if (hashSet.contains("identity")) {
                bl2 = false;
            } else if (hashSet.contains("br") || hashSet.contains("compress") || hashSet.contains("dcb") || hashSet.contains("dcz") || hashSet.contains("deflate") || hashSet.contains("gzip") || hashSet.contains("pack200-gzip") || hashSet.contains("zstd")) {
                return false;
            }
        }
        if (this.compressionLevel != 2) {
            long l = response.getContentLengthLong();
            if (l != -1L && l < (long)this.compressionMinSize) {
                return false;
            }
            object3 = this.getCompressibleMimeTypes();
            if (object3 != null && !CompressionConfig.startsWithStringArray((String[])object3, response.getContentType())) {
                return false;
            }
        }
        Enumeration<String> enumeration = request.getMimeHeaders().values("TE");
        boolean bl3 = false;
        block6: while (!bl3 && enumeration.hasMoreElements()) {
            try {
                object3 = TE.parse(new StringReader(enumeration.nextElement()));
            }
            catch (IOException iOException) {
                return false;
            }
            list = object3.iterator();
            while (list.hasNext()) {
                object2 = (TE)list.next();
                if (!"gzip".equalsIgnoreCase(((TE)object2).getEncoding())) continue;
                bl = true;
                bl3 = true;
                continue block6;
            }
        }
        object3 = mimeHeaders.getHeader("ETag");
        if (!bl && object3 != null && !((String)object3).trim().startsWith("W/")) {
            return false;
        }
        if (bl2 && !bl) {
            ResponseUtil.addVaryFieldName(mimeHeaders, "accept-encoding");
            enumeration = request.getMimeHeaders().values("accept-encoding");
            block8: while (!bl3 && enumeration.hasMoreElements()) {
                try {
                    list = AcceptEncoding.parse(new StringReader(enumeration.nextElement()));
                }
                catch (IOException iOException) {
                    return false;
                }
                object2 = list.iterator();
                while (object2.hasNext()) {
                    object = (AcceptEncoding)object2.next();
                    if (!"gzip".equalsIgnoreCase(((AcceptEncoding)object).getEncoding())) continue;
                    bl3 = true;
                    continue block8;
                }
            }
        }
        if (!bl3) {
            return false;
        }
        if (this.compressionLevel != 2 && (list = this.noCompressionUserAgents) != null && (object2 = request.getMimeHeaders().getValue("user-agent")) != null && ((Pattern)((Object)list)).matcher((CharSequence)(object = object2.toString())).matches()) {
            return false;
        }
        response.setContentLength(-1L);
        if (bl) {
            mimeHeaders.addValue("Transfer-Encoding").setString("gzip");
        } else {
            mimeHeaders.addValue("Content-Encoding").setString("gzip");
        }
        return true;
    }

    private static boolean startsWithStringArray(String[] stringArray, String string) {
        if (string == null) {
            return false;
        }
        for (String string2 : stringArray) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }
}

