/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.expression;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.expression.IRepeatableIterator;
import org.eclipse.equinox.internal.p2.metadata.expression.RepeatableIterator;
import org.eclipse.equinox.p2.metadata.index.IIndexProvider;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;

public class QueryResult<T>
implements IQueryResult<T> {
    private final IRepeatableIterator<T> iterator;
    private boolean firstUse = true;

    public QueryResult(Iterator<T> iterator) {
        IRepeatableIterator repeatable;
        this.iterator = iterator instanceof IRepeatableIterator ? (repeatable = (IRepeatableIterator)iterator) : RepeatableIterator.create(iterator);
    }

    public QueryResult(Collection<T> collection) {
        this.iterator = RepeatableIterator.create(collection);
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator.hasNext();
    }

    @Override
    public Iterator<T> iterator() {
        if (this.firstUse) {
            this.firstUse = false;
            return this.iterator;
        }
        return this.iterator.getCopy();
    }

    @Override
    public T[] toArray(Class<T> clazz) {
        Object provider = this.iterator.getIteratorProvider();
        if (provider.getClass().isArray()) {
            return (Object[])provider;
        }
        return QueryResult.toArray(this.toUnmodifiableSet(), clazz);
    }

    @Override
    public Set<T> toSet() {
        Object provider = this.iterator.getIteratorProvider();
        if (provider instanceof Collection) {
            Collection collection = (Collection)provider;
            return new HashSet(collection);
        }
        if (provider instanceof IIndexProvider) {
            IIndexProvider indexProvider = (IIndexProvider)provider;
            return this.iteratorToSet(indexProvider.everything());
        }
        if (provider.getClass().isArray()) {
            Object[] elems = (Object[])provider;
            return new HashSet<Object>(Arrays.asList(elems));
        }
        if (provider instanceof Map) {
            Map map = (Map)provider;
            return new HashSet(map.entrySet());
        }
        return this.iteratorToSet(this.iterator());
    }

    @Override
    public IQueryResult<T> query(IQuery<T> query, IProgressMonitor monitor) {
        return query.perform(this.iterator());
    }

    @Override
    public Set<T> toUnmodifiableSet() {
        Object provider = this.iterator.getIteratorProvider();
        if (provider instanceof Set) {
            Set set = (Set)provider;
            return Collections.unmodifiableSet(set);
        }
        if (provider instanceof Map) {
            Map map = (Map)provider;
            return Collections.unmodifiableSet(map.entrySet());
        }
        return this.toSet();
    }

    private Set<T> iteratorToSet(Iterator<T> iter) {
        HashSet<T> set = new HashSet<T>();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        return set;
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> clazz) {
        Object[] arr = (Object[])Array.newInstance(clazz, collection == null ? 0 : collection.size());
        return collection != null ? collection.toArray(arr) : arr;
    }
}

