// Generated by gmmproc 2.64.2 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_AUDIOSINK_H
#define _GSTREAMERMM_AUDIOSINK_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/audioringbuffer.h>
#include <gstreamermm/audiobasesink.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GstAudioSink = struct _GstAudioSink;
using GstAudioSinkClass = struct _GstAudioSinkClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gst
{ class  AudioSink_Class; } // namespace Gst
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gst
{

/** A simple base class for audio sinks.
 * This is the most simple base class for audio sinks that only requires
 * subclasses to implement a set of simple virtual functions:
 *
 * - open_vfunc() - Open the device.
 * - prepare_vfunc()  - Configure the device with the specified format.
 * - write_vfunc() - Write samples to the device.
 * - reset_vfunc() - Unblock writes and flush the device.
 * - get_delay_vfunc() - Get the number of samples written but not yet played
 * by the device.
 * - unprepare_vfunc() - Undo operations done by prepare.
 * - close_vfunc() - Close the device.
 *
 * All scheduling of samples and timestamps is done in this base class together
 * with Gst::AudioBaseSink using a default implementation of a
 * Gst::AudioRingBuffer that uses threads.
 *
 * Last reviewed on 2016-04-23 (1.8.0)
 *
 * @ingroup GstBaseClasses
 */

class AudioSink : public Gst::AudioBaseSink
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = AudioSink;
  using CppClassType = AudioSink_Class;
  using BaseObjectType = GstAudioSink;
  using BaseClassType = GstAudioSinkClass;

  // noncopyable
  AudioSink(const AudioSink&) = delete;
  AudioSink& operator=(const AudioSink&) = delete;

private:  friend class AudioSink_Class;
  static CppClassType audiosink_class_;

protected:
  explicit AudioSink(const Glib::ConstructParams& construct_params);
  explicit AudioSink(GstAudioSink* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  AudioSink(AudioSink&& src) noexcept;
  AudioSink& operator=(AudioSink&& src) noexcept;

  ~AudioSink() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstAudioSink*       gobj()       { return reinterpret_cast<GstAudioSink*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstAudioSink* gobj() const { return reinterpret_cast<GstAudioSink*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstAudioSink* gobj_copy();

private:


public:
  /** vfunc to open the device. No configuration needs to be done at this
   * point. This function is also used to check if the device is available.
   */
    virtual bool open_vfunc();


  /** vfunc to prepare the device to operate with the specified parameters.
   */
  virtual bool prepare_audiosink_vfunc(Gst::AudioRingBufferSpec& spec);

  /** vfunc to undo operations done in prepare.
   */
    virtual bool unprepare_vfunc();


  /** vfunc to close the device.
   */
    virtual bool close_vfunc();


  /** vfunc to write data to the device.
   */
    virtual int write_vfunc(gpointer data, guint lenght);


  /** vfunc to return how many samples are still in the device. This is used to
   * drive the synchronisation.
   */
    virtual guint get_delay_vfunc() const;


  /** vfunc to return as quickly as possible from a write and flush any pending
   * samples from the device.
   */
    virtual void reset_vfunc();


protected:

  
public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::AudioSink
   */
  
  Glib::RefPtr<Gst::AudioSink> wrap(GstAudioSink* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_AUDIOSINK_H */

