/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Scanner;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJDecompressor;
import org.libjpegturbo.turbojpeg.TJScalingFactor;
import org.libjpegturbo.turbojpeg.TJTransform;
import org.libjpegturbo.turbojpeg.TJTransformer;

final class TJTran {
    static final String CLASS_NAME = new TJTran().getClass().getName();

    private TJTran() {
    }

    private static boolean isCropped(Rectangle rectangle) {
        return rectangle.x != 0 || rectangle.y != 0 || rectangle.width != 0 || rectangle.height != 0;
    }

    static void usage() {
        TJScalingFactor[] tJScalingFactorArray = TJ.getScalingFactors();
        int n = tJScalingFactorArray.length;
        System.out.println("\nUSAGE: java [Java options] " + CLASS_NAME + " [options] <JPEG input image> <JPEG output image>\n");
        System.out.println("This program reads the DCT coefficients from the lossy JPEG input image,");
        System.out.println("optionally transforms them, and writes them to a lossy JPEG output image.\n");
        System.out.println("OPTIONS (CAN BE ABBREVBIATED)");
        System.out.println("-----------------------------");
        System.out.println("-arithmetic");
        System.out.println("    Use arithmetic entropy coding in the output image instead of Huffman");
        System.out.println("    entropy coding (can be combined with -progressive)");
        System.out.println("-copy all");
        System.out.println("    Copy all extra markers (including comments, JFIF thumbnails, Exif data, and");
        System.out.println("    ICC profile data) from the input image to the output image");
        System.out.println("-copy comments");
        System.out.println("    Do not copy any extra markers, except comment markers, from the input");
        System.out.println("    image to the output image [default]");
        System.out.println("-copy icc");
        System.out.println("    Do not copy any extra markers, except ICC profile data, from the input");
        System.out.println("    image to the output image");
        System.out.println("-copy none");
        System.out.println("    Do not copy any extra markers from the input image to the output image");
        System.out.println("-crop WxH+X+Y");
        System.out.println("    Include only the specified region of the input image.  (W, H, X, and Y are");
        System.out.println("    the width, height, left boundary, and upper boundary of the region, all");
        System.out.println("    specified relative to the transformed image dimensions.)  If necessary, X");
        System.out.println("    and Y will be shifted up and left to the nearest iMCU boundary, and W and H");
        System.out.println("    will be increased accordingly.");
        System.out.println("-flip {horizontal|vertical}, -rotate {90|180|270}, -transpose, -transverse");
        System.out.println("    Perform the specified lossless transform operation (these options are");
        System.out.println("    mutually exclusive)");
        System.out.println("-grayscale");
        System.out.println("    Create a grayscale output image from a full-color input image");
        System.out.println("-icc FILE");
        System.out.println("    Embed the ICC (International Color Consortium) color management profile");
        System.out.println("    from the specified file into the output image");
        System.out.println("-maxmemory N");
        System.out.println("    Memory limit (in megabytes) for intermediate buffers used with progressive");
        System.out.println("    JPEG compression, Huffman table optimization, and lossless transformation");
        System.out.println("    [default = no limit]");
        System.out.println("-maxscans N");
        System.out.println("    Refuse to transform progressive JPEG images that have more than N scans");
        System.out.println("-optimize");
        System.out.println("    Use Huffman table optimization in the output image");
        System.out.println("-perfect");
        System.out.println("    Abort if the requested transform operation is imperfect (non-reversible.)");
        System.out.println("    '-flip horizontal', '-rotate 180', '-rotate 270', and '-transverse' are");
        System.out.println("    imperfect if the image width is not evenly divisible by the iMCU width.");
        System.out.println("    '-flip vertical', '-rotate 90', '-rotate 180', and '-transverse' are");
        System.out.println("    imperfect if the image height is not evenly divisible by the iMCU height.");
        System.out.println("-progressive");
        System.out.println("    Create a progressive output image instead of a single-scan output image");
        System.out.println("    (can be combined with -arithmetic; implies -optimize unless -arithmetic is");
        System.out.println("    also specified)");
        System.out.println("-restart N");
        System.out.println("    Add a restart marker every N MCU rows [default = 0 (no restart markers)].");
        System.out.println("    Append 'B' to specify the restart marker interval in MCUs.");
        System.out.println("-trim");
        System.out.println("    If necessary, trim the partial iMCUs at the right or bottom edge of the");
        System.out.println("    image to make the requested transform perfect\n");
        System.exit(1);
    }

    static boolean matchArg(String string, String string2, int n) {
        if (string.length() > string2.length() || string.length() < n) {
            return false;
        }
        int n2 = Math.max(string.length(), n);
        string2 = string2.substring(0, n2);
        return string.equalsIgnoreCase(string2);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        TJDecompressor tJDecompressor = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n2;
            int n3 = 0;
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            int n7 = 0;
            int n8 = -1;
            int n9 = -1;
            int n10 = 1;
            TJTransform[] tJTransformArray = new TJTransform[]{new TJTransform()};
            String string = null;
            int n11 = 0;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                int n12;
                if (TJTran.matchArg(stringArray[n2], "-arithmetic", 2)) {
                    n3 = 1;
                    continue;
                }
                if (TJTran.matchArg(stringArray[n2], "-crop", 3) && n2 < stringArray.length - 1) {
                    n12 = -1;
                    int n13 = -1;
                    int n14 = -1;
                    int n15 = -1;
                    Scanner scanner = new Scanner(stringArray[++n2]).useDelimiter("x|X|\\+");
                    try {
                        n12 = scanner.nextInt();
                        n13 = scanner.nextInt();
                        n14 = scanner.nextInt();
                        n15 = scanner.nextInt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n12 < 1 || n13 < 1 || n14 < 0 || n15 < 0) {
                        TJTran.usage();
                    }
                    tJTransformArray[0].options |= 4;
                    tJTransformArray[0].width = n12;
                    tJTransformArray[0].height = n13;
                    tJTransformArray[0].x = n14;
                    tJTransformArray[0].y = n15;
                    continue;
                }
                if (TJTran.matchArg(stringArray[n2], "-copy", 2) && n2 < stringArray.length - 1) {
                    if (TJTran.matchArg(stringArray[++n2], "all", 1)) {
                        n10 = 2;
                        continue;
                    }
                    if (TJTran.matchArg(stringArray[n2], "icc", 1)) {
                        n10 = 4;
                        continue;
                    }
                    if (TJTran.matchArg(stringArray[n2], "none", 1)) {
                        n10 = 0;
                        continue;
                    }
                    if (TJTran.matchArg(stringArray[n2], "comments", 1)) continue;
                    TJTran.usage();
                    continue;
                }
                if (TJTran.matchArg(stringArray[n2], "-flip", 2) && n2 < stringArray.length - 1) {
                    if (TJTran.matchArg(stringArray[++n2], "horizontal", 1)) {
                        tJTransformArray[0].op = 1;
                        continue;
                    }
                    if (TJTran.matchArg(stringArray[n2], "vertical", 1)) {
                        tJTransformArray[0].op = 2;
                        continue;
                    }
                    TJTran.usage();
                    continue;
                }
                if (TJTran.matchArg(stringArray[n2], "-grayscale", 2) || TJTran.matchArg(stringArray[n2], "-greyscale", 2)) {
                    tJTransformArray[0].options |= 8;
                    continue;
                }
                if (TJTran.matchArg(stringArray[n2], "-icc", 2) && n2 < stringArray.length - 1) {
                    string = stringArray[++n2];
                    continue;
                }
                if (TJTran.matchArg(stringArray[n2], "-maxscans", 5) && n2 < stringArray.length - 1) {
                    n12 = -1;
                    try {
                        n12 = Integer.parseInt(stringArray[++n2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n12 < 0) {
                        TJTran.usage();
                    }
                    n5 = n12;
                    continue;
                }
                if (TJTran.matchArg(stringArray[n2], "-maxmemory", 2) && n2 < stringArray.length - 1) {
                    n12 = -1;
                    try {
                        n12 = Integer.parseInt(stringArray[++n2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n12 < 0) {
                        TJTran.usage();
                    }
                    n4 = n12;
                    continue;
                }
                if (TJTran.matchArg(stringArray[n2], "-optimize", 2) || TJTran.matchArg(stringArray[n2], "-optimise", 2)) {
                    n6 = 1;
                    continue;
                }
                if (TJTran.matchArg(stringArray[n2], "-perfect", 3)) {
                    tJTransformArray[0].options |= 1;
                    continue;
                }
                if (TJTran.matchArg(stringArray[n2], "-progressive", 2)) {
                    n7 = 1;
                    continue;
                }
                if (TJTran.matchArg(stringArray[n2], "-rotate", 3) && n2 < stringArray.length - 1) {
                    if (TJTran.matchArg(stringArray[++n2], "90", 2)) {
                        tJTransformArray[0].op = 5;
                        continue;
                    }
                    if (TJTran.matchArg(stringArray[n2], "180", 3)) {
                        tJTransformArray[0].op = 6;
                        continue;
                    }
                    if (TJTran.matchArg(stringArray[n2], "270", 3)) {
                        tJTransformArray[0].op = 7;
                        continue;
                    }
                    TJTran.usage();
                    continue;
                }
                if (TJTran.matchArg(stringArray[n2], "-restart", 2) && n2 < stringArray.length - 1) {
                    n12 = -1;
                    String string2 = stringArray[++n2];
                    Scanner scanner = new Scanner(string2).useDelimiter("b|B");
                    try {
                        n12 = scanner.nextInt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n12 < 0 || n12 > 65535 || scanner.hasNext()) {
                        TJTran.usage();
                    }
                    if (string2.endsWith("B") || string2.endsWith("b")) {
                        n8 = n12;
                        continue;
                    }
                    n9 = n12;
                    continue;
                }
                if (TJTran.matchArg(stringArray[n2], "-transverse", 7)) {
                    tJTransformArray[0].op = 4;
                    continue;
                }
                if (TJTran.matchArg(stringArray[n2], "-trim", 4)) {
                    tJTransformArray[0].options |= 2;
                    continue;
                }
                if (!TJTran.matchArg(stringArray[n2], "-transpose", 2)) break;
                tJTransformArray[0].op = 3;
            }
            if (n2 != stringArray.length - 2) {
                TJTran.usage();
            }
            if (string != null) {
                if (n10 == 2) {
                    n10 = 3;
                } else if (n10 == 4) {
                    n10 = 0;
                }
            }
            tJDecompressor = new TJTransformer();
            if (n6 >= 0) {
                tJDecompressor.set(11, n6);
            }
            if (n5 >= 0) {
                tJDecompressor.set(13, n5);
            }
            if (n8 >= 0) {
                tJDecompressor.set(18, n8);
            }
            if (n9 >= 0) {
                tJDecompressor.set(19, n9);
            }
            if (n4 >= 0) {
                tJDecompressor.set(23, n4);
            }
            tJDecompressor.set(25, n10);
            File file = new File(stringArray[n2++]);
            fileInputStream = new FileInputStream(file);
            int n16 = fileInputStream.available();
            if (n16 < 1) {
                throw new Exception("Input file contains no data");
            }
            byte[] byArray = new byte[n16];
            fileInputStream.read(byArray);
            fileInputStream.close();
            fileInputStream = null;
            tJDecompressor.setSourceImage(byArray, n16);
            int n17 = tJDecompressor.get(4);
            if ((tJTransformArray[0].options & 8) != 0) {
                n17 = 3;
            }
            if (tJTransformArray[0].op == 3 || tJTransformArray[0].op == 4 || tJTransformArray[0].op == 5 || tJTransformArray[0].op == 7) {
                int n18 = tJDecompressor.get(6);
                int n19 = tJDecompressor.get(5);
                if (n17 == 1) {
                    n17 = 4;
                } else if (n17 == 4) {
                    n17 = 1;
                } else if (n17 == 5) {
                    n17 = 6;
                } else if (n17 == 6) {
                    n17 = 5;
                }
            } else {
                int n20 = tJDecompressor.get(5);
                int n21 = tJDecompressor.get(6);
            }
            if (n7 >= 0) {
                tJDecompressor.set(12, n7);
            }
            if (n3 >= 0) {
                tJDecompressor.set(14, n3);
            }
            if (TJTran.isCropped(tJTransformArray[0])) {
                if (n17 == -1) {
                    throw new Exception("Could not determine subsampling level of input image");
                }
                int n22 = tJTransformArray[0].x % TJ.getMCUWidth(n17);
                int n23 = tJTransformArray[0].y % TJ.getMCUHeight(n17);
                tJTransformArray[0].x -= n22;
                tJTransformArray[0].width += n22;
                tJTransformArray[0].y -= n23;
                tJTransformArray[0].height += n23;
            }
            if (string != null) {
                File file2 = new File(string);
                fileInputStream = new FileInputStream(file2);
                n11 = fileInputStream.available();
                if (n11 < 1) {
                    throw new Exception("ICC profile contains no data");
                }
                byte[] byArray2 = new byte[n11];
                fileInputStream.read(byArray2);
                fileInputStream.close();
                fileInputStream = null;
                ((TJTransformer)tJDecompressor).setICCProfile(byArray2);
            }
            TJDecompressor[] tJDecompressorArray = ((TJTransformer)tJDecompressor).transform(tJTransformArray);
            File file3 = new File(stringArray[n2]);
            fileOutputStream = new FileOutputStream(file3);
            fileOutputStream.write(tJDecompressorArray[0].getJPEGBuf(), 0, tJDecompressorArray[0].getJPEGSize());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = -1;
        }
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (tJDecompressor != null) {
                tJDecompressor.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(n);
    }
}

