/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.CommunicatorDestroyedException;
import com.zeroc.Ice.ConnectionI;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice._ObjectPrxI;
import com.zeroc.IceInternal.ConnectionRequestHandler;
import com.zeroc.IceInternal.OutgoingAsyncBase;
import com.zeroc.IceInternal.ProxyOutgoingAsyncBase;
import com.zeroc.IceInternal.QueueRequestHandler;
import com.zeroc.IceInternal.Reference;
import com.zeroc.IceInternal.RequestHandler;
import com.zeroc.IceInternal.RetryException;
import com.zeroc.IceInternal.RouterInfo;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;

public class ConnectRequestHandler
implements RequestHandler,
Reference.GetConnectionCallback,
RouterInfo.AddProxyCallback {
    private final Reference _reference;
    private boolean _response;
    private _ObjectPrxI _proxy;
    private Set<_ObjectPrxI> _proxies = new HashSet<_ObjectPrxI>();
    private ConnectionI _connection;
    private boolean _compress;
    private LocalException _exception;
    private boolean _initialized;
    private boolean _flushing;
    private List<ProxyOutgoingAsyncBase> _requests = new LinkedList<ProxyOutgoingAsyncBase>();
    private RequestHandler _requestHandler;

    public synchronized RequestHandler connect(_ObjectPrxI proxy) {
        if (!this.initialized()) {
            this._proxies.add(proxy);
        }
        return this._requestHandler;
    }

    @Override
    public RequestHandler update(RequestHandler previousHandler, RequestHandler newHandler) {
        return previousHandler == this ? newHandler : this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendAsyncRequest(ProxyOutgoingAsyncBase out) throws RetryException {
        ConnectRequestHandler connectRequestHandler = this;
        synchronized (connectRequestHandler) {
            if (!this._initialized) {
                out.cancelable(this);
            }
            if (!this.initialized()) {
                this._requests.add(out);
                return 0;
            }
        }
        return out.invokeRemote(this._connection, this._compress, this._response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncRequestCanceled(OutgoingAsyncBase outAsync, LocalException ex) {
        ConnectRequestHandler connectRequestHandler = this;
        synchronized (connectRequestHandler) {
            if (this._exception != null) {
                return;
            }
            if (!this.initialized()) {
                Iterator<ProxyOutgoingAsyncBase> it = this._requests.iterator();
                while (it.hasNext()) {
                    OutgoingAsyncBase request = it.next();
                    if (request != outAsync) continue;
                    it.remove();
                    if (outAsync.completed(ex)) {
                        outAsync.invokeCompletedAsync();
                    }
                    return;
                }
                assert (false);
            }
        }
        this._connection.asyncRequestCanceled(outAsync, ex);
    }

    @Override
    public Reference getReference() {
        return this._reference;
    }

    @Override
    public synchronized ConnectionI getConnection() {
        if (this._connection != null) {
            return this._connection;
        }
        if (this._exception != null) {
            throw (LocalException)this._exception.fillInStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnection(ConnectionI connection, boolean compress) {
        ConnectRequestHandler connectRequestHandler = this;
        synchronized (connectRequestHandler) {
            assert (!this._flushing && this._exception == null && this._connection == null);
            this._connection = connection;
            this._compress = compress;
        }
        RouterInfo ri = this._reference.getRouterInfo();
        if (ri != null && !ri.addProxy(this._proxy, this)) {
            return;
        }
        this.flushRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setException(LocalException ex) {
        Object object = this;
        synchronized (object) {
            assert (!this._flushing && !this._initialized && this._exception == null);
            this._exception = ex;
            this._flushing = true;
        }
        try {
            this._reference.getInstance().requestHandlerFactory().removeRequestHandler(this._reference, this);
        }
        catch (CommunicatorDestroyedException communicatorDestroyedException) {
            // empty catch block
        }
        for (OutgoingAsyncBase outgoingAsyncBase : this._requests) {
            if (!outgoingAsyncBase.completed(this._exception)) continue;
            outgoingAsyncBase.invokeCompletedAsync();
        }
        this._requests.clear();
        object = this;
        synchronized (object) {
            this._flushing = false;
            this._proxies.clear();
            this._proxy = null;
            this.notifyAll();
        }
    }

    @Override
    public void addedProxy() {
        this.flushRequests();
    }

    public ConnectRequestHandler(Reference ref, _ObjectPrxI proxy) {
        this._reference = ref;
        this._response = this._reference.getMode() == 0;
        this._proxy = proxy;
        this._initialized = false;
        this._flushing = false;
        this._requestHandler = this._reference.getInstance().queueRequests() ? new QueueRequestHandler(this._reference.getInstance(), this) : this;
    }

    private boolean initialized() {
        if (this._initialized) {
            assert (this._connection != null);
            return true;
        }
        boolean interrupted = false;
        while (this._flushing) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (this._exception != null) {
            if (this._connection != null) {
                return true;
            }
            throw (LocalException)this._exception.fillInStackTrace();
        }
        return this._initialized;
    }

    private void flushRequests() {
        if (this._reference.getInstance().queueRequests()) {
            this._reference.getInstance().getQueueExecutor().executeNoThrow(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ConnectRequestHandler.this.flushRequestsImpl();
                    return null;
                }
            });
        } else {
            this.flushRequestsImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushRequestsImpl() {
        ConnectRequestHandler connectRequestHandler = this;
        synchronized (connectRequestHandler) {
            assert (this._connection != null && !this._initialized);
            this._flushing = true;
        }
        LocalException exception = null;
        for (ProxyOutgoingAsyncBase outAsync : this._requests) {
            try {
                if ((outAsync.invokeRemote(this._connection, this._compress, this._response) & 2) <= 0) continue;
                outAsync.invokeSentAsync();
            }
            catch (RetryException ex) {
                exception = ex.get();
                this._reference.getInstance().requestHandlerFactory().removeRequestHandler(this._reference, this);
                outAsync.retryException(ex.get());
            }
            catch (LocalException ex) {
                exception = ex;
                if (!outAsync.completed(ex)) continue;
                outAsync.invokeCompletedAsync();
            }
        }
        this._requests.clear();
        if (this._reference.getCacheConnection() && exception == null) {
            RequestHandler previous = this._requestHandler;
            this._requestHandler = new ConnectionRequestHandler(this._reference, this._connection, this._compress);
            if (this._reference.getInstance().queueRequests()) {
                this._requestHandler = new QueueRequestHandler(this._reference.getInstance(), this._requestHandler);
            }
            for (_ObjectPrxI proxy : this._proxies) {
                proxy._updateRequestHandler(previous, this._requestHandler);
            }
        }
        ConnectRequestHandler connectRequestHandler2 = this;
        synchronized (connectRequestHandler2) {
            assert (!this._initialized);
            this._exception = exception;
            this._initialized = this._exception == null;
            this._flushing = false;
            this._reference.getInstance().requestHandlerFactory().removeRequestHandler(this._reference, this);
            this._proxies.clear();
            this._proxy = null;
            this.notifyAll();
        }
    }
}

