#!BPY
"""
Name: 'Diamond'
Blender: 248
Group: 'AddMesh'
"""
__author__ = ["Four Mad Men", "FourMadMen.com"]
__version__ = '1.00'
__url__ = ["http://wiki.blender.org/index.php/Extensions:Py/Scripts/Manual/Add/Diamond"]
__email__=["bwiki {at} fourmadmen {dot} com"]


__bpydoc__ = """

Usage:

* Launch from Add Mesh menu

* Modify parameters as desired or keep defaults

"""
# ***** BEGIN GPL LICENSE BLOCK *****
#
# Copyright (C) 2008, FourMadMen.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****

import BPyAddMesh
import Blender

def add_diamond(PREF_SEG, PREF_GRD_RAD, PREF_TBL_RAD, PREF_CRN_HGT, PREF_PAV_HGT):
	Vector = Blender.Mathutils.Vector
	RotationMatrix = Blender.Mathutils.RotationMatrix
	verts = []
	faces = []
	
	tot_verts = PREF_SEG * 2 + 2
	
	height = PREF_CRN_HGT + PREF_PAV_HGT
	half_height = height * .5
	
	verts.append( Vector(0, 0, half_height) )
	verts.append( Vector(0, 0, -half_height) )
	
	i = 2
	for index in xrange(PREF_SEG):
		mtx = RotationMatrix( 360 * float(index)/PREF_SEG, 3, 'z' )
		
		verts.append( Vector(PREF_TBL_RAD, 0, half_height) * mtx )
		it1 = i
		i+=1
		
		verts.append( Vector(PREF_GRD_RAD, 0, -half_height+PREF_PAV_HGT) * mtx )
		ib1 = i
		i+=1
		
		if i>4:
			faces.append( (it2, it1, 0) )
			faces.append( (it1, it2, ib2, ib1) )
			faces.append( (ib1, ib2, 1) )
		
		it2 = it1
		ib2 = ib1
		
	faces.append( (tot_verts-2, 2, 0) )
	faces.append( (3, 2, tot_verts-2, tot_verts-1) )
	faces.append( (3, tot_verts-1, 1) )
	
	return verts, faces

def main():
	Draw = Blender.Draw
	PREF_SEG = Draw.Create(32)
	PREF_GRD_RAD = Draw.Create(1.0)
	PREF_TBL_RAD = Draw.Create(0.8)
	PREF_CRN_HGT = Draw.Create(0.25)
	PREF_PAV_HGT = Draw.Create(1.00)
	
	if not Draw.PupBlock('Add Diamond', [\
	('Segments:', PREF_SEG,  3, 256, 'Number of segments of the diamond'),\
	('Girdle Radius:', PREF_GRD_RAD,  0.01, 100, 'Girdle (i.e. Overall) Radius of the diamond'),\
	('Table Radius:', PREF_TBL_RAD,  0.01, 100, 'Table Radius of the diamond'),\
	('Crown Height:', PREF_CRN_HGT,  0.01, 100, 'Crown Height (i.e. Top) of the diamond'),\
	('Pavillion Height:', PREF_PAV_HGT,  0.01, 100, 'Pavillion Height (i.e. Bottom) of the diamond'),\
	]):
		return
	
	verts, faces = add_diamond(PREF_SEG.val, PREF_GRD_RAD.val, PREF_TBL_RAD.val, PREF_CRN_HGT.val, PREF_PAV_HGT.val)
	
	BPyAddMesh.add_mesh_simple('Diamond', verts, [], faces)

main()

